/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionComponent;
import com.sardak.antform.interfaces.Focusable;
import com.sardak.antform.types.BaseType;
import com.sardak.antform.types.Button;
import com.sardak.antform.util.ActionRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.tools.ant.Task;

public class ButtonBar
extends BaseType
implements Focusable {
    private List buttons = new ArrayList();
    private Object align = "Center";
    private JPanel mainPanel;

    public void addConfiguredButton(Button button) {
        this.buttons.add(button);
    }

    public List getButtons() {
        return this.buttons;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.buildMainPanel();
        this.applyStylesheet(panel);
        panel.addCentered(this.mainPanel);
    }

    public boolean validate(Task task) {
        boolean valid = true;
        if (this.buttons.isEmpty()) {
            task.log("ButtonBar : no button configured.");
            valid = false;
        }
        Iterator iter = this.buttons.iterator();
        while (iter.hasNext()) {
            Button button = (Button)iter.next();
            if (button.validate(task)) continue;
            valid = false;
        }
        return valid;
    }

    public void addLink(Button button) {
        this.log("<link> nested elements are deprecated. Use <button> instead.");
        this.buttons.add(button);
    }

    public void register(ActionRegistry actionRegistry) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            actionRegistry.register((ActionComponent)this.buttons.get(i));
        }
    }

    public void setAlign(Object align) {
        this.align = align;
    }

    public JPanel getPanel() {
        this.buildMainPanel();
        return this.mainPanel;
    }

    public boolean isEmpty() {
        return this.getButtons().size() == 0;
    }

    private void buildMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            BorderLayout mainLayout = new BorderLayout(0, 0);
            this.mainPanel.setLayout(mainLayout);
            JPanel innerPanel = new JPanel(new GridLayout(1, 0, 3, 0));
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                Button button = (Button)iter.next();
                JButton buttonComponent = (JButton)button.getComponent();
                innerPanel.add(buttonComponent);
            }
            this.mainPanel.add((Component)innerPanel, this.align);
        }
    }

    public void applyStylesheet(ControlPanel panel) {
        Iterator iter = this.buttons.iterator();
        while (iter.hasNext()) {
            Button button = (Button)iter.next();
            JButton buttonComponent = (JButton)button.getComponent();
            panel.getStylesheetHandler().addLink(buttonComponent);
        }
    }

    public void setMargins(int top, int left, int bottom, int right) {
        this.getPanel().setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public void setFocus(boolean focus) {
    }

    public boolean isFocus() {
        boolean focus = false;
        Iterator iter = this.buttons.iterator();
        while (iter.hasNext()) {
            Button button = (Button)iter.next();
            if (!button.isFocus()) continue;
            focus = true;
            break;
        }
        return focus;
    }

    public JComponent getFocusableComponent() {
        JComponent c = null;
        Iterator iter = this.buttons.iterator();
        while (iter.hasNext()) {
            Button button = (Button)iter.next();
            if (!button.isFocus()) continue;
            c = button.getFocusableComponent();
            break;
        }
        return c;
    }
}

