/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.logging.Logger;
import com.vladium.util.IProperties;
import java.util.HashSet;
import java.util.StringTokenizer;

public abstract class AppLoggers {
    public static final String PREFIX_VERBOSITY = "verbosity.";
    public static final String PROPERTY_VERBOSITY_LEVEL = "verbosity.level";
    public static final String DEFAULT_VERBOSITY_LEVEL = "info";
    public static final String PROPERTY_VERBOSITY_FILTER = "verbosity.filter";
    private static final String COMMA_DELIMITERS = ", \t\r\n";

    public static Logger create(String appName, IProperties properties, Logger base) {
        StringTokenizer tokenizer;
        if (properties == null) {
            throw new IllegalArgumentException("null input: properties");
        }
        String _level = properties.getProperty(PROPERTY_VERBOSITY_LEVEL, DEFAULT_VERBOSITY_LEVEL);
        int level = Logger.stringToLevel(_level);
        String _filter = properties.getProperty(PROPERTY_VERBOSITY_FILTER);
        HashSet<String> temp = null;
        if (_filter != null && (tokenizer = new StringTokenizer(_filter, COMMA_DELIMITERS)).countTokens() > 0) {
            temp = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                temp.add(tokenizer.nextToken());
            }
        }
        HashSet<String> filter = temp;
        return Logger.create(level, null, appName, filter, base);
    }

    private AppLoggers() {
    }
}

