/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.CategorizationHandler;
import com.nokia.helium.metadata.ant.types.CategoryEntry;
import com.nokia.helium.metadata.ant.types.TimeEntry;
import com.nokia.helium.metadata.ant.types.XMLLogMetaDataInput;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class SBSLogMetaDataInput
extends XMLLogMetaDataInput {
    private static final String SPECIAL_CASE_REG_EX = "(make.exe|make): \\*\\*\\*.*(/.*)(_exe|_dll|_pdd|_ldd|_kext|_lib)/.*";
    private static final String DRIVE_LETTER_REGEX = "(([a-z]|[A-Z]):(\\\\|/))(.*)(/bld\\.inf)";
    private Logger log = Logger.getLogger(SBSLogMetaDataInput.class);
    private String currentComponent;
    private float currentElapsedTime;
    private String logTextInfo = "";
    private HashMap<String, List<CategoryEntry>> generalTextEntries = new HashMap();
    private CategorizationHandler categorizationHandler;
    private int lineNumber;
    private boolean recordText;
    private File cleanLogFile;
    private boolean additionalEntry;
    private Pattern specialCasePattern;
    private HashMap<String, TimeEntry> componentTimeMap = new HashMap();

    public SBSLogMetaDataInput() {
        this.specialCasePattern = Pattern.compile(SPECIAL_CASE_REG_EX);
    }

    static String removeDriveAndBldInf(String text) {
        Matcher matcher = Pattern.compile(DRIVE_LETTER_REGEX).matcher(text);
        if (matcher.matches()) {
            return matcher.group(4);
        }
        return text;
    }

    static String getComponent(XMLStreamReader streamReader) {
        String currentComponent = SBSLogMetaDataInput.getAttribute("bldinf", streamReader);
        if (currentComponent != null && currentComponent.equals("")) {
            return null;
        }
        if (currentComponent != null) {
            currentComponent = SBSLogMetaDataInput.removeDriveAndBldInf(currentComponent);
        }
        return currentComponent;
    }

    static String getAttribute(String attribute, XMLStreamReader streamReader) {
        int count = streamReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!streamReader.getAttributeLocalName(i).equals(attribute)) continue;
            return streamReader.getAttributeValue(i);
        }
        return null;
    }

    public void setCleanLogFile(File logFile) {
        this.cleanLogFile = logFile;
    }

    @Override
    public boolean characters(XMLStreamReader streamReader) {
        if (this.recordText) {
            this.logTextInfo = this.logTextInfo + streamReader.getText();
        } else {
            String[] textList;
            if (!this.additionalEntry) {
                this.additionalEntry = true;
            }
            String cdataText = streamReader.getText().trim();
            for (String text : textList = cdataText.split("\n")) {
                int indexExt;
                Matcher specialCaseMatcher = this.specialCasePattern.matcher(text);
                List<CategoryEntry> entryList = null;
                if (specialCaseMatcher.matches()) {
                    String componentName = specialCaseMatcher.group(2);
                    String extension = specialCaseMatcher.group(3);
                    String componentWithTarget = (componentName.substring(1) + "." + extension.substring(1)).toLowerCase();
                    CategoryEntry newEntry = new CategoryEntry(text, componentWithTarget, "error", streamReader.getLocation().getLineNumber(), this.getCurrentFile().toString());
                    entryList = this.generalTextEntries.get(componentWithTarget);
                    if (entryList == null) {
                        entryList = new ArrayList<CategoryEntry>();
                        this.generalTextEntries.put(componentWithTarget, entryList);
                    }
                    entryList.add(newEntry);
                    continue;
                }
                String componentWithTarget = null;
                int indexMakeString = text.indexOf("make: ***");
                int indexSlash = text.lastIndexOf("/");
                if (indexMakeString != -1 && indexSlash != -1 && (indexExt = indexSlash + 1 + text.substring(indexSlash).indexOf(".")) != -1) {
                    componentWithTarget = text.substring(indexSlash, indexExt + 3).toLowerCase();
                }
                if (componentWithTarget == null) continue;
                CategoryEntry newEntry = new CategoryEntry(text, componentWithTarget, "error", streamReader.getLocation().getLineNumber(), this.getCurrentFile().toString());
                entryList = this.generalTextEntries.get(componentWithTarget);
                if (entryList == null) {
                    entryList = new ArrayList<CategoryEntry>();
                    this.generalTextEntries.put(componentWithTarget, entryList);
                }
                entryList.add(newEntry);
            }
        }
        return false;
    }

    @Override
    public boolean startElement(XMLStreamReader streamReader) throws Exception {
        try {
            String tagName = streamReader.getLocalName();
            if (tagName.equalsIgnoreCase("buildlog")) {
                this.log.debug((Object)"starting with buildlog");
            }
            if (tagName.equalsIgnoreCase("recipe")) {
                this.lineNumber = streamReader.getLocation().getLineNumber();
                this.currentComponent = SBSLogMetaDataInput.getComponent(streamReader);
                this.recordText = true;
            } else if (tagName.equalsIgnoreCase("error") || tagName.equalsIgnoreCase("warning")) {
                this.lineNumber = streamReader.getLocation().getLineNumber();
                this.currentComponent = SBSLogMetaDataInput.getComponent(streamReader);
                this.recordText = true;
            } else if (tagName.equalsIgnoreCase("whatlog")) {
                this.currentComponent = SBSLogMetaDataInput.getComponent(streamReader);
            } else if (tagName.equalsIgnoreCase("time")) {
                this.currentElapsedTime = Float.valueOf(SBSLogMetaDataInput.getAttribute("elapsed", streamReader)).floatValue();
                if (this.currentComponent != null) {
                    TimeEntry timeObject = this.componentTimeMap.get(this.currentComponent);
                    if (timeObject == null) {
                        timeObject = new TimeEntry(this.currentElapsedTime, this.getCurrentFile().toString());
                        this.componentTimeMap.put(this.currentComponent, timeObject);
                    } else {
                        timeObject.addElapsedTime(this.currentElapsedTime);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception in startelement", (Throwable)ex);
            throw ex;
        }
        return false;
    }

    @Override
    public boolean isAdditionalEntry() {
        block7: {
            try {
                Set<String> componentSet;
                Iterator<String> i$;
                if (!this.componentTimeMap.isEmpty() && (i$ = (componentSet = this.componentTimeMap.keySet()).iterator()).hasNext()) {
                    String component = i$.next();
                    TimeEntry entry = this.componentTimeMap.get(component);
                    this.addEntry("default", component, entry.getFilePath(), -1, null, entry.getElapsedTime());
                    this.componentTimeMap.remove(component);
                    return true;
                }
                if (this.cleanLogFile != null && this.categorizationHandler == null) {
                    this.log.info((Object)"initializing categorization handler");
                    this.categorizationHandler = new CategorizationHandler(this.cleanLogFile, this.generalTextEntries);
                }
                if (this.categorizationHandler == null || !this.categorizationHandler.hasNext()) break block7;
                try {
                    CategoryEntry entry = this.categorizationHandler.getNext();
                    if (entry != null) {
                        this.addEntry(entry.getSeverity(), entry.getCategory(), entry.getLogFile(), entry.getLineNumber(), entry.getText());
                        return true;
                    }
                }
                catch (Exception ex) {
                    this.log.debug((Object)"Exception during categorization handler", (Throwable)ex);
                    return false;
                }
            }
            catch (Exception ex) {
                this.log.debug((Object)"Exception in finding additional entry", (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public boolean endElement(XMLStreamReader streamReader) throws Exception {
        try {
            String tagName = streamReader.getLocalName();
            if (tagName.equalsIgnoreCase("recipe")) {
                this.recordText = false;
                if (this.logTextInfo != null) {
                    if (this.currentComponent == null) {
                        this.currentComponent = "general";
                    }
                    boolean entryCreated = this.findAndAddEntries(this.logTextInfo, this.currentComponent, this.getCurrentFile().toString(), this.lineNumber);
                    this.logTextInfo = "";
                    if (entryCreated) {
                        return true;
                    }
                }
            } else {
                if (tagName.equalsIgnoreCase("error") || tagName.equalsIgnoreCase("warning")) {
                    this.recordText = false;
                    if (this.currentComponent == null) {
                        this.currentComponent = "general";
                    }
                    this.addEntry(tagName, this.currentComponent, this.getCurrentFile().toString(), this.lineNumber, this.logTextInfo);
                    this.logTextInfo = "";
                    return true;
                }
                if (tagName.equalsIgnoreCase("whatlog")) {
                    this.addEntry("default", this.currentComponent, this.getCurrentFile().toString(), -1, "");
                    return true;
                }
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"Exception while processing for sbs metadata input", (Throwable)ex);
            throw ex;
        }
        return false;
    }
}

