/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.LogMetaDataInput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TextLogMetaDataInput
extends LogMetaDataInput {
    private Logger log = Logger.getLogger(TextLogMetaDataInput.class);
    private int lineNumber;
    private BufferedReader currentReader;

    protected void setLineNumber(int lineNo) {
        this.lineNumber = lineNo;
    }

    protected int getLineNumber() {
        return this.lineNumber;
    }

    protected void setCurrentReader(BufferedReader reader) {
        this.currentReader = reader;
    }

    public boolean isAdditionalEntry() {
        return false;
    }

    protected BufferedReader getCurrentReader() {
        return this.currentReader;
    }

    @Override
    public boolean isEntryCreated(File currentFile) throws Exception {
        String exceptions = "";
        try {
            if (this.currentReader == null) {
                this.lineNumber = 0;
                this.log.debug((Object)("Current Text log file name:" + currentFile));
                this.log.debug((Object)("Processing file: " + currentFile));
                this.currentReader = new BufferedReader(new FileReader(currentFile));
            }
            String logText = null;
            while ((logText = this.currentReader.readLine()) != null) {
                String severity = this.getSeverity(logText = logText.replaceFirst("^[ ]*\\[.+?\\][ ]*", ""));
                if (severity == null) continue;
                this.addEntry(severity, currentFile.getName(), currentFile.toString(), this.lineNumber, logText);
                ++this.lineNumber;
                return true;
            }
            this.currentReader.close();
            this.currentReader = null;
            if (this.isAdditionalEntry()) {
                return true;
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"Exception in TextLogMetadata", (Throwable)ex);
            try {
                this.currentReader.close();
                this.currentReader = null;
            }
            catch (Exception ex1) {
                this.log.debug((Object)"Exception in TextLogMetadata", (Throwable)ex1);
                try {
                    this.currentReader.close();
                }
                catch (IOException iex) {
                    this.log.debug((Object)"Exception in closing reader", (Throwable)iex);
                }
                this.currentReader = null;
                exceptions = exceptions + ex.getMessage() + "\n";
                return false;
            }
        }
        if (!exceptions.equals("")) {
            throw new Exception(exceptions);
        }
        return false;
    }
}

