/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.logger.ant.taskdefs;

import com.nokia.helium.logger.ant.listener.AntLogRecorderEntry;
import com.nokia.helium.logger.ant.listener.AntLoggingHandler;
import com.nokia.helium.logger.ant.listener.Handler;
import com.nokia.helium.logger.ant.listener.StatusAndLogListener;
import com.nokia.helium.logger.ant.types.RecordFilter;
import com.nokia.helium.logger.ant.types.RecordFilterSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.LogLevel;

public class LogRecorder
extends Task
implements Handler {
    private static Hashtable<String, AntLogRecorderEntry> recorderEntries = new Hashtable();
    private String fileName;
    private Boolean append;
    private Boolean start;
    private int loglevel = -1;
    private boolean emacsMode;
    private Vector<RecordFilter> recordFilters = new Vector();
    private Vector<RecordFilterSet> recordFilterSet = new Vector();
    private Vector<String> regExpList = new Vector();

    public void execute() {
        AntLoggingHandler antLoggingHandler = (AntLoggingHandler)StatusAndLogListener.getHandler(AntLoggingHandler.class);
        this.validateAttributes();
        this.addAllRecordFilters();
        this.initAndReplaceProperties();
        AntLogRecorderEntry recorder = this.getRecorder(this.fileName, this.getProject());
        recorder.setMessageOutputLevel(this.loglevel);
        recorder.setEmacsMode(this.emacsMode);
        if (this.start != null) {
            if (this.start.booleanValue()) {
                if (antLoggingHandler != null) {
                    if (antLoggingHandler.getCurrentStageName() != null) {
                        antLoggingHandler.doLoggingAction(antLoggingHandler.getCurrentStageName(), false, "Stopping", this);
                    } else {
                        antLoggingHandler.doLoggingAction("default", false, "Stopping", this);
                    }
                }
                recorder.reopenFile();
                recorder.setRecordState(this.start);
            } else {
                recorder.setRecordState(this.start);
                recorder.closeFile();
                if (antLoggingHandler != null) {
                    if (antLoggingHandler.getCurrentStageName() != null) {
                        antLoggingHandler.doLoggingAction(antLoggingHandler.getCurrentStageName(), true, "Starting", this);
                    } else {
                        antLoggingHandler.doLoggingAction("default", true, "Starting", this);
                    }
                }
            }
        }
    }

    private void validateAttributes() {
        if (this.fileName == null) {
            throw new BuildException("filename attribute should be specified for helium recorder task.");
        }
    }

    public void setName(String fileName) {
        this.fileName = fileName;
    }

    public String getName() {
        return this.fileName;
    }

    public void setAppend(boolean append) {
        this.append = append ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setLoglevel(VerbosityLevelChoices level) {
        this.loglevel = level.getLevel();
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public boolean getEmacsMode() {
        return this.emacsMode;
    }

    public void addRecordFilter(RecordFilter logFilter) {
        if (!this.recordFilters.contains((Object)logFilter)) {
            this.recordFilters.add(logFilter);
        }
    }

    public void addRecordFilterSet(RecordFilterSet logFilterSet) {
        if (!this.recordFilterSet.contains((Object)logFilterSet)) {
            this.recordFilterSet.add(logFilterSet);
        }
    }

    public void setAction(ActionChoices action) {
        this.start = action.getValue().equalsIgnoreCase("start") ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean getAction() {
        return this.start;
    }

    protected AntLogRecorderEntry getRecorder(String name, Project proj) {
        AntLogRecorderEntry entry;
        AntLogRecorderEntry o = recorderEntries.get(name);
        if (o == null) {
            entry = new AntLogRecorderEntry(name);
            for (String regExp : this.regExpList) {
                if (regExp.equals("")) continue;
                String pattern = Pattern.quote(regExp);
                entry.addRegexp(pattern);
            }
            if (this.append == null) {
                entry.openFile(false);
            } else {
                entry.openFile(this.append);
            }
            entry.setProject(proj);
            recorderEntries.put(name, entry);
        } else {
            entry = o;
        }
        return entry;
    }

    public void addAllRecordFilters() {
        for (RecordFilterSet recFilterSet : this.recordFilterSet) {
            this.recordFilters.addAll(recFilterSet.getAllFilters());
        }
    }

    @Override
    public void handleBuildFinished(BuildEvent event) {
    }

    @Override
    public void handleBuildStarted(BuildEvent event) {
    }

    @Override
    public void handleTargetFinished(BuildEvent event) {
    }

    @Override
    public void handleTargetStarted(BuildEvent event) {
    }

    public void initAndReplaceProperties() {
        Pattern pattern = null;
        Matcher match = null;
        for (RecordFilter recordFilter : this.recordFilters) {
            if (recordFilter.getRegExp() == null) {
                throw new BuildException("\"regexp\" attribute should not have null value for recordfilter");
            }
            if (recordFilter.getRegExp() == null) continue;
            pattern = Pattern.compile("\\$\\{(.*)}");
            match = pattern.matcher(recordFilter.getRegExp());
            if (match.find()) {
                this.regExpList.add(this.getProject().replaceProperties(recordFilter.getRegExp()));
                continue;
            }
            this.regExpList.add(recordFilter.getRegExp());
        }
    }

    public static class VerbosityLevelChoices
    extends LogLevel {
    }

    public static class ActionChoices
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"start", "stop"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

