/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.taskdefs;

import com.nokia.helium.metadata.MetaDataInput;
import com.nokia.helium.metadata.db.MetaDataDb;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MetaDataRecord
extends Task {
    private static Logger log = Logger.getLogger(MetaDataRecord.class);
    private String database;
    private boolean failOnError = true;
    private Vector<MetaDataInput> metadataList = new Vector();

    public void setDatabase(String dbFile) {
        this.database = dbFile;
    }

    public void setFailOnError(String failNotify) {
        if (failNotify.equals("false")) {
            this.failOnError = false;
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public Vector<MetaDataInput> getMetaDataList() throws Exception {
        if (this.metadataList.isEmpty()) {
            throw new Exception("metadata list is empty");
        }
        return this.metadataList;
    }

    public void add(MetaDataInput interf) {
        this.metadataList.add(interf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        MetaDataDb metadataDb = null;
        try {
            log.debug((Object)("Getting Contents to write to db: " + this.database));
            log.debug((Object)("Initializing DB: " + this.database));
            metadataDb = new MetaDataDb(this.database);
            log.debug((Object)"Parsing the input and writing to DB");
            this.log("time before recording to db" + new Date());
            for (MetaDataInput metadataInput : this.metadataList) {
                boolean removed = false;
                Iterator<MetaDataDb.LogEntry> inputIterator = metadataInput.iterator();
                while (inputIterator.hasNext()) {
                    MetaDataDb.LogEntry logEntry = inputIterator.next();
                    if (!removed) {
                        metadataDb.removeLog(logEntry.getLogPath());
                    }
                    removed = true;
                    metadataDb.addLogEntry(logEntry);
                }
            }
            this.log("time after recording to db" + new Date());
            log.debug((Object)"Successfully writen to DB");
        }
        catch (BuildException ex1) {
            if (this.failOnError) {
                throw ex1;
            }
        }
        catch (Exception ex) {
            if (this.failOnError) {
                throw new BuildException("Failed during writing data to db");
            }
        }
        finally {
            log.debug((Object)("finalizing DB: " + this.database));
            if (metadataDb != null) {
                metadataDb.finalizeDB();
            }
        }
    }
}

