/*
 * Decompiled with CFR 0.152.
 */
package com.elharo.xml.xinclude;

import com.elharo.xml.xinclude.BadParseAttributeException;
import com.elharo.xml.xinclude.CircularIncludeException;
import com.elharo.xml.xinclude.EncodingHeuristics;
import com.elharo.xml.xinclude.MalformedResourceException;
import com.elharo.xml.xinclude.MissingHrefException;
import com.elharo.xml.xinclude.UnavailableResourceException;
import com.elharo.xml.xinclude.XIncludeException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMXIncluder {
    public static final String XINCLUDE_NAMESPACE = "http://www.w3.org/2001/XInclude";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder parser;

    private DOMXIncluder() throws ParserConfigurationException {
        this.factory.setNamespaceAware(true);
        this.factory.setCoalescing(true);
        this.parser = this.factory.newDocumentBuilder();
    }

    public static Document merge(Document document, String string) throws XIncludeException, NullPointerException, ParserConfigurationException {
        DOMXIncluder dOMXIncluder = new DOMXIncluder();
        return dOMXIncluder.resolve(document, string);
    }

    private Document resolve(Document document, String string) throws XIncludeException, NullPointerException {
        Document document2;
        if (document == null) {
            throw new NullPointerException("Document must not be null");
        }
        Element element = document.getDocumentElement();
        String string2 = element.getAttributeNS(XML_NAMESPACE, "base");
        if (string2 != null && !string2.equals("")) {
            string = string2;
        }
        if (!DOMXIncluder.isIncludeElement(element)) {
            document2 = (Document)document.cloneNode(true);
            Element element2 = document2.getDocumentElement();
            Node node = element2.getFirstChild();
            while (node != null) {
                Node node2 = node;
                node = node.getNextSibling();
                if (node2.getNodeType() != 1) continue;
                Element element3 = (Element)node2;
                DocumentFragment documentFragment = this.resolve(element3, string);
                element2.replaceChild(documentFragment, element3);
            }
        } else {
            String string3;
            Object object;
            Object object2;
            DOMXIncluder.verifyXIncludeElement(element);
            String string4 = element.getAttribute("href");
            if (string != null) {
                try {
                    object2 = new URL(string);
                    object = new URL((URL)object2, string4);
                    string3 = ((URL)object).toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + string + "/" + string4);
                    unavailableResourceException.setRootCause(malformedURLException);
                    throw unavailableResourceException;
                }
            } else {
                string3 = string4;
            }
            if (element.hasAttribute("parse") && ((String)(object2 = element.getAttribute("parse"))).equals("text")) {
                throw new BadParseAttributeException("Cannot include unparsed text for the root element");
            }
            document2 = this.downloadXMLDocument(string3);
            object2 = DOMXIncluder.extractProlog(document);
            document2.insertBefore(document2.importNode((Node)object2, true), document2.getFirstChild());
            object = DOMXIncluder.extractEpilog(document);
            document2.appendChild(document2.importNode((Node)object, true));
            document2 = this.resolve(document2, string3);
        }
        return document2;
    }

    private static DocumentFragment extractProlog(Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) break;
            if (node.getNodeType() != 10) {
                documentFragment.appendChild(node.cloneNode(true));
            }
            ++n;
        }
        return documentFragment;
    }

    private static DocumentFragment extractEpilog(Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        NodeList nodeList = document.getChildNodes();
        boolean bl = false;
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (bl) {
                documentFragment.appendChild(node.cloneNode(true));
            }
            if (node.getNodeType() == 1) {
                bl = true;
            }
            ++n;
        }
        return documentFragment;
    }

    private static void verifyXIncludeElement(Element element) throws BadParseAttributeException, MissingHrefException {
        String string;
        if (!element.hasAttribute("href")) {
            throw new MissingHrefException("Missing href attribute");
        }
        boolean bl = true;
        if (element.hasAttribute("parse") && !(string = element.getAttribute("parse")).equals("text") && !string.equals("xml")) {
            throw new BadParseAttributeException(string + " is not a legal value for the parse attribute");
        }
    }

    public static DocumentFragment merge(Element element, String string) throws MalformedResourceException, XIncludeException, NullPointerException, CircularIncludeException, BadParseAttributeException, UnavailableResourceException, MissingHrefException, ParserConfigurationException {
        DOMXIncluder dOMXIncluder = new DOMXIncluder();
        return dOMXIncluder.resolve(element, string);
    }

    private DocumentFragment resolve(Element element, String string) throws MalformedResourceException, XIncludeException, NullPointerException, CircularIncludeException, BadParseAttributeException, UnavailableResourceException, MissingHrefException {
        if (element == null) {
            throw new NullPointerException("You can't XInclude a null element.");
        }
        Stack<String> stack = new Stack<String>();
        if (string != null) {
            stack.push(string);
        }
        DocumentFragment documentFragment = this.resolve(element, stack);
        return documentFragment;
    }

    private static boolean isIncludeElement(Element element) {
        return "include".equals(element.getLocalName()) && XINCLUDE_NAMESPACE.equals(element.getNamespaceURI());
    }

    private DocumentFragment resolve(Element element, Stack stack) throws CircularIncludeException, MissingHrefException, MalformedResourceException, BadParseAttributeException, UnavailableResourceException, XIncludeException {
        Document document = element.getOwnerDocument();
        DocumentFragment documentFragment = document.createDocumentFragment();
        String string = null;
        boolean bl = false;
        String string2 = element.getAttributeNS(XML_NAMESPACE, "base");
        if (string2 != null && !string2.equals("")) {
            string = string2;
            stack.push(string);
            bl = true;
        }
        if (stack.size() != 0) {
            string = (String)stack.peek();
        }
        if (DOMXIncluder.isIncludeElement(element)) {
            String string3;
            Object object;
            if (!element.hasAttribute("href")) {
                throw new MissingHrefException("Missing href attribute");
            }
            String string4 = element.getAttribute("href");
            if (string != null) {
                try {
                    URL uRL = new URL(string);
                    object = new URL(uRL, string4);
                    string3 = ((URL)object).toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + string + "/" + string4);
                    unavailableResourceException.setRootCause(malformedURLException);
                    throw unavailableResourceException;
                }
            } else {
                string3 = string4;
            }
            boolean bl2 = true;
            if (element.hasAttribute("parse")) {
                object = element.getAttribute("parse");
                if (((String)object).equals("text")) {
                    bl2 = false;
                } else if (!((String)object).equals("xml")) {
                    throw new BadParseAttributeException((String)object + "is not a legal value for the parse attribute");
                }
            }
            if (bl2) {
                if (stack.contains(string3)) {
                    throw new CircularIncludeException("Circular XInclude Reference to " + string3 + " in ");
                }
                try {
                    object = this.parser.parse(string3);
                    stack.push(string3);
                    NodeList nodeList = object.getChildNodes();
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Node node = nodeList.item(n);
                        if (node.getNodeType() != 10) {
                            Node node2 = document.importNode(node, true);
                            if (node2.getNodeType() == 1) {
                                Element element2 = (Element)node2;
                                if (!element2.hasAttributeNS(XML_NAMESPACE, "base")) {
                                    element2.setAttributeNS(XML_NAMESPACE, "xml:base", string3);
                                }
                                documentFragment.appendChild(this.resolve(element2, stack));
                            } else {
                                documentFragment.appendChild(node2);
                            }
                        }
                        ++n;
                    }
                    stack.pop();
                }
                catch (SAXParseException sAXParseException) {
                    int n = sAXParseException.getLineNumber();
                    if (n <= 0) {
                        UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document " + string3 + " was not found.");
                        unavailableResourceException.setRootCause(sAXParseException);
                        throw unavailableResourceException;
                    }
                    int n2 = sAXParseException.getColumnNumber();
                    MalformedResourceException malformedResourceException = new MalformedResourceException("Document " + string3 + " is not well-formed at line " + n + ", column " + n2);
                    malformedResourceException.setRootCause(sAXParseException);
                    throw malformedResourceException;
                }
                catch (SAXException sAXException) {
                    MalformedResourceException malformedResourceException = new MalformedResourceException("Document " + string3 + " is not well-formed.");
                    malformedResourceException.setRootCause(sAXException);
                    throw malformedResourceException;
                }
                catch (IOException iOException) {
                    UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document not found: " + string3);
                    unavailableResourceException.setRootCause(iOException);
                    throw unavailableResourceException;
                }
            } else {
                object = element.getAttribute("encoding");
                String string5 = DOMXIncluder.downloadTextDocument(string3, (String)object);
                documentFragment.appendChild(document.createTextNode(string5));
            }
        } else {
            Node node = element.cloneNode(true);
            Node node3 = node.getFirstChild();
            while (node3 != null) {
                Node node4 = node3.getNextSibling();
                if (node3.getNodeType() == 1) {
                    Element element3 = (Element)node3;
                    DocumentFragment documentFragment2 = this.resolve(element3, stack);
                    node.replaceChild(documentFragment2, element3);
                }
                node3 = node4;
            }
            documentFragment.appendChild(node);
        }
        if (bl) {
            stack.pop();
        }
        return documentFragment;
    }

    private Document downloadXMLDocument(String string) throws XIncludeException {
        try {
            Object object;
            Object object2;
            DocumentType documentType;
            Document document = this.parser.parse(string);
            Element element = document.getDocumentElement();
            if (!element.hasAttributeNS(XML_NAMESPACE, "base")) {
                element.setAttributeNS(XML_NAMESPACE, "xml:base", string);
            }
            if ((documentType = document.getDoctype()) == null) {
                return document;
            }
            Document document2 = document.getImplementation().createDocument(element.getNamespaceURI(), element.getNodeName(), null);
            Element element2 = document2.getDocumentElement();
            NodeList nodeList = document.getChildNodes();
            boolean bl = true;
            int n = 0;
            while (n < nodeList.getLength()) {
                object2 = nodeList.item(n);
                if (object2.getNodeType() == 1) {
                    bl = false;
                } else if (object2.getNodeType() != 10) {
                    if (bl) {
                        document2.insertBefore(document2.importNode((Node)object2, true), element2);
                    } else {
                        document2.appendChild(document2.importNode((Node)object2, true));
                    }
                }
                ++n;
            }
            object2 = element.getChildNodes();
            int n2 = 0;
            while (n2 < object2.getLength()) {
                object = object2.item(n2);
                element2.appendChild(document2.importNode((Node)object, true));
                ++n2;
            }
            object = element.getAttributes();
            int n3 = 0;
            while (n3 < object.getLength()) {
                Node node = document2.importNode(object.item(n3), true);
                element2.setAttributeNodeNS((Attr)node);
                ++n3;
            }
            return document2;
        }
        catch (SAXParseException sAXParseException) {
            int n = sAXParseException.getLineNumber();
            if (n <= 0) {
                UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document " + string + " was not found.");
                unavailableResourceException.setRootCause(sAXParseException);
                throw unavailableResourceException;
            }
            int n4 = sAXParseException.getColumnNumber();
            MalformedResourceException malformedResourceException = new MalformedResourceException("Document " + string + " is not well-formed at line " + n + ", column " + n4);
            malformedResourceException.setRootCause(sAXParseException);
            throw malformedResourceException;
        }
        catch (SAXException sAXException) {
            MalformedResourceException malformedResourceException = new MalformedResourceException("Document " + string + " is not well-formed.");
            malformedResourceException.setRootCause(sAXException);
            throw malformedResourceException;
        }
        catch (IOException iOException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document not found: " + string);
            unavailableResourceException.setRootCause(iOException);
            throw unavailableResourceException;
        }
    }

    private static String downloadTextDocument(String string, String string2) throws UnavailableResourceException {
        URL uRL;
        if (string2 == null || string2.equals("")) {
            string2 = "UTF-8";
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + string);
            unavailableResourceException.setRootCause(malformedURLException);
            throw unavailableResourceException;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            URLConnection uRLConnection = uRL.openConnection();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            String string3 = uRLConnection.getContentEncoding();
            String string4 = uRLConnection.getContentType();
            if (string3 != null) {
                string2 = string3;
            } else if (string4 != null && ((string4 = string4.toLowerCase()).equals("text/xml") || string4.equals("application/xml") || string4.startsWith("text/") && string4.endsWith("+xml") || string4.startsWith("application/") && string4.endsWith("+xml"))) {
                string2 = EncodingHeuristics.readEncodingFromStream(bufferedInputStream);
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string2);
            while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Encoding not recognized for document " + uRL.toExternalForm());
            unavailableResourceException.setRootCause(unsupportedEncodingException);
            throw unavailableResourceException;
        }
        catch (IOException iOException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document not found: " + uRL.toExternalForm());
            unavailableResourceException.setRootCause(iOException);
            throw unavailableResourceException;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java DOMXIncluder URL output_file");
            return;
        }
        String string = stringArray[0];
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setCoalescing(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                String string2;
                Object object;
                Object object2;
                InputSource inputSource = new InputSource();
                if (string.indexOf(58) < 0) {
                    object2 = new File(string);
                    object = ((File)object2).toURL().toExternalForm();
                    inputSource.setSystemId((String)object);
                    inputSource.setByteStream(new FileInputStream((File)object2));
                } else {
                    inputSource.setSystemId(string);
                }
                object2 = documentBuilder.parse(inputSource);
                object = DOMXIncluder.merge((Document)object2, inputSource.getSystemId());
                OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", false);
                outputFormat.setPreserveSpace(true);
                OutputStream outputStream = System.out;
                if (stringArray.length >= 2) {
                    string2 = stringArray[1];
                    outputStream = new FileOutputStream(string2);
                }
                string2 = new XMLSerializer(outputStream, outputFormat);
                string2.serialize((Document)object);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Could not locate a JAXP parser");
        }
    }
}

