/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.resolver.RepositoryResolver;
import org.apache.ivy.util.Message;

public class FileSystemResolver
extends RepositoryResolver {
    private static final String TRANSACTION_DESTINATION_SUFFIX = ".part";
    private static final Pattern TRANSACTION_PATTERN = Pattern.compile("(.*\\[revision\\])([/\\\\][^/\\\\]+)");
    private String transactional = "auto";
    private Boolean supportTransaction;
    private String baseTransactionPattern;
    private Map fullTransactionPatterns = new HashMap();
    private boolean overwriteTransaction = false;
    private File transactionTempDir;
    private File transactionDestDir;

    public FileSystemResolver() {
        this.setRepository(new FileRepository());
    }

    public String getTypeName() {
        return "file";
    }

    public boolean isLocal() {
        return this.getFileRepository().isLocal();
    }

    public void setLocal(boolean local) {
        this.getFileRepository().setLocal(local);
    }

    private FileRepository getFileRepository() {
        return (FileRepository)this.getRepository();
    }

    protected String getDestination(String pattern, Artifact artifact, ModuleRevisionId mrid) {
        if (this.supportTransaction() && !this.overwriteTransaction) {
            String destPattern = (String)this.fullTransactionPatterns.get(pattern);
            if (destPattern == null) {
                throw new IllegalArgumentException("unsupported pattern for publish destination pattern: " + pattern + ". supported patterns: " + this.fullTransactionPatterns.keySet());
            }
            return IvyPatternHelper.substitute(destPattern, mrid, artifact);
        }
        return super.getDestination(pattern, artifact, mrid);
    }

    public void abortPublishTransaction() throws IOException {
        if (this.supportTransaction() && !this.overwriteTransaction) {
            if (this.transactionTempDir == null) {
                throw new IllegalStateException("no current transaction!");
            }
            this.getFileRepository().delete(this.transactionTempDir);
            Message.info("\tpublish aborted: deleted " + this.transactionTempDir);
            this.closeTransaction();
        }
    }

    public void commitPublishTransaction() throws IOException {
        if (this.supportTransaction() && !this.overwriteTransaction) {
            if (this.transactionTempDir == null) {
                throw new IllegalStateException("no current transaction!");
            }
            this.getFileRepository().move(this.transactionTempDir, this.transactionDestDir);
            Message.info("\tpublish commited: moved " + this.transactionTempDir + " \n\t\tto " + this.transactionDestDir);
            this.closeTransaction();
        }
    }

    public void beginPublishTransaction(ModuleRevisionId module, boolean overwrite) throws IOException {
        if (this.supportTransaction()) {
            if (this.transactionTempDir != null) {
                throw new IllegalStateException("a transaction is already started and not closed!");
            }
            this.overwriteTransaction = overwrite;
            if (this.overwriteTransaction) {
                this.unsupportedTransaction("overwrite transaction not supported yet");
            } else {
                this.initTransaction(module);
            }
        }
    }

    protected Collection filterNames(Collection values) {
        if (this.supportTransaction()) {
            values = super.filterNames(values);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String v = (String)iterator.next();
                if (!v.endsWith(TRANSACTION_DESTINATION_SUFFIX)) continue;
                iterator.remove();
            }
            return values;
        }
        return super.filterNames(values);
    }

    public boolean supportTransaction() {
        if ("false".equals(this.transactional)) {
            return false;
        }
        this.checkSupportTransaction();
        return this.supportTransaction;
    }

    private void closeTransaction() {
        this.transactionTempDir = null;
        this.transactionDestDir = null;
    }

    private void checkSupportTransaction() {
        if (this.supportTransaction == null) {
            Matcher m;
            String pattern;
            List ivyPatterns = this.getIvyPatterns();
            List artifactPatterns = this.getArtifactPatterns();
            if (ivyPatterns.size() > 0) {
                pattern = (String)ivyPatterns.get(0);
                m = TRANSACTION_PATTERN.matcher(pattern);
                if (!m.matches()) {
                    this.unsupportedTransaction("ivy pattern does not use revision as last directory");
                    return;
                }
                this.baseTransactionPattern = m.group(1);
                this.fullTransactionPatterns.put(pattern, m.group(1) + TRANSACTION_DESTINATION_SUFFIX + m.group(2));
            }
            if (artifactPatterns.size() > 0) {
                pattern = (String)artifactPatterns.get(0);
                m = TRANSACTION_PATTERN.matcher(pattern);
                if (!m.matches()) {
                    this.unsupportedTransaction("ivy pattern does not use revision as last directory");
                    return;
                }
                if (this.baseTransactionPattern != null) {
                    if (!this.baseTransactionPattern.equals(m.group(1))) {
                        this.unsupportedTransaction("ivy pattern and artifact pattern do not use the same directory for revision");
                        return;
                    }
                    this.fullTransactionPatterns.put(pattern, m.group(1) + TRANSACTION_DESTINATION_SUFFIX + m.group(2));
                } else {
                    this.baseTransactionPattern = m.group(1);
                    this.fullTransactionPatterns.put(pattern, m.group(1) + TRANSACTION_DESTINATION_SUFFIX + m.group(2));
                }
            }
            this.supportTransaction = Boolean.TRUE;
        }
    }

    private void unsupportedTransaction(String msg) {
        String fullMsg = this.getName() + " do not support transaction. " + msg;
        if ("true".equals(this.transactional)) {
            throw new IllegalStateException(fullMsg + ". Set transactional attribute to 'auto' or 'false' or fix the problem.");
        }
        Message.verbose(fullMsg);
        this.supportTransaction = Boolean.FALSE;
    }

    private void initTransaction(ModuleRevisionId module) {
        this.transactionTempDir = new File(IvyPatternHelper.substitute(this.baseTransactionPattern, ModuleRevisionId.newInstance(module, module.getRevision() + TRANSACTION_DESTINATION_SUFFIX)));
        this.transactionDestDir = new File(IvyPatternHelper.substitute(this.baseTransactionPattern, module));
    }

    public String getTransactional() {
        return this.transactional;
    }

    public void setTransactional(String transactional) {
        this.transactional = transactional;
    }
}

