/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Task;
import org.w3c.dom.Node;

public class BufferStore {
    public static final String BUFFERS_PROJECT_REF = "xmltask.buffers";
    private static final String FILE_PREFIX = "file://";

    private BufferStore() {
    }

    private static Map getBuffers(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("Can't get buffers for a null task");
        }
        if (task.getProject() == null) {
            throw new IllegalArgumentException("Can't get buffers for a task with no associated project");
        }
        HashMap buffers = (HashMap)task.getProject().getReference(BUFFERS_PROJECT_REF);
        if (buffers == null) {
            buffers = new HashMap();
            task.getProject().addReference(BUFFERS_PROJECT_REF, buffers);
        }
        return buffers;
    }

    public static Node[] get(String name, Task task) {
        List res = BufferStore.getBuffer(name, task);
        if (res == null) {
            return null;
        }
        Node[] nodes = res.toArray(new Node[0]);
        for (int n = 0; n < nodes.length; ++n) {
            nodes[n] = nodes[n].cloneNode(true);
        }
        return nodes;
    }

    private static boolean isFileBuffer(String name) {
        return name.startsWith(FILE_PREFIX);
    }

    private static String getFilenameFromBuffer(String name) {
        if (!name.startsWith(FILE_PREFIX)) {
            throw new IllegalArgumentException("Attempt to create a file buffer using '" + name + "'");
        }
        return name.substring(FILE_PREFIX.length());
    }

    private static List getBuffer(String name, Task task) {
        if (BufferStore.isFileBuffer(name)) {
            File file = new File(BufferStore.getFilenameFromBuffer(name));
            if (!file.exists()) {
                return null;
            }
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                List buffer = (List)in.readObject();
                in.close();
                return buffer;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Problem during deserialization of " + file + " : " + e.getMessage());
            }
        }
        Map buffers = BufferStore.getBuffers(task);
        return (List)buffers.get(name);
    }

    private static void setBuffer(String name, List list, Task task) {
        if (BufferStore.isFileBuffer(name)) {
            File f = new File(BufferStore.getFilenameFromBuffer(name));
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(f));
                out.writeObject(list);
                out.close();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException("Problem during serialization of " + f + " : " + e.getMessage());
            }
        }
        Map buffers = BufferStore.getBuffers(task);
        buffers.put(name, list);
    }

    public static void set(String name, Node xml, boolean append, Task task) {
        Node newnode = xml.cloneNode(true);
        BufferStore.log("Storing " + newnode + " against buffer (" + name + ")", task);
        ArrayList<Node> list = BufferStore.getBuffer(name, task);
        if (list != null) {
            if (!append) {
                BufferStore.log(" (overwriting existing entry)", task);
                list = new ArrayList();
                BufferStore.setBuffer(name, list, task);
            } else {
                BufferStore.log(" (appending to existing entry)", task);
            }
        } else {
            list = new ArrayList<Node>();
            BufferStore.setBuffer(name, list, task);
        }
        BufferStore.log("", task);
        list.add(newnode);
        BufferStore.setBuffer(name, list, task);
    }

    public static void clear(String name, Task task) {
        BufferStore.log("Clearing buffer (" + name + ")", task);
        BufferStore.setBuffer(name, new ArrayList(), task);
    }

    public static void log(String msg, Task task) {
        if (task != null) {
            task.log(msg, 3);
        } else {
            System.out.println(msg);
        }
    }
}

