/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.jpa.entity.metadata;

import com.nokia.helium.jpa.ORMEntityManager;
import com.nokia.helium.jpa.ORMUtil;
import com.nokia.helium.jpa.entity.metadata.Metadata;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class MetadataUtil {
    private static Logger log = Logger.getLogger(MetadataUtil.class);
    private static Metadata metadata;
    private static HashMap<String, Metadata> metadataMap;
    private static Object mutexObject;

    private MetadataUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeORM(String urlPath) {
        Object object = mutexObject;
        synchronized (object) {
            ORMUtil.initializeORM(urlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeORM(String urlPath) {
        Object object = mutexObject;
        synchronized (object) {
            log.debug((Object)"finalizing orm");
            ORMUtil.finalizeORM(urlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeMetadata(String logPath) {
        Object object = mutexObject;
        synchronized (object) {
            log.debug((Object)"finalizing metadata");
            metadataMap.remove(logPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(String urlPath, Metadata.LogEntry entry) {
        Object object = mutexObject;
        synchronized (object) {
            metadata = MetadataUtil.getMetadata(entry.getLogPath(), urlPath);
            metadata.addEntry(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEntries(String urlPath, String logPath) {
        Object object = mutexObject;
        synchronized (object) {
            metadata = MetadataUtil.getMetadata(logPath, urlPath);
            metadata.removeEntries();
            MetadataUtil.finalizeMetadata(logPath);
        }
    }

    private static Metadata getMetadata(String logPath, String urlPath) {
        ORMEntityManager manager = ORMUtil.getEntityManager(urlPath);
        metadata = metadataMap.get(logPath);
        if (metadata == null) {
            log.debug((Object)("initializing metadatamap for logpath" + logPath));
            metadata = new Metadata(manager, logPath);
            metadataMap.put(logPath, metadata);
        }
        return metadata;
    }

    static {
        metadataMap = new HashMap();
        mutexObject = new Object();
    }
}

