/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.resolve.EndResolveDependencyEvent;
import org.apache.ivy.core.event.resolve.StartResolveDependencyEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class IvyNode
implements Comparable {
    private static final Pattern FALLBACK_CONF_PATTERN = Pattern.compile("(.+)\\((.*)\\)");
    private ResolveData data;
    private ResolveEngineSettings settings;
    private IvyNodeCallers callers;
    private IvyNodeEviction eviction;
    private IvyNode root;
    private ModuleRevisionId id;
    private Map dds = new HashMap();
    private ModuleDescriptor md;
    private ResolvedModuleRevision module;
    private Exception problem = null;
    private boolean downloaded = false;
    private boolean searched = false;
    private Collection confsToFetch = new HashSet();
    private Collection fetchedConfigurations = new HashSet();
    private Collection loadedRootModuleConfs = new HashSet();
    private Map rootModuleConfs = new HashMap();
    private Map requiredConfs = new HashMap();
    private Map dependencyArtifacts = new HashMap();
    private Map dependencyIncludes = new HashMap();
    private Map blacklisted = new HashMap();

    public IvyNode(ResolveData data, IvyNode parent, DependencyDescriptor dd) {
        this.id = dd.getDependencyRevisionId();
        this.dds.put(parent, dd);
        this.root = parent.getRoot();
        this.init(data);
    }

    public IvyNode(ResolveData data, ModuleDescriptor md) {
        this.id = md.getModuleRevisionId();
        this.md = md;
        this.root = this;
        this.init(data);
    }

    private void init(ResolveData data) {
        this.data = data;
        this.settings = data.getSettings();
        this.eviction = new IvyNodeEviction(this);
        this.callers = new IvyNodeCallers(this);
    }

    public boolean loadData(String rootModuleConf, IvyNode parent, String parentConf, String conf, boolean shouldBePublic) {
        Message.debug("loadData of " + this.toString() + " of rootConf=" + rootModuleConf);
        if (!this.isRoot() && this.data.getReport() != null) {
            this.data.getReport().addDependency(this);
        }
        boolean loaded = false;
        if (this.hasProblem()) {
            Message.debug("Node has problem.  Skip loading");
        } else if (this.isEvicted(rootModuleConf)) {
            Message.debug(rootModuleConf + " is evicted.  Skip loading");
        } else if (!this.hasConfigurationsToLoad() && this.isRootModuleConfLoaded(rootModuleConf)) {
            Message.debug(rootModuleConf + " is loaded and no conf to load.  Skip loading");
        } else {
            this.markRootModuleConfLoaded(rootModuleConf);
            if (this.md == null) {
                DependencyResolver resolver = this.data.getSettings().getResolver(this.getId());
                if (resolver == null) {
                    Message.error("no resolver found for " + this.getModuleId() + ": check your configuration");
                    this.problem = new RuntimeException("no resolver found for " + this.getModuleId() + ": check your configuration");
                    return false;
                }
                try {
                    Message.debug("\tusing " + resolver + " to resolve " + this.getId());
                    DependencyDescriptor dependencyDescriptor = this.getDependencyDescriptor(parent);
                    long start = System.currentTimeMillis();
                    this.data.getEventManager().fireIvyEvent(new StartResolveDependencyEvent(resolver, dependencyDescriptor));
                    this.module = resolver.getDependency(dependencyDescriptor, this.data);
                    this.data.getEventManager().fireIvyEvent(new EndResolveDependencyEvent(resolver, dependencyDescriptor, this.module, System.currentTimeMillis() - start));
                    if (this.module != null) {
                        this.module.getResolver().getRepositoryCacheManager().saveResolvers(this.module.getDescriptor(), this.module.getResolver().getName(), this.module.getArtifactResolver().getName());
                        if (this.settings.logModuleWhenFound() && "default".equals(this.getData().getOptions().getLog())) {
                            Message.info("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        } else {
                            Message.verbose("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        }
                        if (this.settings.getVersionMatcher().isDynamic(this.getId())) {
                            if (this.settings.getVersionMatcher().isDynamic(this.module.getId())) {
                                Message.error("impossible to resolve dynamic revision for " + this.getId() + ": check your configuration and make sure revision is part of your pattern");
                                this.problem = new RuntimeException("impossible to resolve dynamic revision");
                                return false;
                            }
                            IvyNode resolved = this.data.getNode(this.module.getId());
                            if (resolved != null) {
                                this.md = this.module.getDescriptor();
                                if (!this.handleConfiguration(loaded, rootModuleConf, parent, parentConf, conf, shouldBePublic)) {
                                    return false;
                                }
                                if (resolved.md == null) {
                                    resolved.md = this.md;
                                }
                                if (resolved.module == null) {
                                    resolved.module = this.module;
                                }
                                resolved.downloaded |= this.module.getReport().isDownloaded();
                                resolved.searched |= this.module.getReport().isSearched();
                                resolved.dds.putAll(this.dds);
                                resolved.updateDataFrom(this, rootModuleConf, true);
                                resolved.loadData(rootModuleConf, parent, parentConf, conf, shouldBePublic);
                                DependencyDescriptor dd = dependencyDescriptor;
                                if (dd != null) {
                                    resolved.addDependencyArtifacts(rootModuleConf, dd.getDependencyArtifacts(parentConf));
                                    resolved.addDependencyIncludes(rootModuleConf, dd.getIncludeRules(parentConf));
                                }
                                this.data.replaceNode(this.getId(), resolved, rootModuleConf);
                                if (this.settings.logResolvedRevision()) {
                                    Message.info("\t[" + this.module.getId().getRevision() + "] " + this.getId());
                                } else {
                                    Message.verbose("\t[" + this.module.getId().getRevision() + "] " + this.getId());
                                }
                                return true;
                            }
                        }
                        this.downloaded = this.module.getReport().isDownloaded();
                        this.searched = this.module.getReport().isSearched();
                    } else {
                        Message.warn("\tmodule not found: " + this.getId());
                        resolver.reportFailure();
                        this.problem = new RuntimeException("not found");
                    }
                }
                catch (ResolveProcessException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.problem = e;
                }
                if (this.module == null) {
                    return false;
                }
                loaded = true;
                if (this.settings.getVersionMatcher().isDynamic(this.getId())) {
                    if (this.settings.logResolvedRevision()) {
                        Message.info("\t[" + this.module.getId().getRevision() + "] " + this.getId());
                    } else {
                        Message.verbose("\t[" + this.module.getId().getRevision() + "] " + this.getId());
                    }
                }
                this.md = this.module.getDescriptor();
                this.confsToFetch.remove("*");
                this.updateConfsToFetch(Arrays.asList(this.resolveSpecialConfigurations(this.getRequiredConfigurations(parent, parentConf), this)));
            } else {
                loaded = true;
            }
        }
        this.handleConfiguration(loaded, rootModuleConf, parent, parentConf, conf, shouldBePublic);
        if (this.hasProblem()) {
            Message.debug("problem : " + this.problem.getMessage());
            return false;
        }
        DependencyDescriptor dd = this.getDependencyDescriptor(parent);
        if (dd != null) {
            this.addDependencyArtifacts(rootModuleConf, dd.getDependencyArtifacts(parentConf));
            this.addDependencyIncludes(rootModuleConf, dd.getIncludeRules(parentConf));
        }
        return loaded;
    }

    public Collection getDependencies(String rootModuleConf, String[] confs) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        if (Arrays.asList(confs).contains("*")) {
            confs = this.md.getConfigurationsNames();
        }
        HashSet deps = new HashSet();
        for (int i = 0; i < confs.length; ++i) {
            deps.addAll(this.getDependencies(rootModuleConf, confs[i], confs[i]));
        }
        return deps;
    }

    public Collection getDependencies(String rootModuleConf, String conf, String requestedConf) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        DependencyDescriptor[] dds = this.md.getDependencies();
        LinkedHashSet<IvyNode> dependencies = new LinkedHashSet<IvyNode>();
        for (int i = 0; i < dds.length; ++i) {
            DependencyDescriptor dd = dds[i];
            String[] dependencyConfigurations = dd.getDependencyConfigurations(conf, requestedConf);
            if (dependencyConfigurations.length == 0) continue;
            if (this.isDependencyModuleExcluded(rootModuleConf, dd.getDependencyRevisionId(), conf)) {
                Message.verbose("excluding " + dd.getDependencyRevisionId() + " in " + conf);
                continue;
            }
            IvyNode depNode = this.data.getNode(dd.getDependencyRevisionId());
            if (depNode == null) {
                depNode = new IvyNode(this.data, this, dd);
            } else {
                depNode.addDependencyDescriptor(this, dd);
                if (depNode.hasProblem()) {
                    // empty if block
                }
            }
            List<String> confs = Arrays.asList(this.resolveSpecialConfigurations(dependencyConfigurations, depNode));
            depNode.updateConfsToFetch(confs);
            depNode.setRequiredConfs(this, conf, confs);
            depNode.addCaller(rootModuleConf, this, conf, dependencyConfigurations, dd);
            dependencies.add(depNode);
        }
        return dependencies;
    }

    private void addDependencyDescriptor(IvyNode parent, DependencyDescriptor dd) {
        this.dds.put(parent, dd);
    }

    public DependencyDescriptor getDependencyDescriptor(IvyNode parent) {
        return (DependencyDescriptor)this.dds.get(parent);
    }

    private boolean isDependencyModuleExcluded(String rootModuleConf, ModuleRevisionId dependencyRevisionId, String conf) {
        return this.callers.doesCallersExclude(rootModuleConf, DefaultArtifact.newIvyArtifact(dependencyRevisionId, null));
    }

    public boolean hasConfigurationsToLoad() {
        return !this.confsToFetch.isEmpty();
    }

    private boolean markRootModuleConfLoaded(String rootModuleConf) {
        return this.loadedRootModuleConfs.add(rootModuleConf);
    }

    private boolean isRootModuleConfLoaded(String rootModuleConf) {
        return this.loadedRootModuleConfs.contains(rootModuleConf);
    }

    private boolean handleConfiguration(boolean loaded, String rootModuleConf, IvyNode parent, String parentConf, String conf, boolean shouldBePublic) {
        if (this.md != null) {
            String[] confs = this.getRealConfs(conf);
            for (int i = 0; i < confs.length; ++i) {
                Configuration c = this.md.getConfiguration(confs[i]);
                if (c == null) {
                    this.confsToFetch.remove(conf);
                    this.problem = !conf.equals(confs[i]) ? new RuntimeException("configuration(s) not found in " + this + ": " + conf + ". Missing configuration: " + confs[i] + ". It was required from " + parent + " " + parentConf) : new RuntimeException("configuration(s) not found in " + this + ": " + confs[i] + ". It was required from " + parent + " " + parentConf);
                    return false;
                }
                if (shouldBePublic && !this.isRoot() && c.getVisibility() != Configuration.Visibility.PUBLIC) {
                    this.confsToFetch.remove(conf);
                    this.problem = new RuntimeException("configuration not public in " + this + ": " + c + ". It was required from " + parent + " " + parentConf);
                    return false;
                }
                if (loaded) {
                    this.fetchedConfigurations.add(conf);
                    this.confsToFetch.removeAll(Arrays.asList(confs));
                    this.confsToFetch.remove(conf);
                }
                this.addRootModuleConfigurations(rootModuleConf, confs);
            }
        }
        return true;
    }

    private String getDefaultConf(String conf) {
        Matcher m = FALLBACK_CONF_PATTERN.matcher(conf);
        if (m.matches()) {
            return m.group(2);
        }
        return conf;
    }

    private String getMainConf(String conf) {
        Matcher m = FALLBACK_CONF_PATTERN.matcher(conf);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public void updateConfsToFetch(Collection confs) {
        this.confsToFetch.addAll(confs);
        this.confsToFetch.removeAll(this.fetchedConfigurations);
    }

    private String[] resolveSpecialConfigurations(String[] dependencyConfigurations, IvyNode node) {
        if (dependencyConfigurations.length == 1 && dependencyConfigurations[0].startsWith("*") && node != null && node.isLoaded()) {
            String conf = dependencyConfigurations[0];
            if ("*".equals(conf)) {
                return node.getDescriptor().getPublicConfigurationsNames();
            }
            List<String> exclusions = Arrays.asList(conf.substring(2).split("\\!"));
            ArrayList<String> ret = new ArrayList<String>(Arrays.asList(node.getDescriptor().getPublicConfigurationsNames()));
            ret.removeAll(exclusions);
            return ret.toArray(new String[ret.size()]);
        }
        return dependencyConfigurations;
    }

    public String[] getRequiredConfigurations(IvyNode in, String inConf) {
        Collection req = (Collection)this.requiredConfs.get(new NodeConf(in, inConf));
        return req == null ? new String[]{} : req.toArray(new String[req.size()]);
    }

    public String[] getRequiredConfigurations() {
        ArrayList required = new ArrayList(this.confsToFetch.size() + this.fetchedConfigurations.size());
        required.addAll(this.fetchedConfigurations);
        required.addAll(this.confsToFetch);
        return required.toArray(new String[required.size()]);
    }

    private void setRequiredConfs(IvyNode parent, String parentConf, Collection confs) {
        this.requiredConfs.put(new NodeConf(parent, parentConf), new HashSet(confs));
    }

    public Configuration getConfiguration(String conf) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get configuration when data has not been loaded");
        }
        String defaultConf = this.getDefaultConf(conf);
        Configuration configuration = this.md.getConfiguration(conf = this.getMainConf(conf));
        if (configuration == null) {
            configuration = this.md.getConfiguration(defaultConf);
        }
        return configuration;
    }

    public String[] getConfigurations(String rootModuleConf) {
        Set depConfs = (Set)this.rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            return new String[0];
        }
        return depConfs.toArray(new String[depConfs.size()]);
    }

    public void discardConf(String rootModuleConf, String conf) {
        HashSet depConfs = (HashSet)this.rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            depConfs = new HashSet();
            this.rootModuleConfs.put(rootModuleConf, depConfs);
        }
        if (this.md != null) {
            Configuration c = this.md.getConfiguration(conf);
            if (conf != null) {
                String[] exts = c.getExtends();
                for (int i = 0; i < exts.length; ++i) {
                    this.discardConf(rootModuleConf, exts[i]);
                }
                depConfs.remove(c.getName());
            } else {
                Message.warn("unknown configuration in " + this.getId() + ": " + conf);
            }
        } else {
            depConfs.remove(conf);
        }
    }

    private void addRootModuleConfigurations(String rootModuleConf, String[] dependencyConfs) {
        HashSet<String> depConfs = (HashSet<String>)this.rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            depConfs = new HashSet<String>();
            this.rootModuleConfs.put(rootModuleConf, depConfs);
        }
        if (this.md != null) {
            for (int i = 0; i < dependencyConfs.length; ++i) {
                Configuration conf = this.md.getConfiguration(dependencyConfs[i]);
                if (conf != null) {
                    String[] exts = conf.getExtends();
                    this.addRootModuleConfigurations(rootModuleConf, exts);
                    depConfs.add(conf.getName());
                    continue;
                }
                Message.warn("unknown configuration in " + this.getId() + ": " + dependencyConfs[i]);
            }
        } else {
            for (int i = 0; i < dependencyConfs.length; ++i) {
                depConfs.add(dependencyConfs[i]);
            }
        }
    }

    public String[] getRootModuleConfigurations() {
        return this.rootModuleConfs.keySet().toArray(new String[this.rootModuleConfs.size()]);
    }

    public String[] getConfsToFetch() {
        return this.confsToFetch.toArray(new String[this.confsToFetch.size()]);
    }

    public String[] getRealConfs(String conf) {
        if (this.md == null) {
            return new String[]{conf};
        }
        String defaultConf = this.getDefaultConf(conf);
        if (this.md.getConfiguration(conf = this.getMainConf(conf)) == null) {
            if ("".equals(defaultConf)) {
                return new String[0];
            }
            conf = defaultConf;
        }
        if (conf.startsWith("*")) {
            return this.resolveSpecialConfigurations(new String[]{conf}, this);
        }
        if (conf.indexOf(44) != -1) {
            String[] confs = conf.split(",");
            for (int i = 0; i < confs.length; ++i) {
                confs[i] = confs[i].trim();
            }
        }
        return new String[]{conf};
    }

    private Collection findPath(ModuleId from) {
        return this.findPath(from, this, new LinkedList());
    }

    private Collection findPath(ModuleId from, IvyNode node, List path) {
        IvyNode parent = node.getDirectCallerFor(from);
        if (parent == null) {
            throw new IllegalArgumentException("no path from " + from + " to " + this.getId() + " found");
        }
        if (path.contains(parent)) {
            path.add(0, parent);
            Message.verbose("circular dependency found while looking for the path for another one: was looking for " + from + " as a caller of " + path.get(path.size() - 1));
            return path;
        }
        path.add(0, parent);
        if (parent.getId().getModuleId().equals(from)) {
            return path;
        }
        return this.findPath(from, parent, path);
    }

    private void updateDataFrom(IvyNode node, String rootModuleConf, boolean real) {
        this.callers.updateFrom(node.callers, rootModuleConf, real);
        this.updateMapOfSet(node.requiredConfs, this.requiredConfs);
        this.updateMapOfSetForKey(node.rootModuleConfs, this.rootModuleConfs, rootModuleConf);
        this.updateMapOfSetForKey(node.dependencyArtifacts, this.dependencyArtifacts, rootModuleConf);
        this.updateConfsToFetch(node.fetchedConfigurations);
        this.updateConfsToFetch(node.confsToFetch);
    }

    private void updateMapOfSet(Map from, Map to) {
        Iterator iter = from.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            this.updateMapOfSetForKey(from, to, key);
        }
    }

    private void updateMapOfSetForKey(Map from, Map to, Object key) {
        Set set = (Set)from.get(key);
        if (set != null) {
            Set toupdate = (Set)to.get(key);
            if (toupdate != null) {
                toupdate.addAll(set);
            } else {
                to.put(key, new HashSet(set));
            }
        }
    }

    public Artifact[] getAllArtifacts() {
        HashSet<Artifact> ret = new HashSet<Artifact>();
        Iterator it = this.rootModuleConfs.keySet().iterator();
        while (it.hasNext()) {
            String rootModuleConf = (String)it.next();
            ret.addAll(Arrays.asList(this.getArtifacts(rootModuleConf)));
        }
        return ret.toArray(new Artifact[ret.size()]);
    }

    public Artifact[] getSelectedArtifacts(Filter artifactFilter) {
        Collection<Artifact> ret = new HashSet();
        Iterator it = this.rootModuleConfs.keySet().iterator();
        while (it.hasNext()) {
            String rootModuleConf = (String)it.next();
            if (this.isEvicted(rootModuleConf) || this.isBlacklisted(rootModuleConf)) continue;
            ret.addAll(Arrays.asList(this.getArtifacts(rootModuleConf)));
        }
        ret = FilterHelper.filter(ret, artifactFilter);
        return ret.toArray(new Artifact[ret.size()]);
    }

    public Artifact[] getArtifacts(String rootModuleConf) {
        Set confs = (Set)this.rootModuleConfs.get(rootModuleConf);
        if (confs == null) {
            return new Artifact[0];
        }
        if (this.md == null) {
            throw new IllegalStateException("impossible to get artefacts when data has not been loaded. IvyNode = " + this.toString());
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Set dependencyArtifacts = (Set)this.dependencyArtifacts.get(rootModuleConf);
        if (this.md.isDefault() && dependencyArtifacts != null && !dependencyArtifacts.isEmpty()) {
            Iterator it = dependencyArtifacts.iterator();
            while (it.hasNext()) {
                DependencyArtifactDescriptor dad = (DependencyArtifactDescriptor)it.next();
                artifacts.add(new MDArtifact(this.md, dad.getName(), dad.getType(), dad.getExt(), dad.getUrl(), dad.getExtraAttributes()));
            }
        } else {
            Set includes = (Set)this.dependencyIncludes.get(rootModuleConf);
            if ((dependencyArtifacts == null || dependencyArtifacts.isEmpty()) && (includes == null || includes.isEmpty())) {
                Iterator iter = confs.iterator();
                while (iter.hasNext()) {
                    String conf = (String)iter.next();
                    artifacts.addAll(Arrays.asList(this.md.getArtifacts(conf)));
                }
            } else {
                ExtendableItem dad;
                Object arts;
                HashMap<ArtifactId, Object> allArtifacts = new HashMap<ArtifactId, Object>();
                Iterator iter = confs.iterator();
                while (iter.hasNext()) {
                    String conf = (String)iter.next();
                    arts = this.md.getArtifacts(conf);
                    for (int i = 0; i < ((Artifact[])arts).length; ++i) {
                        allArtifacts.put(arts[i].getId().getArtifactId(), arts[i]);
                    }
                }
                Iterator it = dependencyArtifacts.iterator();
                while (it.hasNext()) {
                    dad = (DependencyArtifactDescriptor)it.next();
                    artifacts.add(new MDArtifact(this.md, dad.getName(), dad.getType(), dad.getExt(), dad.getUrl(), dad.getExtraAttributes()));
                }
                it = includes.iterator();
                while (it.hasNext()) {
                    dad = (IncludeRule)it.next();
                    arts = IvyNode.findArtifactsMatching((IncludeRule)dad, allArtifacts);
                    if (arts.isEmpty()) {
                        Message.error("a required artifact is not listed by module descriptor: " + dad.getId());
                        it.remove();
                        continue;
                    }
                    Message.debug(this + " in " + rootModuleConf + ": including " + arts);
                    artifacts.addAll((Collection<Artifact>)arts);
                }
            }
        }
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            boolean excluded = this.callers.doesCallersExclude(rootModuleConf, artifact);
            if (!excluded) continue;
            Message.debug(this + " in " + rootModuleConf + ": excluding " + artifact);
            iter.remove();
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    private static Collection findArtifactsMatching(IncludeRule rule, Map allArtifacts) {
        ArrayList ret = new ArrayList();
        Iterator iter = allArtifacts.keySet().iterator();
        while (iter.hasNext()) {
            ArtifactId aid = (ArtifactId)iter.next();
            if (!MatcherHelper.matches(rule.getMatcher(), rule.getId(), aid)) continue;
            ret.add(allArtifacts.get(aid));
        }
        return ret;
    }

    private void addDependencyArtifacts(String rootModuleConf, DependencyArtifactDescriptor[] dependencyArtifacts) {
        this.addObjectsForConf(rootModuleConf, Arrays.asList(dependencyArtifacts), this.dependencyArtifacts);
    }

    private void addDependencyIncludes(String rootModuleConf, IncludeRule[] rules) {
        this.addObjectsForConf(rootModuleConf, Arrays.asList(rules), this.dependencyIncludes);
    }

    private void addObjectsForConf(String rootModuleConf, Collection objectsToAdd, Map map) {
        HashSet set = (HashSet)map.get(rootModuleConf);
        if (set == null) {
            set = new HashSet();
            map.put(rootModuleConf, set);
        }
        set.addAll(objectsToAdd);
    }

    public boolean hasProblem() {
        return this.problem != null;
    }

    public Exception getProblem() {
        return this.problem;
    }

    public String getProblemMessage() {
        return StringUtils.getErrorMessage(this.problem);
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public boolean isSearched() {
        return this.searched;
    }

    public boolean isLoaded() {
        return this.md != null;
    }

    public boolean isFetched(String conf) {
        return this.fetchedConfigurations.contains(conf);
    }

    public IvyNode findNode(ModuleRevisionId mrid) {
        return this.data.getNode(mrid);
    }

    boolean isRoot() {
        return this.root == this;
    }

    public IvyNode getRoot() {
        return this.root;
    }

    public ConflictManager getConflictManager(ModuleId mid) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get conflict manager when data has not been loaded. IvyNode = " + this.toString());
        }
        ConflictManager cm = this.md.getConflictManager(mid);
        return cm == null ? this.settings.getConflictManager(mid) : cm;
    }

    public IvyNode getRealNode() {
        IvyNode real = this.data.getNode(this.getId());
        return real != null ? real : this;
    }

    public ModuleRevisionId getId() {
        return this.id;
    }

    public ModuleId getModuleId() {
        return this.id.getModuleId();
    }

    public ModuleDescriptor getDescriptor() {
        return this.md;
    }

    public ResolveData getData() {
        return this.data;
    }

    public ResolvedModuleRevision getModuleRevision() {
        return this.module;
    }

    public long getPublication() {
        if (this.module != null) {
            return this.module.getPublicationDate().getTime();
        }
        return 0L;
    }

    public long getLastModified() {
        if (this.md != null) {
            return this.md.getLastModified();
        }
        return 0L;
    }

    public ModuleRevisionId getResolvedId() {
        if (this.md != null && this.md.getResolvedModuleRevisionId().getRevision() != null) {
            return this.md.getResolvedModuleRevisionId();
        }
        if (this.module != null) {
            return this.module.getId();
        }
        return this.getId();
    }

    public void clean() {
        this.confsToFetch.clear();
    }

    boolean canExclude(String rootModuleConf) {
        IvyNodeCallers.Caller[] callers = this.getCallers(rootModuleConf);
        for (int i = 0; i < callers.length; ++i) {
            if (!callers[i].canExclude()) continue;
            return true;
        }
        return false;
    }

    private IvyNode getDirectCallerFor(ModuleId from) {
        return this.callers.getDirectCallerFor(from);
    }

    public IvyNodeCallers.Caller[] getCallers(String rootModuleConf) {
        return this.callers.getCallers(rootModuleConf);
    }

    public Collection getAllCallersModuleIds() {
        return this.callers.getAllCallersModuleIds();
    }

    public IvyNodeCallers.Caller[] getAllCallers() {
        return this.callers.getAllCallers();
    }

    public IvyNodeCallers.Caller[] getAllRealCallers() {
        return this.callers.getAllRealCallers();
    }

    public void addCaller(String rootModuleConf, IvyNode callerNode, String callerConf, String[] dependencyConfs, DependencyDescriptor dd) {
        this.callers.addCaller(rootModuleConf, callerNode, callerConf, dependencyConfs, dd);
        boolean isCircular = this.callers.getAllCallersModuleIds().contains(this.getId().getModuleId());
        if (isCircular) {
            IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(this.toMrids(this.findPath(this.getId().getModuleId()), this));
        }
    }

    public boolean doesCallersExclude(String rootModuleConf, Artifact artifact, Stack callersStack) {
        return this.callers.doesCallersExclude(rootModuleConf, artifact, callersStack);
    }

    private ModuleRevisionId[] toMrids(Collection path, IvyNode depNode) {
        ModuleRevisionId[] ret = new ModuleRevisionId[path.size() + 1];
        int i = 0;
        Iterator iter = path.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            ret[i] = node.getId();
            ++i;
        }
        ret[ret.length - 1] = depNode.getId();
        return ret;
    }

    public Collection getResolvedNodes(ModuleId moduleId, String rootModuleConf) {
        return this.eviction.getResolvedNodes(moduleId, rootModuleConf);
    }

    public Collection getResolvedRevisions(ModuleId moduleId, String rootModuleConf) {
        return this.eviction.getResolvedRevisions(moduleId, rootModuleConf);
    }

    public void markEvicted(IvyNodeEviction.EvictionData evictionData) {
        this.eviction.markEvicted(evictionData);
        if (!this.rootModuleConfs.keySet().contains(evictionData.getRootModuleConf())) {
            this.rootModuleConfs.put(evictionData.getRootModuleConf(), null);
        }
        if (evictionData.getSelected() != null) {
            Iterator iter = evictionData.getSelected().iterator();
            while (iter.hasNext()) {
                IvyNode selected = (IvyNode)iter.next();
                selected.updateDataFrom(this, evictionData.getRootModuleConf(), false);
            }
        }
    }

    public Collection getAllEvictingConflictManagers() {
        return this.eviction.getAllEvictingConflictManagers();
    }

    public Collection getAllEvictingNodes() {
        return this.eviction.getAllEvictingNodes();
    }

    public Collection getAllEvictingNodesDetails() {
        return this.eviction.getAllEvictingNodesDetails();
    }

    public String[] getEvictedConfs() {
        return this.eviction.getEvictedConfs();
    }

    public IvyNodeEviction.EvictionData getEvictedData(String rootModuleConf) {
        return this.eviction.getEvictedData(rootModuleConf);
    }

    public Collection getEvictedNodes(ModuleId mid, String rootModuleConf) {
        return this.eviction.getEvictedNodes(mid, rootModuleConf);
    }

    public Collection getEvictedRevisions(ModuleId mid, String rootModuleConf) {
        return this.eviction.getEvictedRevisions(mid, rootModuleConf);
    }

    public IvyNodeEviction.EvictionData getEvictionDataInRoot(String rootModuleConf, IvyNode ancestor) {
        return this.eviction.getEvictionDataInRoot(rootModuleConf, ancestor);
    }

    public boolean isCompletelyEvicted() {
        return this.eviction.isCompletelyEvicted();
    }

    public boolean isEvicted(String rootModuleConf) {
        return this.eviction.isEvicted(rootModuleConf);
    }

    public void markEvicted(String rootModuleConf, IvyNode node, ConflictManager conflictManager, Collection resolved) {
        IvyNodeEviction.EvictionData evictionData = new IvyNodeEviction.EvictionData(rootModuleConf, node, conflictManager, resolved);
        this.markEvicted(evictionData);
    }

    public void setEvictedNodes(ModuleId moduleId, String rootModuleConf, Collection evicted) {
        this.eviction.setEvictedNodes(moduleId, rootModuleConf, evicted);
    }

    public void setResolvedNodes(ModuleId moduleId, String rootModuleConf, Collection resolved) {
        this.eviction.setResolvedNodes(moduleId, rootModuleConf, resolved);
    }

    public String toString() {
        return this.getResolvedId().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IvyNode)) {
            return false;
        }
        IvyNode node = (IvyNode)obj;
        return node.getId().equals(this.getId());
    }

    public int compareTo(Object obj) {
        IvyNode that = (IvyNode)obj;
        return this.getModuleId().compareTo(that.getModuleId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Collection getPendingConflicts(String rootModuleConf, ModuleId mid) {
        return this.eviction.getPendingConflicts(rootModuleConf, mid);
    }

    public void setPendingConflicts(ModuleId moduleId, String rootModuleConf, Collection conflicts) {
        this.eviction.setPendingConflicts(moduleId, rootModuleConf, conflicts);
    }

    public void blacklist(IvyNodeBlacklist bdata) {
        if (this.data.getSettings().logResolvedRevision()) {
            Message.info("BLACKLISTING " + bdata);
        } else {
            Message.verbose("BLACKLISTING " + bdata);
        }
        Stack<IvyNode> callerStack = new Stack<IvyNode>();
        callerStack.push(this);
        this.clearEvictionDataInAllCallers(bdata.getRootModuleConf(), callerStack);
        this.blacklisted.put(bdata.getRootModuleConf(), bdata);
        this.data.blacklist(this);
    }

    private void clearEvictionDataInAllCallers(String rootModuleConf, Stack callerStack) {
        IvyNode node = (IvyNode)callerStack.peek();
        IvyNodeCallers.Caller[] callers = node.getCallers(rootModuleConf);
        for (int i = 0; i < callers.length; ++i) {
            IvyNode callerNode = this.findNode(callers[i].getModuleRevisionId());
            if (callerNode == null) continue;
            callerNode.eviction = new IvyNodeEviction(callerNode);
            if (callerStack.contains(callerNode)) continue;
            callerStack.push(callerNode);
            this.clearEvictionDataInAllCallers(rootModuleConf, callerStack);
            callerStack.pop();
        }
    }

    public boolean isBlacklisted(String rootModuleConf) {
        return this.blacklisted.containsKey(rootModuleConf);
    }

    public boolean isCompletelyBlacklisted() {
        if (this.isRoot()) {
            return false;
        }
        String[] rootModuleConfigurations = this.getRootModuleConfigurations();
        for (int i = 0; i < rootModuleConfigurations.length; ++i) {
            if (this.isBlacklisted(rootModuleConfigurations[i])) continue;
            return false;
        }
        return true;
    }

    public IvyNodeBlacklist getBlacklistData(String rootModuleConf) {
        return (IvyNodeBlacklist)this.blacklisted.get(rootModuleConf);
    }

    private static final class NodeConf {
        private IvyNode node;
        private String conf;

        public NodeConf(IvyNode node, String conf) {
            if (node == null) {
                throw new NullPointerException("node must not null");
            }
            if (conf == null) {
                throw new NullPointerException("conf must not null");
            }
            this.node = node;
            this.conf = conf;
        }

        public final String getConf() {
            return this.conf;
        }

        public final IvyNode getNode() {
            return this.node;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeConf)) {
                return false;
            }
            return this.getNode().equals(((NodeConf)obj).getNode()) && this.getConf().equals(((NodeConf)obj).getConf());
        }

        public int hashCode() {
            int hash = 33;
            hash += this.getNode().hashCode() * 17;
            return hash += this.getConf().hashCode() * 17;
        }

        public String toString() {
            return "NodeConf(" + this.conf + ")";
        }
    }
}

