/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds.ant;

import com.nokia.helium.core.PropertiesSource;
import com.nokia.helium.core.TemplateProcessor;
import com.nokia.helium.diamonds.DiamondsConfig;
import com.nokia.helium.diamonds.DiamondsException;
import com.nokia.helium.diamonds.DiamondsListener;
import com.nokia.helium.diamonds.DiamondsProperties;
import com.nokia.helium.diamonds.StageDiamondsListener;
import com.nokia.helium.diamonds.TargetDiamondsListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public class HeliumListener
implements BuildListener {
    private Logger log = Logger.getLogger(HeliumListener.class);
    private List<DiamondsListener> diamondsListeners = new ArrayList<DiamondsListener>();
    private Project project;
    private boolean isInitialized;
    private boolean skipDiamonds;
    private boolean skipDiamondsSet;

    public void buildStarted(BuildEvent event) {
        this.project = event.getProject();
    }

    public void targetStarted(BuildEvent event) {
        String targetName = event.getTarget().getName();
        this.project = event.getProject();
        String skip = this.project.getProperty("skip.diamonds");
        if (skip != null && skip.equals("true")) {
            this.skipDiamonds = true;
        }
        try {
            if (!this.skipDiamonds) {
                if (!this.isInitialized) {
                    String configFile = this.project.getProperty("diamonds.listener.configuration.file");
                    this.parseConfig(configFile, this.project.getProperties());
                    this.isInitialized = true;
                }
                DiamondsProperties diamondProperties = DiamondsConfig.getDiamondsProperties();
                if (targetName.equals(DiamondsConfig.getInitialiserTargetName())) {
                    String categoryName = diamondProperties.getProperty("category-property");
                    String category = this.project.getProperty(categoryName);
                    this.log.debug((Object)("category:" + category));
                    if (category != null && this.diamondsListeners.isEmpty()) {
                        this.addListeners(event);
                        this.log.info((Object)"Diamonds enabled");
                    }
                }
            } else if (!this.skipDiamondsSet && this.skipDiamonds) {
                this.log.info((Object)"skip.diamonds set, to use diamonds don't set skip.diamonds.");
                this.skipDiamondsSet = true;
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"Diamonds error: ", (Throwable)ex);
            String errorMessage = ex.getMessage();
            if (errorMessage == null) {
                errorMessage = "";
            }
            this.log.error((Object)("Diamonds Error, might not be logged properly, see debug log. " + errorMessage));
        }
        if (this.diamondsListeners != null) {
            for (DiamondsListener diamondsListener : this.diamondsListeners) {
                try {
                    diamondsListener.targetBegin(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.debug((Object)"Error:", (Throwable)e);
                    String errorMessage = e.getMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    this.log.error((Object)("Diamonds Error, might not be logged properly, see debug log. " + errorMessage));
                }
            }
        }
    }

    private void parseConfig(String configFile, Hashtable<String, String> antProperties) {
        TemplateProcessor templateProcessor = new TemplateProcessor();
        File outputFile = null;
        try {
            outputFile = File.createTempFile("diamonds", "-config.xml");
            outputFile.deleteOnExit();
            this.log.debug((Object)("Preprocessing the diamonds configuration: " + configFile));
            ArrayList<PropertiesSource> sourceList = new ArrayList<PropertiesSource>();
            sourceList.add(new PropertiesSource("ant", antProperties));
            templateProcessor.convertTemplate(configFile, outputFile.toString(), sourceList);
        }
        catch (Exception e) {
            throw new BuildException("Diamonds configuration pre-parsing error: " + e.getMessage());
        }
        try {
            DiamondsConfig.parseConfiguration(outputFile.toString());
        }
        catch (Exception e) {
            throw new BuildException("Diamonds configuration parsing error: " + e.getMessage());
        }
    }

    private void addListeners(BuildEvent event) throws DiamondsException {
        if (DiamondsConfig.isStagesInConfig()) {
            StageDiamondsListener stageListener = new StageDiamondsListener();
            this.diamondsListeners.add(stageListener);
            stageListener.buildBegin(event);
        }
        if (DiamondsConfig.isTargetsInConfig()) {
            TargetDiamondsListener targetListener = new TargetDiamondsListener();
            this.diamondsListeners.add(targetListener);
            targetListener.buildBegin(event);
        }
    }

    public void targetFinished(BuildEvent event) {
        if (this.diamondsListeners != null) {
            for (DiamondsListener diamondsListener : this.diamondsListeners) {
                try {
                    diamondsListener.targetEnd(event);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Error:", (Throwable)e);
                    String errorMessage = e.getMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    this.log.error((Object)("Diamonds Error, might not be logged properly, see debug log. " + errorMessage));
                }
            }
        }
    }

    public void buildFinished(BuildEvent event) {
        if (this.diamondsListeners != null) {
            for (DiamondsListener diamondsListener : this.diamondsListeners) {
                try {
                    diamondsListener.buildEnd(event);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to log in diamonds: " + e));
                }
            }
        }
        this.project = event.getProject();
        this.cleanup();
    }

    private void cleanup() {
        File f;
        String loggingoutputfile = this.project.getProperty("logging.output.file");
        if (loggingoutputfile != null && (f = new File(loggingoutputfile)).exists()) {
            f.delete();
        }
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }
}

