/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.quality.ant.taskdefs;

import com.nokia.helium.core.ant.types.Variable;
import com.nokia.helium.core.ant.types.VariableSet;
import java.io.File;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;

public class Coverity
extends Task {
    private String command;
    private boolean failOnError;
    private boolean execute = true;
    private String dir;
    private Vector<VariableSet> coverityOptions = new Vector();
    private Vector<Variable> coverityArgs = new Vector();

    public void execute() {
        this.validateParameters();
        this.runCommand(this.command);
    }

    private void runCommand(String command) {
        block7: {
            String commandString = command;
            if (!command.startsWith("cov-")) {
                throw new BuildException("Coverity task can run only coverity prevent tool commands.");
            }
            ExecTask task = new ExecTask();
            task.setProject(this.getProject());
            task.setTaskName(this.getTaskName());
            task.setFailonerror(this.failOnError);
            task.setExecutable(command);
            task.setDir(new File(this.dir));
            for (VariableSet variableSet : this.coverityOptions) {
                for (Map.Entry entry : variableSet.getVariablesMap().entrySet()) {
                    task.createArg().setValue((String)entry.getKey());
                    task.createArg().setValue(((Variable)entry.getValue()).getValue());
                    commandString = commandString + " " + (String)entry.getKey() + " " + ((Variable)entry.getValue()).getValue();
                }
            }
            for (Variable variable : this.coverityArgs) {
                task.createArg().setValue(variable.getName());
                task.createArg().setValue(variable.getValue());
                commandString = commandString + " " + variable.getName() + " " + variable.getValue();
            }
            try {
                this.log("run command: " + commandString);
                if (this.execute) {
                    task.execute();
                }
            }
            catch (BuildException be) {
                if (!this.failOnError) break block7;
                throw new BuildException("exception during coverity command '" + command + "' execution:", (Throwable)be);
            }
        }
    }

    private void validateParameters() {
        if (this.command == null) {
            throw new BuildException("'command' parameter should not be null for coverity task.");
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setExecute(boolean execute) {
        this.execute = execute;
    }

    public void addCoverityOptions(VariableSet coverityArg) {
        if (!this.coverityOptions.contains(coverityArg)) {
            this.coverityOptions.add(coverityArg);
        }
    }

    public void addArg(Variable coverityArg) {
        if (!this.coverityArgs.contains(coverityArg)) {
            this.coverityArgs.add(coverityArg);
        }
    }
}

