/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.CacheDownloadOptions;
import org.apache.ivy.core.cache.CacheMetadataOptions;
import org.apache.ivy.core.cache.DownloadListener;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.download.EndArtifactDownloadEvent;
import org.apache.ivy.core.event.download.NeedArtifactEvent;
import org.apache.ivy.core.event.download.StartArtifactDownloadEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.HasLatestStrategy;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public abstract class AbstractResolver
implements DependencyResolver,
HasLatestStrategy {
    private Boolean validate = null;
    private String name;
    private ResolverSettings settings;
    private EventManager eventManager = null;
    private LatestStrategy latestStrategy;
    private String latestStrategyName;
    private Namespace namespace;
    private String namespaceName;
    private String cacheManagerName;
    private RepositoryCacheManager repositoryCacheManager;
    private String changingMatcherName;
    private String changingPattern;
    private Boolean checkmodified;

    public ResolverSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ResolverSettings ivy) {
        this.settings = ivy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String hidePassword(String name) {
        return name;
    }

    protected boolean doValidate(ResolveData data) {
        if (this.validate != null) {
            return this.validate;
        }
        return data.isValidate();
    }

    public boolean isValidate() {
        return this.validate == null ? true : this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    protected void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }

    public void reportFailure() {
        Message.verbose("no failure report implemented by " + this.getName());
    }

    public void reportFailure(Artifact art) {
        Message.verbose("no failure report implemented by " + this.getName());
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        return new String[0];
    }

    public OrganisationEntry[] listOrganisations() {
        return new OrganisationEntry[0];
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        return new ModuleEntry[0];
    }

    public RevisionEntry[] listRevisions(ModuleEntry module) {
        return new RevisionEntry[0];
    }

    public String toString() {
        return this.getName();
    }

    public void dumpSettings() {
        Message.verbose("\t" + this.getName() + " [" + this.getTypeName() + "]");
        Message.debug("\t\tcache: " + this.cacheManagerName);
    }

    public String getTypeName() {
        return this.getClass().getName();
    }

    public boolean exists(Artifact artifact) {
        DownloadReport dr = this.download(new Artifact[]{artifact}, new DownloadOptions());
        ArtifactDownloadReport adr = dr.getArtifactReport(artifact);
        return adr.getDownloadStatus() != DownloadStatus.FAILED;
    }

    public LatestStrategy getLatestStrategy() {
        if (this.latestStrategy == null) {
            if (this.getSettings() != null) {
                if (this.latestStrategyName != null && !"default".equals(this.latestStrategyName)) {
                    this.latestStrategy = this.getSettings().getLatestStrategy(this.latestStrategyName);
                    if (this.latestStrategy == null) {
                        Message.error("unknown latest strategy: " + this.latestStrategyName);
                        this.latestStrategy = this.getSettings().getDefaultLatestStrategy();
                    }
                } else {
                    this.latestStrategy = this.getSettings().getDefaultLatestStrategy();
                    Message.debug(this.getName() + ": no latest strategy defined: using default");
                }
            } else {
                throw new IllegalStateException("no ivy instance found: impossible to get a latest strategy without ivy instance");
            }
        }
        return this.latestStrategy;
    }

    public void setLatestStrategy(LatestStrategy latestStrategy) {
        this.latestStrategy = latestStrategy;
    }

    public void setLatest(String strategyName) {
        this.latestStrategyName = strategyName;
    }

    public String getLatest() {
        if (this.latestStrategyName == null) {
            this.latestStrategyName = "default";
        }
        return this.latestStrategyName;
    }

    public Namespace getNamespace() {
        if (this.namespace == null) {
            if (this.getSettings() != null) {
                if (this.namespaceName != null) {
                    this.namespace = this.getSettings().getNamespace(this.namespaceName);
                    if (this.namespace == null) {
                        Message.error("unknown namespace: " + this.namespaceName);
                        this.namespace = this.getSettings().getSystemNamespace();
                    }
                } else {
                    this.namespace = this.getSettings().getSystemNamespace();
                    Message.debug(this.getName() + ": no namespace defined: using system");
                }
            } else {
                Message.verbose(this.getName() + ": no namespace defined nor ivy instance: using system namespace");
                this.namespace = Namespace.SYSTEM_NAMESPACE;
            }
        }
        return this.namespace;
    }

    public void setNamespace(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    protected ModuleDescriptor toSystem(ModuleDescriptor md) {
        return NameSpaceHelper.toSystem(md, this.getNamespace());
    }

    protected Artifact fromSystem(Artifact artifact) {
        return NameSpaceHelper.transform(artifact, this.getNamespace().getFromSystemTransformer());
    }

    protected Artifact toSystem(Artifact artifact) {
        return NameSpaceHelper.transform(artifact, this.getNamespace().getToSystemTransformer());
    }

    protected ResolvedModuleRevision toSystem(ResolvedModuleRevision rmr) {
        return NameSpaceHelper.toSystem(rmr, this.getNamespace());
    }

    protected ModuleRevisionId toSystem(ModuleRevisionId resolvedMrid) {
        return this.getNamespace().getToSystemTransformer().transform(resolvedMrid);
    }

    protected DependencyDescriptor fromSystem(DependencyDescriptor dd) {
        return NameSpaceHelper.transform(dd, this.getNamespace().getFromSystemTransformer(), true);
    }

    protected DependencyDescriptor toSystem(DependencyDescriptor dd) {
        return NameSpaceHelper.transform(dd, this.getNamespace().getToSystemTransformer(), true);
    }

    protected IvyNode getSystemNode(ResolveData data, ModuleRevisionId resolvedMrid) {
        return data.getNode(this.toSystem(resolvedMrid));
    }

    protected ResolvedModuleRevision findModuleInCache(DependencyDescriptor dd, CacheMetadataOptions options) {
        return this.findModuleInCache(dd, options, false);
    }

    protected ResolvedModuleRevision findModuleInCache(DependencyDescriptor dd, CacheMetadataOptions options, boolean anyResolver) {
        return this.getRepositoryCacheManager().findModuleInCache(dd, options, anyResolver ? null : this.getName());
    }

    public void setChangingMatcher(String changingMatcherName) {
        this.changingMatcherName = changingMatcherName;
    }

    protected String getChangingMatcherName() {
        return this.changingMatcherName;
    }

    public void setChangingPattern(String changingPattern) {
        this.changingPattern = changingPattern;
    }

    protected String getChangingPattern() {
        return this.changingPattern;
    }

    public void setCheckmodified(boolean check) {
        this.checkmodified = check;
    }

    public RepositoryCacheManager getRepositoryCacheManager() {
        if (this.repositoryCacheManager == null) {
            this.repositoryCacheManager = this.cacheManagerName == null ? this.settings.getDefaultRepositoryCacheManager() : this.settings.getRepositoryCacheManager(this.cacheManagerName);
        }
        return this.repositoryCacheManager;
    }

    public void setRepositoryCacheManager(RepositoryCacheManager repositoryCacheManager) {
        this.repositoryCacheManager = repositoryCacheManager;
    }

    public void setCache(String cacheName) {
        this.cacheManagerName = cacheName;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    protected CacheMetadataOptions getCacheOptions(ResolveData data) {
        return (CacheMetadataOptions)new CacheMetadataOptions().setChangingMatcherName(this.getChangingMatcherName()).setChangingPattern(this.getChangingPattern()).setCheckmodified(this.checkmodified).setValidate(this.doValidate(data)).setNamespace(this.getNamespace()).setForce(data.getOptions().isRefresh()).setListener(this.getDownloadListener(this.getDownloadOptions(data.getOptions())));
    }

    protected CacheDownloadOptions getCacheDownloadOptions(DownloadOptions options) {
        return new CacheDownloadOptions().setListener(this.getDownloadListener(options));
    }

    protected DownloadOptions getDownloadOptions(ResolveOptions options) {
        return (DownloadOptions)new DownloadOptions().setLog(options.getLog());
    }

    public void abortPublishTransaction() throws IOException {
    }

    public void commitPublishTransaction() throws IOException {
    }

    public void beginPublishTransaction(ModuleRevisionId module, boolean overwrite) throws IOException {
    }

    private DownloadListener getDownloadListener(final DownloadOptions options) {
        return new DownloadListener(){

            public void needArtifact(RepositoryCacheManager cache, Artifact artifact) {
                if (AbstractResolver.this.eventManager != null) {
                    AbstractResolver.this.eventManager.fireIvyEvent(new NeedArtifactEvent(AbstractResolver.this, artifact));
                }
            }

            public void startArtifactDownload(RepositoryCacheManager cache, ResolvedResource rres, Artifact artifact, ArtifactOrigin origin) {
                if (artifact.isMetadata() || "quiet".equals(options.getLog())) {
                    Message.verbose("downloading " + rres.getResource() + " ...");
                } else {
                    Message.info("downloading " + rres.getResource() + " ...");
                }
                if (AbstractResolver.this.eventManager != null) {
                    AbstractResolver.this.eventManager.fireIvyEvent(new StartArtifactDownloadEvent(AbstractResolver.this, artifact, origin));
                }
            }

            public void endArtifactDownload(RepositoryCacheManager cache, Artifact artifact, ArtifactDownloadReport adr, File archiveFile) {
                if (AbstractResolver.this.eventManager != null) {
                    AbstractResolver.this.eventManager.fireIvyEvent(new EndArtifactDownloadEvent(AbstractResolver.this, artifact, adr, archiveFile));
                }
            }
        };
    }
}

