/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PomReader {
    private static final String PACKAGING = "packaging";
    private static final String DEPENDENCY = "dependency";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCY_MGT = "dependencyManagement";
    private static final String PROJECT = "project";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String PARENT = "parent";
    private static final String SCOPE = "scope";
    private static final String CLASSIFIER = "classifier";
    private static final String OPTIONAL = "optional";
    private static final String EXCLUSIONS = "exclusions";
    private static final String EXCLUSION = "exclusion";
    private static final String DISTRIBUTION_MGT = "distributionManagement";
    private static final String RELOCATION = "relocation";
    private static final String PROPERTIES = "properties";
    private HashMap properties = new HashMap();
    private final Element projectElement;
    private final Element parentElement;

    public PomReader(URL descriptorURL, Resource res) throws IOException, SAXException {
        Document pomDomDoc = XMLHelper.parseToDom(descriptorURL, res);
        this.projectElement = pomDomDoc.getDocumentElement();
        if (!PROJECT.equals(this.projectElement.getNodeName())) {
            throw new SAXParseException("project must be the root tag", res.getName(), res.getName(), 0, 0);
        }
        this.parentElement = PomReader.getFirstChildElement(this.projectElement, PARENT);
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    public void setProperty(String prop, String val) {
        if (!this.properties.containsKey(prop) && val != null) {
            this.properties.put(prop, val);
        }
    }

    public String getGroupId() {
        String groupId = PomReader.getFirstChildText(this.projectElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.parentElement, GROUP_ID);
        }
        return this.replaceProps(groupId);
    }

    public String getParentGroupId() {
        String groupId = PomReader.getFirstChildText(this.parentElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.projectElement, GROUP_ID);
        }
        return this.replaceProps(groupId);
    }

    public String getArtifactId() {
        String val = PomReader.getFirstChildText(this.projectElement, ARTIFACT_ID);
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, ARTIFACT_ID);
        }
        return this.replaceProps(val);
    }

    public String getParentArtifactId() {
        String val = PomReader.getFirstChildText(this.parentElement, ARTIFACT_ID);
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, ARTIFACT_ID);
        }
        return this.replaceProps(val);
    }

    public String getVersion() {
        String val = PomReader.getFirstChildText(this.projectElement, VERSION);
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getParentVersion() {
        String val = PomReader.getFirstChildText(this.parentElement, VERSION);
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getPackaging() {
        String val = PomReader.getFirstChildText(this.projectElement, PACKAGING);
        if (val == null) {
            val = "jar";
        }
        return val;
    }

    public ModuleRevisionId getRelocation() {
        Element distrMgt = PomReader.getFirstChildElement(this.projectElement, DISTRIBUTION_MGT);
        Element relocation = PomReader.getFirstChildElement(distrMgt, RELOCATION);
        if (relocation == null) {
            return null;
        }
        String relocGroupId = PomReader.getFirstChildText(relocation, GROUP_ID);
        String relocArtId = PomReader.getFirstChildText(relocation, ARTIFACT_ID);
        String relocVersion = PomReader.getFirstChildText(relocation, VERSION);
        relocGroupId = relocGroupId == null ? this.getGroupId() : relocGroupId;
        relocArtId = relocArtId == null ? this.getArtifactId() : relocArtId;
        relocVersion = relocVersion == null ? this.getVersion() : relocVersion;
        return ModuleRevisionId.newInstance(relocGroupId, relocArtId, relocVersion);
    }

    public List getDependencies() {
        Element dependenciesElement = PomReader.getFirstChildElement(this.projectElement, DEPENDENCIES);
        LinkedList<PomDependencyData> dependencies = new LinkedList<PomDependencyData>();
        if (dependenciesElement != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                dependencies.add(new PomDependencyData((Element)node));
            }
        }
        return dependencies;
    }

    public List getDependencyMgt() {
        Element dependenciesElement = PomReader.getFirstChildElement(this.projectElement, DEPENDENCY_MGT);
        dependenciesElement = PomReader.getFirstChildElement(dependenciesElement, DEPENDENCIES);
        LinkedList<PomDependencyMgt> dependencies = new LinkedList<PomDependencyMgt>();
        if (dependenciesElement != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                dependencies.add(new PomDependencyMgt((Element)node));
            }
        }
        return dependencies;
    }

    public Map getPomProperties() {
        HashMap<String, String> pomProperties = new HashMap<String, String>();
        Element propsEl = PomReader.getFirstChildElement(this.projectElement, PROPERTIES);
        if (propsEl != null) {
            propsEl.normalize();
        }
        Iterator it = PomReader.getAllChilds(propsEl).iterator();
        while (it.hasNext()) {
            Element prop = (Element)it.next();
            pomProperties.put(prop.getNodeName(), PomReader.getTextContent(prop));
        }
        return pomProperties;
    }

    private String replaceProps(String val) {
        if (val == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables(val, this.properties).trim();
    }

    private static String getTextContent(Element element) {
        StringBuffer result = new StringBuffer();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    result.append(child.getNodeValue());
                }
            }
        }
        return result.toString();
    }

    private static String getFirstChildText(Element parentElem, String name) {
        Element node = PomReader.getFirstChildElement(parentElem, name);
        if (node != null) {
            return PomReader.getTextContent(node);
        }
        return null;
    }

    private static Element getFirstChildElement(Element parentElem, String name) {
        if (parentElem == null) {
            return null;
        }
        NodeList childs = parentElem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element) || !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List getAllChilds(Element parent) {
        LinkedList<Node> r = new LinkedList<Node>();
        if (parent != null) {
            NodeList childs = parent.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element)) continue;
                r.add(node);
            }
        }
        return r;
    }

    public class PomDependencyData
    extends PomDependencyMgt {
        private final Element depElement;

        PomDependencyData(Element depElement) {
            super(depElement);
            this.depElement = depElement;
        }

        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.SCOPE);
            if (val == null) {
                return "compile";
            }
            return PomReader.this.replaceProps(val);
        }

        public String getClassifier() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.CLASSIFIER);
            return PomReader.this.replaceProps(val);
        }

        public boolean isOptional() {
            return PomReader.getFirstChildElement(this.depElement, PomReader.OPTIONAL) != null;
        }

        public List getExcludedModules() {
            Element exclusionsElement = PomReader.getFirstChildElement(this.depElement, PomReader.EXCLUSIONS);
            LinkedList<ModuleId> exclusions = new LinkedList<ModuleId>();
            if (exclusionsElement != null) {
                NodeList childs = exclusionsElement.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node node = childs.item(i);
                    if (!(node instanceof Element) || !PomReader.EXCLUSION.equals(node.getNodeName())) continue;
                    String groupId = PomReader.getFirstChildText((Element)node, PomReader.GROUP_ID);
                    String arteficatId = PomReader.getFirstChildText((Element)node, PomReader.ARTIFACT_ID);
                    exclusions.add(ModuleId.newInstance(groupId, arteficatId));
                }
            }
            return exclusions;
        }
    }

    public class PomDependencyMgt {
        private final Element depElement;

        PomDependencyMgt(Element depElement) {
            this.depElement = depElement;
        }

        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.GROUP_ID);
            return PomReader.this.replaceProps(val);
        }

        public String getArtifaceId() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.ARTIFACT_ID);
            return PomReader.this.replaceProps(val);
        }

        public String getVersion() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.VERSION);
            return PomReader.this.replaceProps(val);
        }
    }
}

