/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.listener;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public class TracingLogger
implements BuildListener {
    private Project project;
    private MemoryMXBean mbean;
    private boolean loggingEnabled;
    private PrintWriter out;
    private String currentTarget;

    public void buildFinished(BuildEvent event) {
        this.out.close();
    }

    public void buildStarted(BuildEvent event) {
        this.mbean = ManagementFactory.getMemoryMXBean();
        this.project = event.getProject();
    }

    public void messageLogged(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
        this.currentTarget = "";
    }

    public void targetStarted(BuildEvent event) {
        this.currentTarget = event.getTarget().getName();
        try {
            if (!this.loggingEnabled) {
                this.loggingEnabled = true;
                String tracingFile = this.project.getProperty("tracing.csv.file");
                this.out = new PrintWriter(tracingFile);
                this.out.print("target,task,committed,used,timestamp\n");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
    }

    public void taskFinished(BuildEvent event) {
        this.logMemoryUsage("task", event.getTask().getTaskName());
    }

    public void taskStarted(BuildEvent event) {
        this.logMemoryUsage("task", event.getTask().getTaskName());
    }

    private void logMemoryUsage(String type, String label) {
        if (this.loggingEnabled) {
            MemoryUsage heapMemory = this.mbean.getHeapMemoryUsage();
            this.project.log("Build event: " + label, 4);
            this.project.log("Max memory = " + heapMemory.getMax(), 4);
            this.project.log("Committed memory = " + heapMemory.getCommitted(), 4);
            this.project.log("Used memory = " + heapMemory.getUsed(), 4);
            long timestamp = System.currentTimeMillis();
            this.out.print(this.currentTarget + "," + label + "," + heapMemory.getCommitted() + "," + heapMemory.getUsed() + "," + String.valueOf(timestamp) + "\n");
        }
    }
}

