/*
 * Decompiled with CFR 0.152.
 */
package nokia.ant;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlLogger
implements BuildLogger {
    private static final String BUILD_TAG = "build";
    private static final String TARGET_TAG = "target";
    private static final String TASK_TAG = "task";
    private static final String MESSAGE_TAG = "message";
    private static final String NAME_ATTR = "name";
    private static final String TIME_ATTR = "time";
    private static final String PRIORITY_ATTR = "priority";
    private static final String LOCATION_ATTR = "location";
    private static final String ERROR_ATTR = "error";
    private static final String STACKTRACE_TAG = "stacktrace";
    private static DocumentBuilder builder = XmlLogger.getDocumentBuilder();
    private int msgOutputLevel = 0;
    private PrintStream outStream;
    private Document doc = builder.newDocument();
    private Hashtable tasks = new Hashtable();
    private Hashtable targets = new Hashtable();
    private Hashtable threadStacks = new Hashtable();
    private TimedElement buildElement;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc.getMessage());
        }
    }

    public void buildStarted(BuildEvent event) {
        this.buildElement = new TimedElement();
        this.buildElement.startTime = System.currentTimeMillis();
        this.buildElement.element = this.doc.createElement(BUILD_TAG);
    }

    public void buildFinished(BuildEvent event) {
        String xslUri;
        String outFilename;
        long totalTime = System.currentTimeMillis() - this.buildElement.startTime;
        this.buildElement.element.setAttribute(TIME_ATTR, DateUtils.formatElapsedTime((long)totalTime));
        if (event.getException() != null) {
            this.buildElement.element.setAttribute(ERROR_ATTR, event.getException().toString());
            Throwable t = event.getException();
            CDATASection errText = this.doc.createCDATASection(StringUtils.getStackTrace((Throwable)t));
            Element stacktrace = this.doc.createElement(STACKTRACE_TAG);
            stacktrace.appendChild(errText);
            this.buildElement.element.appendChild(stacktrace);
        }
        if ((outFilename = event.getProject().getProperty("XmlLogger.file")) == null) {
            outFilename = "log.xml";
        }
        if ((xslUri = event.getProject().getProperty("ant.XmlLogger.stylesheet.uri")) == null) {
            xslUri = "log.xsl";
        }
        Writer out = null;
        try {
            OutputStream stream = this.outStream;
            if (stream == null) {
                stream = new FileOutputStream(outFilename);
            }
            out = new OutputStreamWriter(stream, "UTF8");
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            if (xslUri.length() > 0) {
                out.write("<?xml-stylesheet type=\"text/xsl\" href=\"" + xslUri + "\"?>\n\n");
            }
            new DOMElementWriter().write(this.buildElement.element, out, 0, "\t");
            out.flush();
        }
        catch (IOException exc) {
            throw new BuildException("Unable to write log file" + exc.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e2) {
                    event.getProject().log("Not able to close the file handler " + e2.getMessage(), 1);
                    Object e2 = null;
                }
            }
        }
        this.buildElement = null;
    }

    private Stack getStack() {
        Stack threadStack = (Stack)this.threadStacks.get(Thread.currentThread());
        if (threadStack == null) {
            threadStack = new Stack();
            this.threadStacks.put(Thread.currentThread(), threadStack);
        }
        return threadStack;
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    private TimedElement getTaskElement(Task task) {
        TimedElement element = (TimedElement)this.tasks.get(task);
        if (element != null) {
            return element;
        }
        Enumeration e = this.tasks.keys();
        while (e.hasMoreElements()) {
            Task key = (Task)e.nextElement();
            if (!(key instanceof UnknownElement) || ((UnknownElement)key).getTask() != task) continue;
            return (TimedElement)this.tasks.get(key);
        }
        return null;
    }

    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if (priority > this.msgOutputLevel) {
            return;
        }
        Element messageElement = this.doc.createElement(MESSAGE_TAG);
        String name = "debug";
        switch (event.getPriority()) {
            case 0: {
                name = ERROR_ATTR;
                break;
            }
            case 1: {
                name = "warn";
                break;
            }
            case 2: {
                name = "info";
                break;
            }
            default: {
                name = "debug";
            }
        }
        messageElement.setAttribute(PRIORITY_ATTR, name);
        Throwable ex = event.getException();
        if (4 <= this.msgOutputLevel && ex != null) {
            CDATASection errText = this.doc.createCDATASection(StringUtils.getStackTrace((Throwable)ex));
            Element stacktrace = this.doc.createElement(STACKTRACE_TAG);
            stacktrace.appendChild(errText);
            this.buildElement.element.appendChild(stacktrace);
        }
        CDATASection messageText = this.doc.createCDATASection(event.getMessage());
        messageElement.appendChild(messageText);
        TimedElement parentElement = null;
        Task task = event.getTask();
        Target target = event.getTarget();
        if (task != null) {
            parentElement = this.getTaskElement(task);
        }
        if (parentElement == null && target != null) {
            parentElement = (TimedElement)this.targets.get(target);
        }
        if (parentElement != null) {
            parentElement.element.appendChild(messageElement);
        } else {
            this.buildElement.element.appendChild(messageElement);
        }
    }

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.outStream = new PrintStream(output, true);
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream err) {
    }

    private static class TimedElement {
        private long startTime;
        private Element element;

        private TimedElement() {
        }

        public String toString() {
            return this.element.getTagName() + ":" + this.element.getAttribute(XmlLogger.NAME_ATTR);
        }
    }
}

