/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.taskdefs.AntlibDefinition;

public class Antlib
extends Task
implements TaskContainer {
    public static final String TAG = "antlib";
    private ClassLoader classLoader;
    private String uri = "";
    private List tasks = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Antlib createAntlib(Project project, URL antlibUrl, String uri) {
        try {
            antlibUrl.openConnection().connect();
        }
        catch (IOException ex) {
            throw new BuildException("Unable to find " + antlibUrl, (Throwable)ex);
        }
        ComponentHelper helper = ComponentHelper.getComponentHelper((Project)project);
        helper.enterAntLib(uri);
        try {
            ProjectHelper2 parser = new ProjectHelper2();
            UnknownElement ue = parser.parseUnknownElement(project, antlibUrl);
            if (!ue.getTag().equals(TAG)) {
                throw new BuildException("Unexpected tag " + ue.getTag() + " expecting " + TAG, ue.getLocation());
            }
            Antlib antlib = new Antlib();
            antlib.setProject(project);
            antlib.setLocation(ue.getLocation());
            antlib.setTaskName(TAG);
            antlib.init();
            ue.configure((Object)antlib);
            Antlib antlib2 = antlib;
            return antlib2;
        }
        finally {
            helper.exitAntLib();
        }
    }

    protected final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected final void setURI(String uri) {
        this.uri = uri;
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Antlib.class.getClassLoader();
        }
        return this.classLoader;
    }

    public final void addTask(Task nestedTask) {
        this.tasks.add(nestedTask);
    }

    public final void execute() {
        for (UnknownElement ue : this.tasks) {
            this.setLocation(ue.getLocation());
            ue.maybeConfigure();
            Object configuredObject = ue.getRealThing();
            if (configuredObject == null) continue;
            if (!(configuredObject instanceof AntlibDefinition)) {
                throw new BuildException("Invalid task in antlib " + ue.getTag() + " " + configuredObject.getClass() + " does not " + "extend org.apache.tools.ant.taskdefs.AntlibDefinition");
            }
            AntlibDefinition def = (AntlibDefinition)configuredObject;
            def.setURI(this.uri);
            def.setAntlibClassLoader(this.getClassLoader());
            def.init();
            def.execute();
        }
    }
}

