/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository;

import org.apache.ivy.plugins.repository.Resource;

public abstract class LazyResource
implements Resource {
    private boolean _init = false;
    private boolean _local;
    private String _name;
    private long _lastModified;
    private long _contentLength;
    private boolean _exists;

    public LazyResource(String name) {
        this._name = name;
    }

    protected abstract void init();

    private void checkInit() {
        if (!this._init) {
            this.init();
            this._init = true;
        }
    }

    public boolean exists() {
        this.checkInit();
        return this._exists;
    }

    public long getContentLength() {
        this.checkInit();
        return this._contentLength;
    }

    public long getLastModified() {
        this.checkInit();
        return this._lastModified;
    }

    public String getName() {
        return this._name;
    }

    public boolean isLocal() {
        this.checkInit();
        return this._local;
    }

    public String toString() {
        return this.getName();
    }

    protected void setContentLength(long contentLength) {
        this._contentLength = contentLength;
    }

    protected void setExists(boolean exists) {
        this._exists = exists;
    }

    protected void setLastModified(long lastModified) {
        this._lastModified = lastModified;
    }

    protected void setLocal(boolean local) {
        this._local = local;
    }

    protected void init(Resource r) {
        this.setContentLength(r.getContentLength());
        this.setLocal(r.isLocal());
        this.setLastModified(r.getLastModified());
        this.setExists(r.exists());
    }
}

