/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.TagInfo;

public class HtmlTagProvider
extends HashMap
implements ITagInfoProvider {
    private static HtmlTagProvider _instance;

    public static synchronized HtmlTagProvider getInstance() {
        if (_instance == null) {
            _instance = new HtmlTagProvider();
        }
        return _instance;
    }

    public HtmlTagProvider() {
        this.defineTags();
    }

    protected void addTag(String name, String contentType, int belongsTo, String dependancies) {
        this.put(name.toLowerCase(), new TagInfo(name, contentType, belongsTo, false, false, false, dependancies));
    }

    protected void defineTags() {
        this.addTag("div", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("span", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("meta", TagInfo.CONTENT_NONE, 1, null);
        this.addTag("link", TagInfo.CONTENT_NONE, 1, null);
        this.addTag("title", TagInfo.CONTENT_TEXT, 1, null);
        this.addTag("style", TagInfo.CONTENT_ALL, 1, null);
        this.addTag("bgsound", TagInfo.CONTENT_NONE, 1, null);
        this.addTag("h1", TagInfo.CONTENT_ALL, 2, "h1,h2,h3,h4,h5,h6");
        this.addTag("h2", TagInfo.CONTENT_ALL, 2, "h1,h2,h3,h4,h5,h6");
        this.addTag("h3", TagInfo.CONTENT_ALL, 2, "h1,h2,h3,h4,h5,h6");
        this.addTag("h4", TagInfo.CONTENT_ALL, 2, "h1,h2,h3,h4,h5,h6");
        this.addTag("h5", TagInfo.CONTENT_ALL, 2, "h1,h2,h3,h4,h5,h6");
        this.addTag("h6", TagInfo.CONTENT_ALL, 2, "h1,h2,h3,h4,h5,h6");
        this.addTag("p", TagInfo.CONTENT_ALL, 2, "p");
        this.addTag("strong", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("em", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("abbr", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("acronym", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("address", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("bdo", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("blockquote", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("cite", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("q", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("code", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("ins", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("del", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("dfn", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("kbd", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("pre", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("samp", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("listing", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("var", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("br", TagInfo.CONTENT_NONE, 2, null);
        this.addTag("wbr", TagInfo.CONTENT_NONE, 2, null);
        this.addTag("nobr", TagInfo.CONTENT_ALL, 2, "nobr");
        this.addTag("xmp", TagInfo.CONTENT_TEXT, 2, null);
        this.addTag("a", TagInfo.CONTENT_ALL, 2, "a");
        this.addTag("base", TagInfo.CONTENT_NONE, 1, null);
        this.addTag("img", TagInfo.CONTENT_NONE, 2, null);
        this.addTag("area", TagInfo.CONTENT_NONE, 2, "!map,area");
        this.addTag("map", TagInfo.CONTENT_ALL, 2, "map");
        this.addTag("object", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("param", TagInfo.CONTENT_NONE, 2, null);
        this.addTag("applet", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("xml", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("ul", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("ol", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("li", TagInfo.CONTENT_ALL, 2, "li");
        this.addTag("dl", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("dt", TagInfo.CONTENT_ALL, 2, "dt,dd");
        this.addTag("dd", TagInfo.CONTENT_ALL, 2, "dt,dd");
        this.addTag("menu", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("dir", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("table", TagInfo.CONTENT_ALL, 2, "#tr,#tbody,#thead,#tfoot,#colgroup,#caption,#tr,tr,thead,tbody,tfoot,caption,colgroup,table");
        this.addTag("tr", TagInfo.CONTENT_ALL, 2, "!table,+tbody,^thead,^tfoot,#td,#th,tr,caption,colgroup");
        this.addTag("td", TagInfo.CONTENT_ALL, 2, "!table,+tr,td,th,caption,colgroup");
        this.addTag("th", TagInfo.CONTENT_ALL, 2, "!table,+tr,td,th,caption,colgroup");
        this.addTag("tbody", TagInfo.CONTENT_ALL, 2, "!table,#tr,td,th,tr,tbody,thead,tfoot,caption,colgroup");
        this.addTag("thead", TagInfo.CONTENT_ALL, 2, "!table,#tr,td,th,tr,tbody,thead,tfoot,caption,colgroup");
        this.addTag("tfoot", TagInfo.CONTENT_ALL, 2, "!table,#tr,td,th,tr,tbody,thead,tfoot,caption,colgroup");
        this.addTag("col", TagInfo.CONTENT_NONE, 2, "!colgroup");
        this.addTag("colgroup", TagInfo.CONTENT_ALL, 2, "!table,#col,td,th,tr,tbody,thead,tfoot,caption,colgroup");
        this.addTag("caption", TagInfo.CONTENT_ALL, 2, "!table,td,th,tr,tbody,thead,tfoot,caption,colgroup");
        this.addTag("form", TagInfo.CONTENT_ALL, 2, "-form,option,optgroup,textarea,select,fieldset");
        this.addTag("input", TagInfo.CONTENT_NONE, 2, "select,optgroup,option");
        this.addTag("textarea", TagInfo.CONTENT_ALL, 2, "select,optgroup,option");
        this.addTag("select", TagInfo.CONTENT_ALL, 2, "#option,#optgroup,option,optgroup,select");
        this.addTag("option", TagInfo.CONTENT_TEXT, 2, "!select,option");
        this.addTag("optgroup", TagInfo.CONTENT_ALL, 2, "!select,#option,optgroup");
        this.addTag("button", TagInfo.CONTENT_ALL, 2, "select,optgroup,option");
        this.addTag("label", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("fieldset", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("isindex", TagInfo.CONTENT_NONE, 2, null);
        this.addTag("script", TagInfo.CONTENT_ALL, 0, null);
        this.addTag("noscript", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("b", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("i", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("u", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("tt", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("sub", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("sup", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("big", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("small", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("strike", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("blink", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("marquee", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("s", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("hr", TagInfo.CONTENT_NONE, 2, null);
        this.addTag("font", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("basefont", TagInfo.CONTENT_NONE, 2, null);
        this.addTag("center", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("comment", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("server", TagInfo.CONTENT_ALL, 2, null);
        this.addTag("iframe", TagInfo.CONTENT_NONE, 2, null);
        this.addTag("embed", TagInfo.CONTENT_NONE, 2, null);
        this.getTagInfo("title").setUnique(true);
        this.getTagInfo("form").setIgnorePermitted(true);
        this.getTagInfo("select").setIgnorePermitted(true);
        this.getTagInfo("option").setIgnorePermitted(true);
        this.getTagInfo("optgroup").setIgnorePermitted(true);
        String commonTags = "div,p,address,h1,h2,h3,h4,h5,h6,blockquote,pre,listing,ul,ol,li,dl,menu,dir,table,form,fieldset,isindex,marquee,center,embed,param,hr";
        this.addDependancy("p", commonTags);
        this.addDependancy("address", commonTags);
        this.addDependancy("label", commonTags);
        this.addDependancy("abbr", commonTags);
        this.addDependancy("acronym", commonTags);
        this.addDependancy("dfn", commonTags);
        this.addDependancy("kbd", commonTags);
        this.addDependancy("samp", commonTags);
        this.addDependancy("var", commonTags);
        this.addDependancy("cite", commonTags);
        this.addDependancy("code", commonTags);
        this.addDependancy("param", commonTags);
        this.addDependancy("xml", commonTags);
        this.addDependancy("&a", commonTags);
        this.addDependancy("&bdo", commonTags);
        this.addDependancy("&strong", commonTags);
        this.addDependancy("&em", commonTags);
        this.addDependancy("&q", commonTags);
        this.addDependancy("&b", commonTags);
        this.addDependancy("&i", commonTags);
        this.addDependancy("&u", commonTags);
        this.addDependancy("&tt", commonTags);
        this.addDependancy("&sub", commonTags);
        this.addDependancy("&sup", commonTags);
        this.addDependancy("&big", commonTags);
        this.addDependancy("&small", commonTags);
        this.addDependancy("&strike", commonTags);
        this.addDependancy("&s", commonTags);
        this.addDependancy("&font", commonTags);
        this.getTagInfo("applet").setDeprecated(true);
        this.getTagInfo("basefont").setDeprecated(true);
        this.getTagInfo("center").setDeprecated(true);
        this.getTagInfo("dir").setDeprecated(true);
        this.getTagInfo("font").setDeprecated(true);
        this.getTagInfo("isindex").setDeprecated(true);
        this.getTagInfo("menu").setDeprecated(true);
        this.getTagInfo("s").setDeprecated(true);
        this.getTagInfo("strike").setDeprecated(true);
        this.getTagInfo("u").setDeprecated(true);
    }

    protected void addDependancy(String tagName, String tagList) {
        if (tagList != null) {
            StringTokenizer tokenizer = new StringTokenizer(tagList, ",.");
            while (tokenizer.hasMoreTokens()) {
                TagInfo curr = this.getTagInfo(tokenizer.nextToken().trim());
                curr.addDependancy(tagName);
            }
        }
    }

    public TagInfo getTagInfo(String tagName) {
        if (tagName != null) {
            return (TagInfo)this.get(tagName.toLowerCase());
        }
        return null;
    }
}

