/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.dom4j.Element;

public class CheckPropertyName
extends AbstractCheck {
    @Override
    public void run(Element node) {
        String text;
        if (node.getName().equals("property") && (text = node.attributeValue("name")) != null && !text.isEmpty()) {
            this.checkPropertyName(text);
        }
    }

    private void checkPropertyName(String propertyName) {
        try {
            Pattern p1 = Pattern.compile(this.getPattern());
            Matcher m1 = p1.matcher(propertyName);
            if (!m1.matches() && !this.isPropertyAlreadyVisited(propertyName)) {
                this.log("INVALID Property Name: " + propertyName);
                this.getAntFile().markPropertyAsVisited(propertyName);
            }
        }
        catch (Exception e) {
            throw new BuildException("Not able to match the Property Name for " + propertyName);
        }
    }

    private boolean isPropertyAlreadyVisited(String propertyName) {
        return this.getAntFile().isPropertyVisited(propertyName);
    }
}

