/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.axes.SelfContext;
import org.apache.commons.jxpath.ri.compiler.CoreOperation;
import org.apache.commons.jxpath.ri.compiler.Expression;

public abstract class CoreOperationCompare
extends CoreOperation {
    public CoreOperationCompare(Expression arg1, Expression arg2) {
        super(new Expression[]{arg1, arg2});
    }

    protected boolean equal(EvalContext context, Expression left, Expression right) {
        Iterator l = left.compute(context);
        Iterator r = right.compute(context);
        if (l instanceof InitialContext || l instanceof SelfContext) {
            l = ((EvalContext)l).getSingleNodePointer();
        }
        if (r instanceof InitialContext || r instanceof SelfContext) {
            r = ((EvalContext)r).getSingleNodePointer();
        }
        if (l instanceof Collection) {
            l = ((Collection)((Object)l)).iterator();
        }
        if (r instanceof Collection) {
            r = ((Collection)((Object)r)).iterator();
        }
        if (l instanceof Iterator && !(r instanceof Iterator)) {
            return this.contains(l, r);
        }
        if (!(l instanceof Iterator) && r instanceof Iterator) {
            return this.contains(r, l);
        }
        if (l instanceof Iterator && r instanceof Iterator) {
            return this.findMatch(l, r);
        }
        return this.equal(l, r);
    }

    protected boolean contains(Iterator it, Object value) {
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.equal(element, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean findMatch(Iterator lit, Iterator rit) {
        HashSet left = new HashSet();
        while (lit.hasNext()) {
            left.add(lit.next());
        }
        while (rit.hasNext()) {
            if (!this.contains(left.iterator(), rit.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean equal(Object l, Object r) {
        if (l instanceof Pointer && r instanceof Pointer && l.equals(r)) {
            return true;
        }
        if (l instanceof Pointer) {
            l = ((Pointer)l).getValue();
        }
        if (r instanceof Pointer) {
            r = ((Pointer)r).getValue();
        }
        if (l == r) {
            return true;
        }
        if (l instanceof Boolean || r instanceof Boolean) {
            return InfoSetUtil.booleanValue(l) == InfoSetUtil.booleanValue(r);
        }
        if (l instanceof Number || r instanceof Number) {
            return InfoSetUtil.doubleValue(l) == InfoSetUtil.doubleValue(r);
        }
        if (l instanceof String || r instanceof String) {
            return InfoSetUtil.stringValue(l).equals(InfoSetUtil.stringValue(r));
        }
        if (l == null) {
            return r == null;
        }
        return l.equals(r);
    }
}

