/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.dom4j.Element;

public class CheckPresetDefMacroDefName
extends AbstractCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("presetdef") || node.getName().equals("macrodef")) {
            String text = node.attributeValue("name");
            if (text != null && !text.isEmpty()) {
                this.checkDefName(text);
            }
            List attributeList = node.elements("attribute");
            for (Element attributeElement : attributeList) {
                String attributeName = attributeElement.attributeValue("name");
                this.checkDefName(attributeName);
            }
        }
    }

    private void checkDefName(String text) {
        try {
            Pattern p1 = Pattern.compile(this.getPattern());
            Matcher m1 = p1.matcher(text);
            if (!m1.matches()) {
                this.log("INVALID PRESETDEF/MACRODEF Name: " + text);
            }
        }
        catch (Exception e) {
            throw new BuildException("Not able to match the MacroDef Name for " + text);
        }
    }
}

