/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.latex.PropertyManager;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.LaTeXConverter;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLBlockTag;
import info.bliki.wiki.tags.NowikiTag;
import info.bliki.wiki.tags.util.INoBodyParsingTag;
import java.io.IOException;
import java.util.regex.Pattern;

public class PreTag
extends HTMLBlockTag
implements INoBodyParsingTag {
    private static final Pattern NOWIKI_OPEN_PATTERN = Pattern.compile("\\<nowiki\\>", 2);
    private static final Pattern NOWIKI_CLOSE_PATTERN = Pattern.compile("\\<\\/nowiki\\>", 2);

    public PreTag() {
        super("pre", "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            writer.append("\n<pre>");
            content = NOWIKI_OPEN_PATTERN.matcher(content).replaceAll("");
            content = NOWIKI_CLOSE_PATTERN.matcher(content).replaceAll("");
            NowikiTag.copyPre(content, writer, false);
            writer.append("</pre>");
        }
    }

    public void renderLaTeX(ITextConverter converter, Appendable _out, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            boolean inTable = this.getParent() instanceof WPTable;
            if (inTable) {
                _out.append(PropertyManager.get("CodeBlock.inTable.Begin"));
                _out.append(LaTeXConverter.verbToText(content));
                _out.append(PropertyManager.get("CodeBlock.inTable.End"));
            } else {
                _out.append(PropertyManager.get("CodeBlock.Begin"));
                _out.append(content);
                _out.append(PropertyManager.get("CodeBlock.End"));
            }
        }
    }

    public boolean isReduceTokenStack() {
        return true;
    }
}

