/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.logger.ant.listener;

import com.nokia.helium.logger.ant.listener.Handler;
import com.nokia.helium.logger.ant.listener.RecorderEntry;
import com.nokia.helium.logger.ant.listener.StatusAndLogListener;
import com.nokia.helium.logger.ant.types.Stage;
import com.nokia.helium.logger.ant.types.StageLogging;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;

public class AntLoggingHandler
implements Handler {
    private static Hashtable<File, RecorderEntry> recorderEntries = new Hashtable();
    private Map<String, Stage> stagesMapping;
    private Map<String, StageLogging> stageRecordMap;
    private HashMap<String, Vector<Target>> depStartTargetMap;
    private HashMap<String, Target> stageStartTargetMap;
    private HashMap<File, Boolean> fileCreatedMap;
    private boolean isStageRecordingHappening;
    private boolean loggingStarted;
    private boolean isStageInformationInited;
    private boolean isDefaultStageStarted;
    private int loglevel = -1;
    private VerbosityLevelChoices antLogLevel;
    private Logger log = Logger.getLogger(AntLoggingHandler.class);
    private String currentStageName;
    private Project project;

    public AntLoggingHandler(Project project) {
        this.project = project;
        this.antLogLevel = new VerbosityLevelChoices();
        this.stagesMapping = new HashMap<String, Stage>();
        this.stageRecordMap = new HashMap<String, StageLogging>();
        this.depStartTargetMap = new HashMap();
        this.stageStartTargetMap = new HashMap();
        this.fileCreatedMap = new HashMap();
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public void handleTargetFinished(BuildEvent buildEvent) {
        if (this.isEndTarget(buildEvent.getTarget().getName()) && this.getIsStageRecordingHappening() && this.getLoggingStarted()) {
            this.log.debug((Object)("Stopping stage logging for  [" + this.currentStageName + "] for target [" + buildEvent.getTarget().getName() + "]"));
            this.stopLog(this.currentStageName, "default");
            this.startLog("default");
            this.currentStageName = null;
        }
    }

    @Override
    public void handleTargetStarted(BuildEvent buildEvent) {
        String string;
        if (!this.isStageInformationInited) {
            this.initStagesInformation(buildEvent.getProject());
            this.isStageInformationInited = true;
        }
        if (this.isStageInformationInited && this.getLoggingStarted() && !this.isDefaultStageStarted) {
            this.startLog("default");
            this.isDefaultStageStarted = true;
        }
        if (this.currentStageName == null && !this.getIsStageRecordingHappening() && this.getLoggingStarted() && (string = this.isStageValid(buildEvent.getTarget(), buildEvent.getProject())) != null) {
            this.log.debug((Object)("Started stage logging for  [" + string + "] for target [" + buildEvent.getTarget().getName() + "]"));
            this.stopLog("default", string);
            this.startLog(string);
            this.currentStageName = string;
        }
    }

    @Override
    public void handleBuildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void handleBuildFinished(BuildEvent buildEvent) {
        if (this.isDefaultStageStarted && this.getLoggingStarted()) {
            this.stopLog("default", null, buildEvent);
        }
        this.cleanup();
    }

    protected RecorderEntry getRecorder(File file) {
        RecorderEntry recorderEntry = recorderEntries.get(file);
        if (recorderEntry == null) {
            recorderEntry = new RecorderEntry(file);
            recorderEntries.put(file, recorderEntry);
        }
        return recorderEntry;
    }

    public void setLoglevel(VerbosityLevelChoices verbosityLevelChoices) {
        this.loglevel = verbosityLevelChoices.getLevel();
    }

    private void cleanup() {
        this.log.debug((Object)"Cleaning up recorder entries of stagerecord");
        recorderEntries.clear();
    }

    private String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EE yyyy/MM/dd HH:mm:ss:SS aaa");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public String getCurrentStageName() {
        return this.currentStageName;
    }

    public void doLoggingAction(String string, boolean bl, String string2, Task task, Target target) {
        String string3 = this.getDateTime();
        File file = string.equalsIgnoreCase("default") ? this.stageRecordMap.get("default").getDefaultOutput() : this.stageRecordMap.get(string).getOutput();
        if (file.exists()) {
            for (Map.Entry<File, RecorderEntry> entry : recorderEntries.entrySet()) {
                if (!file.equals(entry.getKey()) || this.getRecorderEntry(file) == null || !this.fileCreatedMap.get(file).booleanValue()) continue;
                RecorderEntry recorderEntry = this.getRecorderEntry(file);
                recorderEntry.addLogMessage(string2 + " logging into " + file + " from " + task.getTaskName() + " task at " + string3);
                this.log.debug((Object)(string2 + " logging into " + file + " from " + task.getTaskName() + " task at " + string3));
                recorderEntry.setRecordState(bl);
                break;
            }
        }
    }

    public void addRegExp(String string) {
        if (!string.equals("")) {
            for (Map.Entry<File, RecorderEntry> entry : recorderEntries.entrySet()) {
                RecorderEntry recorderEntry = entry.getValue();
                recorderEntry.addRegexp(string);
            }
        }
    }

    private void initStagesInformation(Project project) {
        this.log.debug((Object)("initStagesInformation: project: " + project.getName()));
        Hashtable hashtable = project.getReferences();
        Enumeration enumeration = hashtable.keys();
        this.validateDefaultStage(hashtable);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!(hashtable.get(string) instanceof Stage)) continue;
            Stage stage = (Stage)((Object)hashtable.get(string));
            this.validateStageInformation(string, stage);
            this.log.debug((Object)("Found  stage [" + string + "] for recording"));
            this.stagesMapping.put(string, (Stage)((Object)hashtable.get(string)));
            this.getStageRecordInformation(project, string);
            this.initDependentTargetMap(project, string, stage.getStartTarget(), stage.getEndTarget());
        }
    }

    private void getStageRecordInformation(Project project, String string) {
        Hashtable hashtable = project.getReferences();
        this.matchStageName(hashtable, string);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            StageLogging stageLogging;
            String string2 = (String)enumeration.nextElement();
            if (!(hashtable.get(string2) instanceof StageLogging) || (stageLogging = (StageLogging)((Object)hashtable.get(string2))).getStageRefID() == null || !stageLogging.getStageRefID().equals(string)) continue;
            this.validateStageLogging(string2, stageLogging);
            this.stageRecordMap.put(string, stageLogging);
            return;
        }
    }

    private void startLog(String string) {
        RecorderEntry recorderEntry;
        String string2;
        File file;
        String string3 = this.getDateTime();
        StageLogging stageLogging = null;
        this.log.debug((Object)("Starting logging for [" + string + "]"));
        if (string.equals("default")) {
            file = this.stageRecordMap.get("default").getDefaultOutput();
            stageLogging = this.stageRecordMap.get("default");
            string2 = "Starting logging into " + file + " at " + string3;
        } else {
            file = this.stageRecordMap.get(string).getOutput();
            stageLogging = this.stageRecordMap.get(string);
            this.isStageRecordingHappening = true;
            string2 = "Starting logging for " + string + " into " + file + " at " + string3;
        }
        if (this.getRecorderEntry(file) != null && this.isFilePresent(recorderEntry = this.getRecorderEntry(file), file, stageLogging)) {
            recorderEntry.setRecordState(true);
            recorderEntry.addLogMessage(string2);
        }
    }

    private boolean isFilePresent(RecorderEntry recorderEntry, File file, StageLogging stageLogging) {
        this.log.debug((Object)("isFilePresent? " + file));
        if (!this.fileCreatedMap.get(file).booleanValue()) {
            if (!file.getParentFile().exists()) {
                this.log.debug((Object)("Creating dir: " + file.getParentFile()));
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                long l = System.currentTimeMillis();
                StatusAndLogListener.getStatusAndLogListener().getProject().log("Backing up of " + file + " into " + file + "." + l);
                file.renameTo(new File(file.getAbsoluteFile() + "." + l));
            }
            recorderEntry.openFile(stageLogging.getAppend());
            this.fileCreatedMap.put(file, true);
            return true;
        }
        return true;
    }

    private void stopLog(String string, String string2) {
        this.stopLog(string, string2, null);
    }

    private void stopLog(String string, String string2, BuildEvent buildEvent) {
        String string3;
        File file;
        String string4 = this.getDateTime();
        this.log.debug((Object)("Stopping logging for [" + string + "]"));
        if (string.equals("default")) {
            file = this.stageRecordMap.get("default").getDefaultOutput();
            string3 = "Stopping logging into " + file + " at " + string4;
            if (string2 != null) {
                string3 = string3 + "\nStarting logging into " + this.stageRecordMap.get(string2).getOutput();
            }
        } else {
            file = this.stageRecordMap.get(string).getOutput();
            this.isStageRecordingHappening = false;
            string3 = "Stopping logging for " + string + " into " + file + " at " + string4;
            if (string2 != null) {
                string3 = string3 + "\nResuming logging into " + this.stageRecordMap.get("default").getDefaultOutput();
            }
        }
        if (this.getRecorderEntry(file) != null) {
            RecorderEntry recorderEntry = this.getRecorderEntry(file);
            if (buildEvent != null) {
                recorderEntry.handleBuildFinished(buildEvent);
            } else {
                recorderEntry.addLogMessage(string3);
                recorderEntry.setRecordState(false);
            }
        }
    }

    private void registerRecorderEntry(File file, StageLogging stageLogging, Project project) {
        this.log.debug((Object)("Registering recorderentry for log file [" + file + "]"));
        RecorderEntry recorderEntry = this.getRecorder(file);
        this.antLogLevel.setValue(stageLogging.getLogLevel());
        this.setLoglevel(this.antLogLevel);
        recorderEntry.setMessageOutputLevel(this.loglevel);
        recorderEntry.setEmacsMode(false);
        recorderEntry.setRecordState(false);
        this.fileCreatedMap.put(file, false);
    }

    private String isStageValid(Target target, Project project) {
        if (!project.getName().equals(StatusAndLogListener.getStatusAndLogListener().getProject().getName()) && StatusAndLogListener.getStatusAndLogListener().getProject().getName() != null) {
            this.initSubProjectDependentTarget(project);
        }
        for (Map.Entry<String, Stage> entry : this.stagesMapping.entrySet()) {
            Stage stage = entry.getValue();
            if (stage.getStartTarget().equals(target.getName()) && this.validateStageTargets(project, stage.getStartTarget(), stage.getEndTarget())) {
                this.log.debug((Object)("Found stage [" + entry.getKey() + "] for target [" + target.getName() + "]"));
                return entry.getKey();
            }
            if (this.stageStartTargetMap.get(entry.getKey()) != null) {
                if (!this.stageStartTargetMap.get(entry.getKey()).getName().equals(target.getName())) continue;
                this.log.debug((Object)("Found stage [" + entry.getKey() + "] for dependent target [" + target.getName() + "]"));
                return entry.getKey();
            }
            if (!this.isDependentTarget(target, entry.getKey())) continue;
            this.log.debug((Object)("Found stage [" + entry.getKey() + "] for dependent target [" + target.getName() + "]"));
            return entry.getKey();
        }
        return null;
    }

    private boolean isEndTarget(String string) {
        if (this.stagesMapping.get(this.currentStageName) != null) {
            return this.stagesMapping.get(this.currentStageName).getEndTarget().equals(string);
        }
        return false;
    }

    private boolean validateStageTargets(Project project, String string, String string2) {
        Hashtable hashtable = project.getTargets();
        return hashtable.containsKey(string) && hashtable.containsKey(string2);
    }

    private boolean getIsStageRecordingHappening() {
        return this.isStageRecordingHappening;
    }

    private boolean isDependentTarget(Target target, String string) {
        if (this.depStartTargetMap.get(string) != null) {
            for (Target target2 : this.depStartTargetMap.get(string)) {
                if (!target2.getName().equals(target.getName())) continue;
                this.depStartTargetMap.remove(string);
                this.stageStartTargetMap.put(string, target2);
                return true;
            }
        }
        return false;
    }

    private void initDependentTargetMap(Project project, String string, String string2, String string3) {
        Vector vector = null;
        if (this.validateStageTargets(project, string2, string3)) {
            vector = project.topoSort(string2, project.getTargets(), false);
            this.log.debug((Object)("Target dependency for " + string2));
            for (Target target : vector) {
                this.log.debug((Object)("       Start Target : " + target.getName()));
            }
            if (vector != null && vector.size() > 1) {
                this.depStartTargetMap.put(string, vector);
            }
        }
    }

    private void initSubProjectDependentTarget(Project project) {
        for (Map.Entry<String, Stage> entry : this.stagesMapping.entrySet()) {
            if (this.depStartTargetMap.get(entry.getKey()) != null) continue;
            this.initDependentTargetMap(project, entry.getKey(), entry.getValue().getStartTarget(), entry.getValue().getEndTarget());
        }
    }

    private void validateStageInformation(String string, Stage stage) {
        if (stage.getStartTarget() == null) {
            throw new BuildException("'starttarget' for stage '" + string + "' should not be null.");
        }
        if (stage.getEndTarget() == null) {
            throw new BuildException("'endtarget' for stage '" + string + "' should not be null.");
        }
    }

    private void validateStageLogging(String string, StageLogging stageLogging) {
        if (stageLogging.getOutput() == null) {
            throw new BuildException("'output' attribute for stagelogging '" + string + "' should not be null.");
        }
        this.registerRecorderEntry(stageLogging.getOutput(), stageLogging, StatusAndLogListener.getStatusAndLogListener().getProject());
    }

    private void validateDefaultStage(Hashtable<String, Object> hashtable) {
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            StageLogging stageLogging;
            String string = enumeration.nextElement();
            if (!(hashtable.get(string) instanceof StageLogging) || (stageLogging = (StageLogging)((Object)hashtable.get(string))).getStageRefID() != null || stageLogging.getDefaultOutput() == null) continue;
            this.stageRecordMap.put("default", stageLogging);
            this.registerRecorderEntry(stageLogging.getDefaultOutput(), stageLogging, StatusAndLogListener.getStatusAndLogListener().getProject());
            return;
        }
        throw new BuildException("There should be one default stagerecord datatype.");
    }

    private void matchStageName(Hashtable<String, Object> hashtable, String string) {
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            StageLogging stageLogging;
            String string2 = enumeration.nextElement();
            if (!(hashtable.get(string2) instanceof StageLogging) || (stageLogging = (StageLogging)((Object)hashtable.get(string2))).getStageRefID() == null || !stageLogging.getStageRefID().equals(string)) continue;
            return;
        }
        throw new BuildException("there is no stagelogging datatype matching for stage '" + string + "'");
    }

    private RecorderEntry getRecorderEntry(File file) {
        return recorderEntries.get(file);
    }

    public boolean getLoggingStarted() {
        return this.loggingStarted;
    }

    public void setLoggingStarted(boolean bl) {
        this.loggingStarted = bl;
    }

    public static class VerbosityLevelChoices
    extends LogLevel {
    }
}

