/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.taskdefs;

import com.nokia.helium.jpa.entity.metadata.Metadata;
import com.nokia.helium.metadata.MetaDataInput;
import com.nokia.helium.metadata.db.ORMMetadataDB;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MetaDataRecord
extends Task {
    private static Logger log = Logger.getLogger(MetaDataRecord.class);
    private String database;
    private boolean failOnError = true;
    private Vector<MetaDataInput> metadataList = new Vector();

    public void setDatabase(String dbFile) {
        this.database = dbFile;
    }

    public void setFailOnError(String failNotify) {
        if (failNotify.equals("false")) {
            this.failOnError = false;
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public Vector<MetaDataInput> getMetaDataList() throws Exception {
        if (this.metadataList.isEmpty()) {
            throw new Exception("metadata list is empty");
        }
        return this.metadataList;
    }

    public void add(MetaDataInput interf) {
        this.metadataList.add(interf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ORMMetadataDB ormDB = null;
        try {
            log.debug((Object)("Getting Contents to write to db: " + this.database));
            log.debug((Object)("Initializing DB: " + this.database));
            log.debug((Object)"initializing ORM db");
            ormDB = new ORMMetadataDB(this.database);
            log.debug((Object)"Parsing the input and writing to DB");
            Date before = new Date();
            this.log("Time before recording to db: " + before);
            for (MetaDataInput metadataInput : this.metadataList) {
                boolean removed = false;
                String logPath = null;
                Iterator<Metadata.LogEntry> inputIterator = metadataInput.iterator();
                while (inputIterator.hasNext()) {
                    Metadata.LogEntry logEntry = inputIterator.next();
                    if (!removed) {
                        logPath = logEntry.getLogPath();
                        ormDB.removeEntries(logPath);
                        removed = true;
                    }
                    ormDB.addLogEntry(logEntry);
                }
                if (logPath == null) continue;
                ormDB.finalizeMetadata(logPath);
            }
            Date after = new Date();
            this.log("Time after recording to db: " + after);
            this.log("Elapsed time: " + (after.getTime() - before.getTime()) + " ms");
            log.debug((Object)"Successfully writen to DB");
        }
        catch (BuildException ex1) {
            log.debug((Object)"BuildException during writing to db: ", (Throwable)ex1);
            if (this.failOnError) {
                throw ex1;
            }
        }
        catch (Exception ex) {
            log.debug((Object)"exception during writing to db: ", (Throwable)ex);
            if (this.failOnError) {
                throw new BuildException("Failed during writing data to db.", (Throwable)ex);
            }
        }
        finally {
            if (ormDB != null) {
                ormDB.finalizeDB();
            }
        }
    }
}

