/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FileChooser
extends JPanel
implements ActionListener {
    private JTextField textField;
    private JButton button;
    private boolean directoryChooser = false;

    public FileChooser(int columns, boolean directoryChooser) {
        this.textField = new JTextField(columns);
        this.button = new JButton("...");
        this.button.addActionListener(this);
        this.button.setPreferredSize(new Dimension(this.button.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.button, "East");
        this.directoryChooser = directoryChooser;
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.button) {
            JFileChooser chooser = new JFileChooser();
            if (this.directoryChooser) {
                chooser.setFileSelectionMode(1);
            }
            chooser.setCurrentDirectory(new File(this.textField.getText()));
            int choseSomething = chooser.showOpenDialog(this);
            if (choseSomething == 0) {
                this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
            }
            this.textField.requestFocus();
        }
    }

    public void setBackground(Color bg) {
        if (this.textField != null) {
            this.textField.setBackground(bg);
        }
    }

    public void setBorder(Border border) {
        if (this.textField != null) {
            this.textField.setBorder(border);
        }
    }

    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public static void main(String[] args) {
        System.out.println(UIManager.getSystemLookAndFeelClassName());
        System.setProperty("swing.defaultlaf", UIManager.getSystemLookAndFeelClassName());
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)new FileChooser(50, true), "Center");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.show();
    }

    public void setText(String value) {
        this.textField.setText(value);
    }

    public String getText() {
        return this.textField.getText();
    }
}

