/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.checktools;

import com.nokia.helium.checktools.CheckEngine;
import com.nokia.helium.checktools.CheckToolException;
import java.io.FileInputStream;
import java.util.Properties;

public final class HeliumToolsCheckerMain {
    private Properties configuration;
    private CheckEngine checkEngine;

    private HeliumToolsCheckerMain(String configFile) {
        this.loadConfiguration(configFile);
        this.checkEngine = new CheckEngine(this.configuration);
    }

    private void checkJava() {
        try {
            this.checkEngine.verifyJavaVersion();
        }
        catch (CheckToolException e) {
            System.out.println("***Error: " + e.getMessage());
        }
    }

    private void checkAnt() {
        try {
            this.checkEngine.verifyAntVersion();
        }
        catch (CheckToolException e) {
            System.out.println("***Error: " + e.getMessage());
        }
    }

    private void checkPython() {
        try {
            this.checkEngine.verifyPythonVersion();
        }
        catch (CheckToolException e) {
            System.out.println("***Error: " + e.getMessage());
        }
    }

    private boolean checkFailed() {
        return this.checkEngine.getErrorCount() > 0;
    }

    private void loadConfiguration(String configFile) {
        try {
            this.configuration = new Properties();
            this.configuration.load(new FileInputStream(configFile));
        }
        catch (Throwable th) {
            System.out.println("Error occured while loading config file: " + configFile);
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        String configFile = null;
        if (args.length == 2 && args[0].equalsIgnoreCase("-config")) {
            if (args[1] == null || args[1] != null && args[1].trim().isEmpty()) {
                System.out.println("***Error: Parameter '-config' not set");
                System.exit(-1);
            }
            configFile = args[1];
        }
        if (configFile != null) {
            HeliumToolsCheckerMain checkerMain = new HeliumToolsCheckerMain(configFile);
            checkerMain.checkJava();
            checkerMain.checkAnt();
            checkerMain.checkPython();
            if (checkerMain.checkFailed()) {
                System.exit(-1);
            }
        } else {
            System.out.println("***Error: Missing '-config' argument");
            System.out.println("Usage: java [main-class-name] -config [location of configuration file]");
            System.out.println("Example: java com.nokia.helium.checktools.HeliumToolsCheckerMain -config \"config/helium.basic.tools.config\"");
            System.exit(-1);
        }
    }
}

