/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.checktools;

import com.nokia.helium.checktools.OSResolver;
import com.nokia.helium.checktools.ToolChecker;
import java.util.Properties;

public class CheckEngine
extends ToolChecker {
    private Properties configuration;

    public CheckEngine(Properties configuration) {
        this.configuration = configuration;
    }

    public void verifyJavaVersion() {
        System.out.println("Checking for Java...");
        String expVersion = this.configuration.getProperty("java.version");
        String errorMsg = "Supported Java version is not defined in 'helium.basic.tools.config'.";
        this.verifyIsExpectedToolVersionConfigured(expVersion, errorMsg);
        errorMsg = "Java " + expVersion + " not found. Kindly install and run again.";
        this.verifyToolVersion(OSResolver.getCommand("java -version"), expVersion, "java version \"", errorMsg);
    }

    public void verifyAntVersion() {
        System.out.println("Checking for Ant...");
        String expVersion = this.configuration.getProperty("ant.version");
        String errorMsg = "Supported Ant version is not defined in 'helium.basic.tools.config'.";
        this.verifyIsExpectedToolVersionConfigured(expVersion, errorMsg);
        errorMsg = "Ant " + expVersion + " not found. Kindly install and run again.";
        this.verifyToolVersion(OSResolver.getCommand("ant -version"), expVersion, "Apache Ant version ", errorMsg);
    }

    public void verifyPythonVersion() {
        System.out.println("Checking for Python...");
        String expVersion = this.configuration.getProperty("python.version");
        String errorMsg = "Supported Python version is not defined in 'helium.basic.tools.config'.";
        this.verifyIsExpectedToolVersionConfigured(expVersion, errorMsg);
        errorMsg = "Python " + expVersion + " not found. Kindly install and run again.";
        this.verifyToolVersion(OSResolver.getCommand("python -V"), expVersion, "Python ", errorMsg);
    }
}

