/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.ForeignKeyRIChecker;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.ReferencedKeyRIChecker;

public class RISetChecker {
    private GenericRIChecker[] checkers;

    public RISetChecker(TransactionController transactionController, FKInfo[] fKInfoArray) throws StandardException {
        if (fKInfoArray == null) {
            return;
        }
        this.checkers = new GenericRIChecker[fKInfoArray.length];
        for (int i = 0; i < fKInfoArray.length; ++i) {
            this.checkers[i] = fKInfoArray[i].type == 1 ? new ForeignKeyRIChecker(transactionController, fKInfoArray[i]) : new ReferencedKeyRIChecker(transactionController, fKInfoArray[i]);
        }
    }

    void reopen() throws StandardException {
    }

    public void doPKCheck(ExecRow execRow, boolean bl) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            if (!(this.checkers[i] instanceof ReferencedKeyRIChecker)) continue;
            this.checkers[i].doCheck(execRow, bl);
        }
    }

    public void doFKCheck(ExecRow execRow) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            if (!(this.checkers[i] instanceof ForeignKeyRIChecker)) continue;
            this.checkers[i].doCheck(execRow);
        }
    }

    public void doRICheck(int n, ExecRow execRow, boolean bl) throws StandardException {
        this.checkers[n].doCheck(execRow, bl);
    }

    public void close() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            this.checkers[i].close();
        }
    }
}

