/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.scm.ant.taskdefs;

import com.nokia.helium.scm.ant.taskdefs.BaseDirectoryScmAction;
import com.nokia.helium.scm.ant.types.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.tools.ant.BuildException;

public class ExportAction
extends BaseDirectoryScmAction {
    private File destPath;
    private List<Tag> tags = new ArrayList<Tag>();

    public Tag createTag() {
        Tag tag = new Tag();
        this.add(tag);
        return tag;
    }

    public void add(Tag tag) {
        this.tags.add(tag);
    }

    @Override
    public void execute(ScmRepository repository) throws ScmException {
        ExportScmResult result;
        ScmManager scmManager = this.getTask().getScmManager();
        if (this.getDestPath() == null) {
            throw new ScmException("destPath attribute has not been provided.");
        }
        if (this.tags.size() > 1) {
            throw new ScmException("You can only specify one tag nested element.");
        }
        try {
            if (this.tags.size() == 0) {
                this.getTask().log("Exporting " + this.getScmFileSet().getBasedir() + " under " + this.getDestPath().getAbsolutePath() + ".");
                result = scmManager.export(repository, this.getScmFileSet(), this.getDestPath().getAbsolutePath());
            } else {
                String t = this.tags.get(0).getName();
                this.getTask().log("Exporting revision " + t + " of " + this.getScmFileSet().getBasedir() + " under " + this.getDestPath().getAbsolutePath() + ".");
                result = scmManager.export(repository, this.getScmFileSet(), (ScmVersion)new ScmTag(t), this.getDestPath().getAbsolutePath());
            }
        }
        catch (ScmException e) {
            throw new BuildException("SCM export action failed: " + (Object)((Object)e));
        }
        if (!result.isSuccess()) {
            throw new BuildException("SCM export action failed: " + result.getProviderMessage());
        }
        for (Object file : result.getExportedFiles().toArray()) {
            this.getTask().log(file.toString());
        }
    }

    public File getDestPath() {
        return this.destPath;
    }

    public void setDestPath(File destPath) {
        this.destPath = destPath;
    }
}

