/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.framework.jar;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JarFile {
    private HashMap jarContents;
    private Enumeration jarEntries;
    private ZipFile zipFile;
    private String nextClass;
    private File file;

    public JarFile(File file) throws ZipException, IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
        this.jarEntries = this.zipFile.entries();
    }

    public boolean hasMoreClasses() {
        boolean bl = false;
        ZipEntry zipEntry = null;
        while (this.jarEntries.hasMoreElements() && !bl) {
            zipEntry = (ZipEntry)this.jarEntries.nextElement();
            if (!zipEntry.getName().endsWith(".class")) continue;
            bl = true;
        }
        if (bl) {
            this.nextClass = zipEntry.getName();
            return true;
        }
        this.nextClass = null;
        return false;
    }

    public String nextClass() {
        return this.nextClass;
    }

    public String getFileName() {
        return this.file.getAbsolutePath();
    }

    public String getShortFileName() {
        return this.file.getName();
    }

    public void close() {
        if (null != this.zipFile) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

