/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.pdf;

import com.lowagie.text.DocumentException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PDFGenerator {
    public static final String HEADER_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \n   \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n        <title>{0}</title>\n{1}\n    </head>\n    <body>";
    public static final String FOOTER = "    </body>\n</html>";
    public final String fURLExternalForm;

    public PDFGenerator(URL url) {
        this.fURLExternalForm = url.toExternalForm();
    }

    public void create(String outputFileName, String xhtmlText, String headerTemplate, String footer, String titleText, String cssStyleText) throws IOException, DocumentException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Object[] objects = new Object[]{titleText, cssStyleText};
        String header = MessageFormat.format(headerTemplate, objects);
        StringBuffer buffer = new StringBuffer();
        buffer.append(header);
        buffer.append(xhtmlText);
        buffer.append(footer);
        StringReader contentReader = new StringReader(buffer.toString());
        InputSource source = new InputSource(contentReader);
        source.setEncoding("utf-8");
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document xhtmlContent = domBuilder.parse(source);
        contentReader.close();
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocument(xhtmlContent, this.fURLExternalForm);
        renderer.layout();
        FileOutputStream os = new FileOutputStream(outputFileName);
        renderer.createPDF((OutputStream)os);
        ((OutputStream)os).close();
    }
}

