/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.gui;

import com.sardak.antform.gui.CheckGroupBox;
import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.gui.DateChooser;
import com.sardak.antform.gui.FileChooser;
import com.sardak.antform.gui.RadioGroupBox;
import com.sardak.antform.style.HexConverter;
import com.sardak.antform.util.StyleUtil;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class StylesheetHandler {
    private List textProperties = new ArrayList();
    private List selectionProperties = new ArrayList();
    private List numberProperties = new ArrayList();
    private List links = new ArrayList();
    private List multiLineTextProperties = new ArrayList();
    private List buttons = new ArrayList();
    private List dateProperties = new ArrayList();
    private List labels = new ArrayList();
    private List checkBoxes = new ArrayList();
    private List messages = new ArrayList();
    private List scrollPanes = new ArrayList();
    private List fileChoosers = new ArrayList();
    private List radioButtons = new ArrayList();
    private List panels = new ArrayList();

    public void addLabel(JLabel label) {
        this.labels.add(label);
    }

    public void addCheckBox(JCheckBox checkBox) {
        this.checkBoxes.add(checkBox);
    }

    public void addCheckGroupBox(CheckGroupBox checkGroupBox) {
        this.checkBoxes.add(checkGroupBox);
    }

    public void addRadioGroupBox(RadioGroupBox radioBox) {
        this.radioButtons.add(radioBox);
    }

    public void addDateChooser(DateChooser chooser) {
        this.dateProperties.add(chooser);
    }

    public void addFileChooser(FileChooser chooser) {
        this.fileChoosers.add(chooser);
    }

    public void addSpinner(JComponent spinner) {
        this.numberProperties.add(spinner);
    }

    public void addTextField(JTextField textField) {
        this.textProperties.add(textField);
    }

    public void addMultiLineTextArea(JTextArea textArea) {
        this.multiLineTextProperties.add(textArea);
    }

    public void addScrollPane(JScrollPane scrollPane) {
        this.scrollPanes.add(scrollPane);
    }

    public void addComboBox(JComboBox comboBox) {
        this.selectionProperties.add(comboBox);
    }

    public void addButton(JButton button) {
        this.buttons.add(button);
    }

    public void addLink(JButton link) {
        this.links.add(link);
    }

    public void addMessage(JTextArea textArea) {
        this.messages.add(textArea);
    }

    public void addPanel(JPanel panel) {
        this.panels.add(panel);
    }

    public void apply(String stylesheetFileName, ControlPanel controlPanel) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(new File(stylesheetFileName)));
        Color background = HexConverter.translate(props.getProperty("background.color"), controlPanel.getCurrentPanel().getBackground());
        if (controlPanel.getSouthPanel() != null) {
            controlPanel.getSouthPanel().setBackground(background);
        }
        Iterator iter = this.panels.iterator();
        while (iter.hasNext()) {
            JPanel aPanel = (JPanel)iter.next();
            aPanel.setBackground(background);
        }
        controlPanel.getCurrentPanel().setBackground(background);
        controlPanel.setBackground(background);
        HashSet<JPanel> buttonBars = new HashSet<JPanel>();
        buttonBars.add(controlPanel.getButtonPanel());
        StyleUtil.styleComponents("buttonBar", props, buttonBars);
        ArrayList<JPanel> banners = new ArrayList<JPanel>();
        banners.add(controlPanel.getOverPanel());
        StyleUtil.styleComponents("banner", props, banners);
        StyleUtil.styleComponents("label", props, this.labels);
        StyleUtil.styleComponents("textProperty", props, this.dateProperties);
        StyleUtil.styleComponents("textProperty", props, this.textProperties);
        StyleUtil.styleComponents("textProperty", props, this.numberProperties);
        StyleUtil.styleComponents("textProperty", props, this.fileChoosers);
        StyleUtil.styleComponents("multiLineTextProperty", props, this.multiLineTextProperties);
        StyleUtil.styleComponents("link", props, this.links);
        StyleUtil.styleComponents("scrollPanes", props, this.scrollPanes);
        StyleUtil.styleComponents("selectionProperty", props, this.selectionProperties);
        StyleUtil.styleComponents("button", props, this.buttons);
        StyleUtil.styleComponents("checkbox", props, this.checkBoxes);
        StyleUtil.styleComponents("message", props, this.messages);
        StyleUtil.styleComponents("radio", props, this.radioButtons);
    }
}

