/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;

class RowCountResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    final NoPutResultSet source;
    private final boolean runTimeStatsOn;
    private final long offset;
    private final long fetchFirst;
    private boolean virginal;
    private long rowsFetched;

    RowCountResultSet(NoPutResultSet noPutResultSet, Activation activation, int n, long l, long l2, double d, double d2) throws StandardException {
        super(activation, n, d, d2);
        this.source = noPutResultSet;
        this.offset = l;
        this.fetchFirst = l2;
        this.virginal = true;
        this.rowsFetched = 0L;
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.virginal && this.offset > 0L) {
            this.virginal = false;
            long l = this.offset;
            while ((execRow = this.source.getNextRowCore()) != null && --l >= 0L) {
                ++this.rowsFiltered;
            }
        } else {
            execRow = this.fetchFirst != -1L && this.rowsFetched >= this.fetchFirst ? null : this.source.getNextRowCore();
        }
        if (execRow != null) {
            ++this.rowsFetched;
            ++this.rowsSeen;
        }
        this.setCurrentRow(execRow);
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext statementContext = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = statementContext.getSubqueryTrackingArray();
            }
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return execRow;
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        }
        this.virginal = true;
        this.rowsFetched = 0L;
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public final void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
        this.source.clearCurrentRow();
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getCurrentRow();
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    public ProjectRestrictResultSet getUnderlyingProjectRestrictRS() {
        if (this.source instanceof ProjectRestrictResultSet) {
            return (ProjectRestrictResultSet)this.source;
        }
        return null;
    }
}

