/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.jython;

import java.io.ByteArrayInputStream;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;

public class JythonEngine
extends BSFEngineImpl {
    BSFPythonInterpreter interp;
    static /* synthetic */ Class class$java$lang$Object;

    public Object call(Object object, String method, Object[] args) throws BSFException {
        try {
            PyObject[] pyargs = Py.EmptyObjects;
            if (args != null) {
                pyargs = new PyObject[args.length];
                for (int i = 0; i < pyargs.length; ++i) {
                    pyargs[i] = Py.java2py((Object)args[i]);
                }
            }
            if (object != null) {
                PyObject o = Py.java2py((Object)object);
                return this.unwrap(o.invoke(method, pyargs));
            }
            PyObject m = this.interp.get(method);
            if (m == null) {
                m = this.interp.eval(method);
            }
            if (m != null) {
                return this.unwrap(m.__call__(pyargs));
            }
            return null;
        }
        catch (PyException e) {
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)e), e);
        }
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.interp.set(bean.name, bean.bean);
    }

    public Object apply(String source, int lineNo, int columnNo, Object funcBody, Vector paramNames, Vector arguments) throws BSFException {
        try {
            StringBuffer script = new StringBuffer(this.byteify(funcBody.toString()));
            script.insert(0, "def bsf_temp_fn():\n");
            for (int index = 0; index < script.length(); ++index) {
                if (script.charAt(index) != '\n') continue;
                script.insert(index + 1, '\t');
            }
            this.interp.exec(script.toString());
            Object result = this.interp.eval("bsf_temp_fn()");
            if (result != null && result instanceof PyJavaInstance) {
                result = ((PyJavaInstance)result).__tojava__(class$java$lang$Object == null ? (class$java$lang$Object = JythonEngine.class$("java.lang.Object")) : class$java$lang$Object);
            }
            return result;
        }
        catch (PyException e) {
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)e), e);
        }
    }

    public Object eval(String source, int lineNo, int columnNo, Object script) throws BSFException {
        try {
            Object result = this.interp.eval(this.byteify(script.toString()));
            if (result != null && result instanceof PyJavaInstance) {
                result = ((PyJavaInstance)result).__tojava__(class$java$lang$Object == null ? (class$java$lang$Object = JythonEngine.class$("java.lang.Object")) : class$java$lang$Object);
            }
            return result;
        }
        catch (PyException e) {
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)e), e);
        }
    }

    public void exec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        try {
            this.interp.exec(this.byteify(script.toString()));
        }
        catch (PyException e) {
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)e), e);
        }
    }

    public void iexec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        String scriptStr = this.byteify(script.toString());
        int newline = scriptStr.indexOf("\n");
        if (newline > -1) {
            scriptStr = scriptStr.substring(0, newline);
        }
        try {
            if (this.interp.buffer.length() > 0) {
                this.interp.buffer.append("\n");
            }
            this.interp.buffer.append(scriptStr);
            if (!this.interp.runsource(this.interp.buffer.toString())) {
                this.interp.resetbuffer();
            }
        }
        catch (PyException e) {
            this.interp.resetbuffer();
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)e), e);
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.interp = new BSFPythonInterpreter();
        this.interp.setOut(System.out);
        this.interp.setErr(System.err);
        this.interp.set("bsf", new BSFFunctions(mgr, this));
        int size = declaredBeans.size();
        for (int i = 0; i < size; ++i) {
            this.declareBean((BSFDeclaredBean)declaredBeans.elementAt(i));
        }
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.interp.set(bean.name, null);
    }

    public Object unwrap(PyObject result) {
        Object ret;
        if (result != null && (ret = result.__tojava__(class$java$lang$Object == null ? (class$java$lang$Object = JythonEngine.class$("java.lang.Object")) : class$java$lang$Object)) != Py.NoConversion) {
            return ret;
        }
        return result;
    }

    private String byteify(String orig) {
        int c;
        ByteArrayInputStream bais = new ByteArrayInputStream(orig.getBytes());
        StringBuffer s = new StringBuffer();
        while ((c = bais.read()) >= 0) {
            s.append((char)c);
        }
        return s.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BSFPythonInterpreter
    extends InteractiveInterpreter {
        public void runcode(PyObject code) {
            this.exec(code);
        }
    }
}

