/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ConstraintInfo;

public final class FKConstraintDefinitionNode
extends ConstraintDefinitionNode {
    TableName refTableName;
    ResultColumnList refRcl;
    SchemaDescriptor refTableSd;
    int refActionDeleteRule;
    int refActionUpdateRule;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) {
        super.init(object, ReuseFactory.getInteger(6), object3, null, null, null);
        this.refRcl = (ResultColumnList)object4;
        this.refTableName = (TableName)object2;
        this.refActionDeleteRule = ((int[])object5)[0];
        this.refActionUpdateRule = ((int[])object5)[1];
    }

    protected void bind(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary) throws StandardException {
        super.bind(dDLStatementNode, dataDictionary);
        this.refTableSd = this.getSchemaDescriptor(this.refTableName.getSchemaName());
        if (this.refTableSd.isSystemSchema()) {
            throw StandardException.newException("42Y08");
        }
        if (this.refTableName.equals(dDLStatementNode.getObjectName())) {
            return;
        }
        TableDescriptor tableDescriptor = this.getTableDescriptor(this.refTableName.getTableName(), this.refTableSd);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0Y46.S", (Object)this.getConstraintMoniker(), (Object)this.refTableName.getTableName());
        }
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        this.getCompilerContext().createDependency(tableDescriptor);
        if (this.refRcl.size() == 0 && tableDescriptor.getPrimaryKey() != null) {
            int[] nArray = tableDescriptor.getPrimaryKey().getReferencedColumns();
            for (int i = 0; i < nArray.length; ++i) {
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[i]);
                columnDescriptor.setTableDescriptor(tableDescriptor);
                if (!this.isPrivilegeCollectionRequired()) continue;
                this.getCompilerContext().addRequiredColumnPriv(columnDescriptor);
            }
        } else {
            for (int i = 0; i < this.refRcl.size(); ++i) {
                ResultColumn resultColumn = (ResultColumn)this.refRcl.elementAt(i);
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(resultColumn.getName());
                if (columnDescriptor == null) continue;
                columnDescriptor.setTableDescriptor(tableDescriptor);
                if (!this.isPrivilegeCollectionRequired()) continue;
                this.getCompilerContext().addRequiredColumnPriv(columnDescriptor);
            }
        }
        this.getCompilerContext().popCurrentPrivType();
    }

    public ConstraintInfo getReferencedConstraintInfo() {
        return new ConstraintInfo(this.refTableName.getTableName(), this.refTableSd, this.refRcl.getColumnNames(), this.refActionDeleteRule, this.refActionUpdateRule);
    }

    public TableName getRefTableName() {
        return this.refTableName;
    }

    int getPrivType() {
        return 2;
    }
}

