/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.LogMetaDataInput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

abstract class XMLLogMetaDataInput
extends LogMetaDataInput {
    private Logger log = Logger.getLogger(XMLLogMetaDataInput.class);
    private XMLInputFactory xmlInputFactory;
    private XMLStreamReader xmlStreamReader;
    private int currentFileIndex;

    public XMLLogMetaDataInput() {
        try {
            this.xmlInputFactory = XMLInputFactory.newInstance();
            this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void close() {
        try {
            if (this.xmlStreamReader != null) {
                this.xmlStreamReader.close();
                this.xmlStreamReader = null;
            }
        }
        catch (Exception ex) {
            this.log.info((Object)("Exception whil closing xml stream" + ex.getMessage()));
            this.log.debug((Object)"exception while closing xml stream", (Throwable)ex);
        }
    }

    protected File getCurrentFile() {
        List<File> fileList = this.getFileList();
        return fileList.get(this.currentFileIndex);
    }

    @Override
    boolean isEntryAvailable() throws Exception {
        int fileListSize = this.getFileList().size();
        try {
            while (this.currentFileIndex < fileListSize) {
                boolean entryCreated = false;
                File currentFile = this.getCurrentFile();
                if (this.xmlStreamReader == null) {
                    this.log.info((Object)("Processing file: " + currentFile));
                    this.xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(currentFile.toString(), new BufferedInputStream(new FileInputStream(currentFile)));
                }
                int eventType = this.xmlStreamReader.getEventType();
                while (this.xmlStreamReader.hasNext()) {
                    eventType = this.xmlStreamReader.next();
                    switch (eventType) {
                        case 1: {
                            entryCreated = this.startElement(this.xmlStreamReader);
                            break;
                        }
                        case 2: {
                            entryCreated = this.endElement(this.xmlStreamReader);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            entryCreated = this.characters(this.xmlStreamReader);
                            break;
                        }
                        case 5: {
                            this.log.debug((Object)"XMLEvent:COMMENT");
                            break;
                        }
                        case 7: {
                            this.log.debug((Object)"XMLEvent:START_DOCUMENT");
                            break;
                        }
                        case 8: {
                            this.log.debug((Object)"XMLEvent:END_DOCUMENT");
                            break;
                        }
                        case 9: {
                            this.log.debug((Object)"XMLEvent:ENTITY_REFERENCE");
                            break;
                        }
                        case 10: {
                            this.log.debug((Object)"XMLEvent:ATTRIBUTE");
                            break;
                        }
                        case 11: {
                            this.log.debug((Object)"XMLEvent:DTD");
                            break;
                        }
                        case 12: {
                            this.log.debug((Object)"XMLEvent:CDATA");
                            break;
                        }
                        case 6: {
                            this.log.debug((Object)"XMLEvent:chacacters");
                            break;
                        }
                    }
                    if (!entryCreated) continue;
                    return true;
                }
                if (this.xmlStreamReader != null) {
                    this.close();
                }
                ++this.currentFileIndex;
            }
        }
        catch (Exception ex1) {
            this.log.info((Object)("Exception processing xml stream: " + ex1.getMessage()));
            this.log.debug((Object)"exception while parsing the stream", (Throwable)ex1);
            this.close();
        }
        return false;
    }

    abstract boolean startElement(XMLStreamReader var1) throws Exception;

    abstract boolean endElement(XMLStreamReader var1) throws Exception;

    abstract boolean characters(XMLStreamReader var1);
}

