/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ordering<T>
implements Comparator<T> {
    private static final NaturalOrdering NATURAL_ORDER = new NaturalOrdering();

    public static <C extends Comparable> Ordering<C> natural() {
        return NATURAL_ORDER;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    public static <T> Ordering<T> givenOrder(List<? extends T> valuesInOrder) {
        return new GivenOrder<T>(valuesInOrder);
    }

    public static <T> Ordering<T> givenOrder(@Nullable T leastValue, T ... remainingValuesInOrder) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(leastValue);
        Collections.addAll(list, remainingValuesInOrder);
        return Ordering.givenOrder(list);
    }

    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    public Ordering<T> reverse() {
        return new ReverseOrdering(this);
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    public Ordering<T> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    public Ordering<T> nullsLast() {
        return new NullsLastOrdering(this);
    }

    public int binarySearch(List<? extends T> sortedList, T key) {
        return Collections.binarySearch(sortedList, key, this);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        List<E> list = Ordering.newArrayList(iterable);
        Collections.sort(list, this);
        return list;
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (this.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (this.compare(prev, next) >= 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    private static <E> List<E> newArrayList(Iterable<E> iterable) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return new ArrayList(collection);
        }
        Iterator<E> iterator = iterable.iterator();
        ArrayList<E> list = new ArrayList<E>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public <E extends T> E max(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        E maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return maxSoFar;
    }

    public <E extends T> E max(E a, E b, E c, E ... rest) {
        E maxSoFar = this.max(this.max(a, b), c);
        for (E r : rest) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public <E extends T> E max(E a, E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    public <E extends T> E min(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        E minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return minSoFar;
    }

    public <E extends T> E min(E a, E b, E c, E ... rest) {
        E minSoFar = this.min(this.min(a, b), c);
        for (E r : rest) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    public <E extends T> E min(E a, E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsLastOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final Ordering<T> ordering;
        private static final long serialVersionUID = 0L;

        NullsLastOrdering(Ordering<T> ordering) {
            this.ordering = ordering;
        }

        @Override
        public int compare(T left, T right) {
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return 1;
            }
            if (right == null) {
                return -1;
            }
            return this.ordering.compare(left, right);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof NullsLastOrdering) {
                NullsLastOrdering that = (NullsLastOrdering)object;
                return this.ordering.equals(that.ordering);
            }
            return false;
        }

        public int hashCode() {
            return this.ordering.hashCode();
        }

        public String toString() {
            return this.ordering + ".nullsLast()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsFirstOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final Ordering<T> ordering;
        private static final long serialVersionUID = 0L;

        NullsFirstOrdering(Ordering<T> ordering) {
            this.ordering = ordering;
        }

        @Override
        public int compare(T left, T right) {
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            return this.ordering.compare(left, right);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof NullsFirstOrdering) {
                NullsFirstOrdering that = (NullsFirstOrdering)object;
                return this.ordering.equals(that.ordering);
            }
            return false;
        }

        public int hashCode() {
            return this.ordering.hashCode();
        }

        public String toString() {
            return this.ordering + ".nullsFirst()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByFunctionOrdering<F, T>
    extends Ordering<F>
    implements Serializable {
        final Function<F, ? extends T> function;
        final Ordering<T> ordering;
        private static final long serialVersionUID = 0L;

        ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
            this.function = Preconditions.checkNotNull(function);
            this.ordering = Preconditions.checkNotNull(ordering);
        }

        @Override
        public int compare(F left, F right) {
            return this.ordering.compare(this.function.apply(left), this.function.apply(right));
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ByFunctionOrdering) {
                ByFunctionOrdering that = (ByFunctionOrdering)object;
                return ((Object)this.function).equals(that.function) && this.ordering.equals(that.ordering);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.function, this.ordering);
        }

        public String toString() {
            return this.ordering + ".onResultOf(" + this.function + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final Ordering<T> forwardOrder;
        private static final long serialVersionUID = 0L;

        ReverseOrdering(Ordering<T> forwardOrder) {
            this.forwardOrder = Preconditions.checkNotNull(forwardOrder);
        }

        @Override
        public Ordering<T> reverse() {
            return this.forwardOrder;
        }

        @Override
        public int compare(T a, T b) {
            return this.forwardOrder.compare(b, a);
        }

        public int hashCode() {
            return -this.forwardOrder.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ReverseOrdering) {
                ReverseOrdering that = (ReverseOrdering)object;
                return this.forwardOrder.equals(that.forwardOrder);
            }
            return false;
        }

        public String toString() {
            return this.forwardOrder + ".reverse()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final List<Comparator<? super T>> comparators = new ArrayList<Comparator<? super T>>();
        private static final long serialVersionUID = 0L;

        CompoundOrdering(Comparator<? super T> primary, Comparator<? super T> secondary) {
            this.comparators.add(primary);
            this.comparators.add(secondary);
        }

        CompoundOrdering(Iterable<? extends Comparator<? super T>> comparators) {
            for (Comparator<T> comparator : comparators) {
                this.comparators.add(Preconditions.checkNotNull(comparator));
            }
        }

        CompoundOrdering(List<? extends Comparator<? super T>> comparators, Comparator<? super T> lastComparator) {
            this.comparators.addAll(comparators);
            this.comparators.add(lastComparator);
        }

        @Override
        public int compare(T left, T right) {
            for (Comparator<T> comparator : this.comparators) {
                int result = comparator.compare(left, right);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        @Override
        public <U extends T> Ordering<U> compound(Comparator<? super U> secondary) {
            return new CompoundOrdering<U>(this.comparators, Preconditions.checkNotNull(secondary));
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CompoundOrdering) {
                CompoundOrdering that = (CompoundOrdering)object;
                return ((Object)this.comparators).equals(that.comparators);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.comparators).hashCode();
        }

        public String toString() {
            return "Ordering.compound(" + this.comparators + ")";
        }
    }

    static class DuplicateValueException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;
        final Object value;
        final int firstIndex;
        final int secondIndex;

        DuplicateValueException(Object value, int firstIndex, int secondIndex) {
            super("Duplicate value at indices " + firstIndex + " and " + secondIndex + ": " + value + "");
            this.value = value;
            this.firstIndex = firstIndex;
            this.secondIndex = secondIndex;
        }
    }

    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object value) {
            super("Cannot compare value: " + value);
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GivenOrder<T>
    extends Ordering<T>
    implements Serializable {
        final Map<T, Integer> rankMap;
        private static final long serialVersionUID = 0L;

        GivenOrder(List<? extends T> valuesInOrder) {
            this.rankMap = GivenOrder.buildRankMap(valuesInOrder);
        }

        @Override
        public int compare(T left, T right) {
            return this.rank(left) - this.rank(right);
        }

        int rank(T value) {
            Integer rank = this.rankMap.get(value);
            if (rank == null) {
                throw new IncomparableValueException(value);
            }
            return rank;
        }

        static <T> Map<T, Integer> buildRankMap(Collection<? extends T> valuesInOrder) {
            LinkedHashMap<T, Integer> ranks = new LinkedHashMap<T, Integer>(valuesInOrder.size() * 2);
            Object previousValue = null;
            int rank = 0;
            for (T value : valuesInOrder) {
                Integer priorRank;
                if (!(rank != 0 && Objects.equal(value, previousValue) || (priorRank = ranks.put(value, rank)) == null)) {
                    throw new DuplicateValueException(value, priorRank, rank);
                }
                ++rank;
                previousValue = value;
            }
            return ranks;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof GivenOrder) {
                GivenOrder that = (GivenOrder)object;
                return ((Object)this.rankMap).equals(that.rankMap);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.rankMap).hashCode();
        }

        public String toString() {
            return "Ordering.givenOrder(" + this.rankMap.keySet() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComparatorOrdering<T>
    extends Ordering<T>
    implements Serializable {
        final Comparator<T> comparator;
        private static final long serialVersionUID = 0L;

        ComparatorOrdering(Comparator<T> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public int compare(T a, T b) {
            return this.comparator.compare(a, b);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ComparatorOrdering) {
                ComparatorOrdering that = (ComparatorOrdering)object;
                return ((Object)this.comparator).equals(that.comparator);
            }
            return false;
        }

        public int hashCode() {
            return this.comparator.hashCode();
        }

        public String toString() {
            return this.comparator.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NaturalOrdering
    extends Ordering<Comparable>
    implements Serializable {
        private static final long serialVersionUID = 0L;

        private NaturalOrdering() {
        }

        @Override
        public int compare(Comparable left, Comparable right) {
            Preconditions.checkNotNull(right);
            if (left == right) {
                return 0;
            }
            int result = left.compareTo(right);
            return result;
        }

        private Object readResolve() {
            return NATURAL_ORDER;
        }

        public String toString() {
            return "Ordering.natural()";
        }
    }
}

