/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyResolve;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;
import org.apache.tools.ant.BuildException;

public abstract class IvyPostResolveTask
extends IvyTask {
    private String conf;
    private boolean haltOnFailure = true;
    private boolean transitive = true;
    private boolean inline = false;
    private String organisation;
    private String module;
    private String revision = "latest.integration";
    private String resolveId;
    private String type;
    private File file;
    private Filter artifactFilter = null;
    private boolean useOrigin = false;
    private Boolean keep = null;
    private String log = "default";

    public boolean isUseOrigin() {
        return this.useOrigin;
    }

    public void setUseOrigin(boolean useOrigin) {
        this.useOrigin = useOrigin;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    protected void prepareAndCheck() {
        String fileName;
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        boolean orgAndModSetManually = this.organisation != null && this.module != null;
        this.organisation = this.getProperty(this.organisation, settings, "ivy.organisation");
        this.module = this.getProperty(this.module, settings, "ivy.module");
        if (this.file == null && (fileName = this.getProperty(settings, "ivy.resolved.file", this.resolveId)) != null) {
            this.file = new File(fileName);
        }
        if (this.isInline()) {
            String string = this.conf = this.conf == null ? "*" : this.conf;
            if (this.organisation == null) {
                throw new BuildException("no organisation provided for ivy cache task in inline mode: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property");
            }
            if (this.module == null) {
                throw new BuildException("no module name provided for ivy cache task in inline mode: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property");
            }
            Object[] toResolve = this.getConfsToResolve(this.getOrganisation(), this.getModule() + "-caller", this.conf, true);
            for (int i = 0; i < toResolve.length; ++i) {
                if (!"*".equals(toResolve[i])) continue;
                toResolve[i] = "*(public)";
            }
            if (toResolve.length > 0) {
                Message.verbose("using inline mode to resolve " + this.getOrganisation() + " " + this.getModule() + " " + this.getRevision() + " (" + StringUtils.join(toResolve, ", ") + ")");
                IvyResolve resolve = this.createResolve(this.isHaltonfailure(), this.isUseOrigin());
                resolve.setOrganisation(this.getOrganisation());
                resolve.setModule(this.getModule());
                resolve.setRevision(this.getRevision());
                resolve.setInline(true);
                resolve.setConf(this.conf);
                resolve.setResolveId(this.resolveId);
                resolve.execute();
            } else {
                Message.verbose("inline resolve already done for " + this.getOrganisation() + " " + this.getModule() + " " + this.getRevision() + " (" + this.conf + ")");
            }
            if ("*".equals(this.conf)) {
                this.conf = StringUtils.join(this.getResolvedConfigurations(this.getOrganisation(), this.getModule() + "-caller", true), ", ");
            }
        } else {
            Message.debug("using standard ensure resolved");
            if (!orgAndModSetManually) {
                this.ensureResolved(settings);
            }
            this.conf = this.getProperty(this.conf, settings, "ivy.resolved.configurations");
            if ("*".equals(this.conf)) {
                this.conf = this.getProperty(settings, "ivy.resolved.configurations");
                if (this.conf == null) {
                    throw new BuildException("bad conf provided for ivy cache task: '*' can only be used with a prior call to <resolve/>");
                }
            }
        }
        this.organisation = this.getProperty(this.organisation, settings, "ivy.organisation");
        this.module = this.getProperty(this.module, settings, "ivy.module");
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy cache task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this.module == null) {
            throw new BuildException("no module name provided for ivy cache task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this.conf == null) {
            throw new BuildException("no conf provided for ivy cache task: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        this.artifactFilter = FilterHelper.getArtifactTypeFilter(this.type);
    }

    protected void ensureResolved(IvySettings settings) {
        String requestedConfigs = this.getProperty(this.getConf(), settings, "ivy.resolved.configurations");
        Object[] confs = null;
        confs = this.getResolveId() != null ? this.getConfsToResolve(this.getResolveId(), requestedConfigs) : this.getConfsToResolve(this.getOrganisation(), this.getModule(), requestedConfigs, false);
        if (confs.length > 0) {
            IvyResolve resolve = this.createResolve(this.isHaltonfailure(), this.isUseOrigin());
            resolve.setFile(this.getFile());
            resolve.setTransitive(this.isTransitive());
            resolve.setConf(StringUtils.join(confs, ", "));
            resolve.setResolveId(this.getResolveId());
            resolve.execute();
        }
    }

    protected String[] getConfsToResolve(String org, String module, String conf, boolean strict) {
        ModuleDescriptor reference = (ModuleDescriptor)this.getResolvedDescriptor(org, module, strict);
        String[] rconfs = this.getResolvedConfigurations(org, module, strict);
        return this.getConfsToResolve(reference, conf, rconfs);
    }

    protected String[] getConfsToResolve(String resolveId, String conf) {
        ModuleDescriptor reference = (ModuleDescriptor)this.getResolvedDescriptor(resolveId, false);
        if (reference == null) {
            if (conf == null) {
                return new String[]{"*"};
            }
            return this.splitConfs(conf);
        }
        String[] rconfs = (String[])this.getProject().getReference("ivy.resolved.configurations.ref." + resolveId);
        return this.getConfsToResolve(reference, conf, rconfs);
    }

    private String[] getConfsToResolve(ModuleDescriptor reference, String conf, String[] rconfs) {
        Message.debug("calculating configurations to resolve");
        if (reference == null) {
            Message.debug("module not yet resolved, all confs still need to be resolved");
            if (conf == null) {
                return new String[]{"*"};
            }
            return this.splitConfs(conf);
        }
        if (conf != null) {
            String[] confs = "*".equals(conf) ? reference.getConfigurationsNames() : this.splitConfs(conf);
            HashSet<String> rconfsSet = new HashSet<String>(Arrays.asList(rconfs));
            HashSet<String> confsSet = new HashSet<String>(Arrays.asList(confs));
            Message.debug("resolved configurations:   " + rconfsSet);
            Message.debug("asked configurations:      " + confsSet);
            confsSet.removeAll(rconfsSet);
            Message.debug("to resolve configurations: " + confsSet);
            return confsSet.toArray(new String[confsSet.size()]);
        }
        Message.debug("module already resolved, no configuration to resolve");
        return new String[0];
    }

    protected IvyResolve createResolve(boolean haltOnFailure, boolean useOrigin) {
        Message.verbose("no resolved descriptor found: launching default resolve");
        IvyResolve resolve = new IvyResolve();
        resolve.setTaskName(this.getTaskName());
        resolve.setProject(this.getProject());
        resolve.setHaltonfailure(haltOnFailure);
        resolve.setUseOrigin(useOrigin);
        resolve.setValidate(this.isValidate());
        resolve.setKeep(this.isKeep());
        resolve.setLog(this.getLog());
        return resolve;
    }

    protected ModuleRevisionId getResolvedMrid() {
        return new ModuleRevisionId(this.getResolvedModuleId(), this.getRevision() == null ? Ivy.getWorkingRevision() : this.getRevision());
    }

    protected ModuleId getResolvedModuleId() {
        return this.isInline() ? new ModuleId(this.getOrganisation(), this.getModule() + "-caller") : new ModuleId(this.getOrganisation(), this.getModule());
    }

    protected ResolveReport getResolvedReport() {
        return this.getResolvedReport(this.getOrganisation(), this.isInline() ? this.getModule() + "-caller" : this.getModule(), this.resolveId);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public boolean isHaltonfailure() {
        return this.haltOnFailure;
    }

    public void setHaltonfailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void setCache(File cache) {
        this.cacheAttributeNotSupported();
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String rev) {
        this.revision = rev;
    }

    public Filter getArtifactFilter() {
        return this.artifactFilter;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean transitive) {
        this.transitive = transitive;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setResolveId(String resolveId) {
        this.resolveId = resolveId;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean isKeep() {
        return this.keep == null ? !this.isInline() : this.keep;
    }
}

