/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.ibex.nestedvm.Runtime;
import org.ibex.nestedvm.UnixRuntime;
import org.ibex.nestedvm.util.ELF;
import org.ibex.nestedvm.util.Seekable;

public class Interpreter
extends UnixRuntime
implements Cloneable {
    private int[] registers = new int[32];
    private int hi;
    private int lo;
    private int[] fpregs = new int[32];
    private int fcsr;
    private int pc;
    public String image;
    private ELF.Symtab symtab;
    private int gp;
    private ELF.Symbol userInfo;
    private int entryPoint;
    private int heapStart;
    private HashMap sourceLineCache;

    private final void setFC(boolean bl) {
        this.fcsr = this.fcsr & 0xFF7FFFFF | (bl ? 0x800000 : 0);
    }

    private final int roundingMode() {
        return this.fcsr & 3;
    }

    private final double getDouble(int n) {
        return Double.longBitsToDouble(((long)this.fpregs[n + 1] & 0xFFFFFFFFL) << 32 | (long)this.fpregs[n] & 0xFFFFFFFFL);
    }

    private final void setDouble(int n, double d) {
        long l = Double.doubleToLongBits(d);
        this.fpregs[n + 1] = (int)(l >>> 32);
        this.fpregs[n] = (int)l;
    }

    private final float getFloat(int n) {
        return Float.intBitsToFloat(this.fpregs[n]);
    }

    private final void setFloat(int n, float f) {
        this.fpregs[n] = Float.floatToRawIntBits(f);
    }

    protected void _execute() throws Runtime.ExecutionException {
        try {
            this.runSome();
        }
        catch (Runtime.ExecutionException executionException) {
            executionException.setLocation(Interpreter.toHex(this.pc) + ": " + this.sourceLine(this.pc));
            throw executionException;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        Interpreter interpreter = (Interpreter)super.clone();
        interpreter.registers = (int[])this.registers.clone();
        interpreter.fpregs = (int[])this.fpregs.clone();
        return interpreter;
    }

    private final int runSome() throws Runtime.FaultException, Runtime.ExecutionException {
        block222: {
            int n = 1 << this.pageShift >> 2;
            int[] nArray = this.registers;
            int[] nArray2 = this.fpregs;
            int n2 = this.pc;
            int n3 = n2 + 4;
            try {
                block211: while (true) {
                    int n4;
                    int n5;
                    try {
                        n5 = this.readPages[n2 >>> this.pageShift][n2 >>> 2 & n - 1];
                    }
                    catch (RuntimeException runtimeException) {
                        if (n2 == -559038737) {
                            throw new Error("fell off cpu: r2: " + nArray[2]);
                        }
                        n5 = this.memRead(n2);
                    }
                    int n6 = n5 >>> 26 & 0xFF;
                    int n7 = n5 >>> 21 & 0x1F;
                    int n8 = n5 >>> 16 & 0x1F;
                    int n9 = n5 >>> 16 & 0x1F;
                    int n10 = n5 >>> 11 & 0x1F;
                    int n11 = n5 >>> 11 & 0x1F;
                    int n12 = n5 >>> 6 & 0x1F;
                    int n13 = n5 >>> 6 & 0x1F;
                    int n14 = n5 & 0x3F;
                    int n15 = n5 & 0x3FFFFFF;
                    int n16 = n5 & 0xFFFF;
                    int n17 = n4 = n5 << 16 >> 16;
                    nArray[0] = 0;
                    block15 : switch (n6) {
                        case 0: {
                            int n18;
                            switch (n14) {
                                case 0: {
                                    if (n5 == 0) break block15;
                                    nArray[n10] = nArray[n8] << n12;
                                    break block15;
                                }
                                case 2: {
                                    nArray[n10] = nArray[n8] >>> n12;
                                    break block15;
                                }
                                case 3: {
                                    nArray[n10] = nArray[n8] >> n12;
                                    break block15;
                                }
                                case 4: {
                                    nArray[n10] = nArray[n8] << (nArray[n7] & 0x1F);
                                    break block15;
                                }
                                case 6: {
                                    nArray[n10] = nArray[n8] >>> (nArray[n7] & 0x1F);
                                    break block15;
                                }
                                case 7: {
                                    nArray[n10] = nArray[n8] >> (nArray[n7] & 0x1F);
                                    break block15;
                                }
                                case 8: {
                                    n18 = nArray[n7];
                                    n2 += 4;
                                    n3 = n18;
                                    continue block211;
                                }
                                case 9: {
                                    n18 = nArray[n7];
                                    nArray[n10] = (n2 += 4) + 4;
                                    n3 = n18;
                                    continue block211;
                                }
                                case 12: {
                                    this.pc = n2;
                                    nArray[2] = this.syscall(nArray[2], nArray[4], nArray[5], nArray[6], nArray[7], nArray[8], nArray[9]);
                                    if (this.state == 0) break block15;
                                    this.pc = n3;
                                    break block222;
                                }
                                case 13: {
                                    throw new Runtime.ExecutionException("Break");
                                }
                                case 16: {
                                    nArray[n10] = this.hi;
                                    break block15;
                                }
                                case 17: {
                                    this.hi = nArray[n7];
                                    break block15;
                                }
                                case 18: {
                                    nArray[n10] = this.lo;
                                    break block15;
                                }
                                case 19: {
                                    this.lo = nArray[n7];
                                    break block15;
                                }
                                case 24: {
                                    long l = (long)nArray[n7] * (long)nArray[n8];
                                    this.hi = (int)(l >>> 32);
                                    this.lo = (int)l;
                                    break block15;
                                }
                                case 25: {
                                    long l = ((long)nArray[n7] & 0xFFFFFFFFL) * ((long)nArray[n8] & 0xFFFFFFFFL);
                                    this.hi = (int)(l >>> 32);
                                    this.lo = (int)l;
                                    break block15;
                                }
                                case 26: {
                                    this.hi = nArray[n7] % nArray[n8];
                                    this.lo = nArray[n7] / nArray[n8];
                                    break block15;
                                }
                                case 27: {
                                    if (n8 == 0) break block15;
                                    this.hi = (int)(((long)nArray[n7] & 0xFFFFFFFFL) % ((long)nArray[n8] & 0xFFFFFFFFL));
                                    this.lo = (int)(((long)nArray[n7] & 0xFFFFFFFFL) / ((long)nArray[n8] & 0xFFFFFFFFL));
                                    break block15;
                                }
                                case 32: {
                                    throw new Runtime.ExecutionException("ADD (add with oveflow trap) not suported");
                                }
                                case 33: {
                                    nArray[n10] = nArray[n7] + nArray[n8];
                                    break block15;
                                }
                                case 34: {
                                    throw new Runtime.ExecutionException("SUB (sub with oveflow trap) not suported");
                                }
                                case 35: {
                                    nArray[n10] = nArray[n7] - nArray[n8];
                                    break block15;
                                }
                                case 36: {
                                    nArray[n10] = nArray[n7] & nArray[n8];
                                    break block15;
                                }
                                case 37: {
                                    nArray[n10] = nArray[n7] | nArray[n8];
                                    break block15;
                                }
                                case 38: {
                                    nArray[n10] = nArray[n7] ^ nArray[n8];
                                    break block15;
                                }
                                case 39: {
                                    nArray[n10] = ~(nArray[n7] | nArray[n8]);
                                    break block15;
                                }
                                case 42: {
                                    nArray[n10] = nArray[n7] < nArray[n8] ? 1 : 0;
                                    break block15;
                                }
                                case 43: {
                                    nArray[n10] = ((long)nArray[n7] & 0xFFFFFFFFL) < ((long)nArray[n8] & 0xFFFFFFFFL) ? 1 : 0;
                                    break block15;
                                }
                                default: {
                                    throw new Runtime.ExecutionException("Illegal instruction 0/" + n14);
                                }
                            }
                        }
                        case 1: {
                            int n18;
                            switch (n8) {
                                case 0: {
                                    if (nArray[n7] >= 0) break block15;
                                    n3 = n18 = (n2 += 4) + n17 * 4;
                                    continue block211;
                                }
                                case 1: {
                                    if (nArray[n7] < 0) break block15;
                                    n3 = n18 = (n2 += 4) + n17 * 4;
                                    continue block211;
                                }
                                case 16: {
                                    if (nArray[n7] >= 0) break block15;
                                    nArray[31] = (n2 += 4) + 4;
                                    n3 = n18 = n2 + n17 * 4;
                                    continue block211;
                                }
                                case 17: {
                                    if (nArray[n7] < 0) break block15;
                                    nArray[31] = (n2 += 4) + 4;
                                    n3 = n18 = n2 + n17 * 4;
                                    continue block211;
                                }
                                default: {
                                    throw new Runtime.ExecutionException("Illegal Instruction");
                                }
                            }
                        }
                        case 2: {
                            int n18 = n2 & 0xF0000000 | n15 << 2;
                            n2 += 4;
                            n3 = n18;
                            continue block211;
                        }
                        case 3: {
                            int n18 = n2 & 0xF0000000 | n15 << 2;
                            nArray[31] = (n2 += 4) + 4;
                            n3 = n18;
                            continue block211;
                        }
                        case 4: {
                            int n18;
                            if (nArray[n7] != nArray[n8]) break;
                            n3 = n18 = (n2 += 4) + n17 * 4;
                            continue block211;
                        }
                        case 5: {
                            int n18;
                            if (nArray[n7] == nArray[n8]) break;
                            n3 = n18 = (n2 += 4) + n17 * 4;
                            continue block211;
                        }
                        case 6: {
                            int n18;
                            if (nArray[n7] > 0) break;
                            n3 = n18 = (n2 += 4) + n17 * 4;
                            continue block211;
                        }
                        case 7: {
                            int n18;
                            if (nArray[n7] <= 0) break;
                            n3 = n18 = (n2 += 4) + n17 * 4;
                            continue block211;
                        }
                        case 8: {
                            nArray[n8] = nArray[n7] + n4;
                            break;
                        }
                        case 9: {
                            nArray[n8] = nArray[n7] + n4;
                            break;
                        }
                        case 10: {
                            nArray[n8] = nArray[n7] < n4 ? 1 : 0;
                            break;
                        }
                        case 11: {
                            nArray[n8] = ((long)nArray[n7] & 0xFFFFFFFFL) < ((long)n4 & 0xFFFFFFFFL) ? 1 : 0;
                            break;
                        }
                        case 12: {
                            nArray[n8] = nArray[n7] & n16;
                            break;
                        }
                        case 13: {
                            nArray[n8] = nArray[n7] | n16;
                            break;
                        }
                        case 14: {
                            nArray[n8] = nArray[n7] ^ n16;
                            break;
                        }
                        case 15: {
                            nArray[n8] = n16 << 16;
                            break;
                        }
                        case 16: {
                            throw new Runtime.ExecutionException("TLB/Exception support not implemented");
                        }
                        case 17: {
                            boolean bl;
                            int n18;
                            boolean bl2 = false;
                            String string = bl2 ? this.sourceLine(n2) : "";
                            boolean bl3 = bl = bl2 && (string.indexOf("dtoa.c:51") >= 0 || string.indexOf("dtoa.c:52") >= 0 || string.indexOf("test.c") >= 0);
                            if (n7 > 8 && bl) {
                                System.out.println("               FP Op: " + n6 + "/" + n7 + "/" + n14 + " " + string);
                            }
                            if (this.roundingMode() != 0 && n7 != 6 && (n7 != 16 && n7 != 17 || n14 != 36)) {
                                throw new Runtime.ExecutionException("Non-cvt.w.z operation attempted with roundingMode != round to nearest");
                            }
                            switch (n7) {
                                case 0: {
                                    nArray[n8] = nArray2[n10];
                                    break block15;
                                }
                                case 2: {
                                    if (n11 != 31) {
                                        throw new Runtime.ExecutionException("FCR " + n11 + " unavailable");
                                    }
                                    nArray[n8] = this.fcsr;
                                    break block15;
                                }
                                case 4: {
                                    nArray2[n10] = nArray[n8];
                                    break block15;
                                }
                                case 6: {
                                    if (n11 != 31) {
                                        throw new Runtime.ExecutionException("FCR " + n11 + " unavailable");
                                    }
                                    this.fcsr = nArray[n8];
                                    break block15;
                                }
                                case 8: {
                                    if ((this.fcsr & 0x800000) != 0 != ((n5 >>> 16 & 1) != 0)) break block15;
                                    n3 = n18 = (n2 += 4) + n17 * 4;
                                    continue block211;
                                }
                                case 16: {
                                    switch (n14) {
                                        case 0: {
                                            this.setFloat(n13, this.getFloat(n11) + this.getFloat(n9));
                                            break block15;
                                        }
                                        case 1: {
                                            this.setFloat(n13, this.getFloat(n11) - this.getFloat(n9));
                                            break block15;
                                        }
                                        case 2: {
                                            this.setFloat(n13, this.getFloat(n11) * this.getFloat(n9));
                                            break block15;
                                        }
                                        case 3: {
                                            this.setFloat(n13, this.getFloat(n11) / this.getFloat(n9));
                                            break block15;
                                        }
                                        case 5: {
                                            this.setFloat(n13, Math.abs(this.getFloat(n11)));
                                            break block15;
                                        }
                                        case 6: {
                                            nArray2[n13] = nArray2[n11];
                                            break block15;
                                        }
                                        case 7: {
                                            this.setFloat(n13, -this.getFloat(n11));
                                            break block15;
                                        }
                                        case 33: {
                                            this.setDouble(n13, this.getFloat(n11));
                                            break block15;
                                        }
                                        case 36: {
                                            switch (this.roundingMode()) {
                                                case 0: {
                                                    nArray2[n13] = (int)Math.floor(this.getFloat(n11) + 0.5f);
                                                    break;
                                                }
                                                case 1: {
                                                    nArray2[n13] = (int)this.getFloat(n11);
                                                    break;
                                                }
                                                case 2: {
                                                    nArray2[n13] = (int)Math.ceil(this.getFloat(n11));
                                                    break;
                                                }
                                                case 3: {
                                                    nArray2[n13] = (int)Math.floor(this.getFloat(n11));
                                                }
                                            }
                                            break block15;
                                        }
                                        case 50: {
                                            this.setFC(this.getFloat(n11) == this.getFloat(n9));
                                            break block15;
                                        }
                                        case 60: {
                                            this.setFC(this.getFloat(n11) < this.getFloat(n9));
                                            break block15;
                                        }
                                        case 62: {
                                            this.setFC(this.getFloat(n11) <= this.getFloat(n9));
                                            break block15;
                                        }
                                    }
                                    throw new Runtime.ExecutionException("Invalid Instruction 17/" + n7 + "/" + n14 + " at " + this.sourceLine(n2));
                                }
                                case 17: {
                                    switch (n14) {
                                        case 0: {
                                            this.setDouble(n13, this.getDouble(n11) + this.getDouble(n9));
                                            break block15;
                                        }
                                        case 1: {
                                            if (bl) {
                                                System.out.println("f" + n13 + " = f" + n11 + " (" + this.getDouble(n11) + ") - f" + n9 + " (" + this.getDouble(n9) + ")");
                                            }
                                            this.setDouble(n13, this.getDouble(n11) - this.getDouble(n9));
                                            break block15;
                                        }
                                        case 2: {
                                            if (bl) {
                                                System.out.println("f" + n13 + " = f" + n11 + " (" + this.getDouble(n11) + ") * f" + n9 + " (" + this.getDouble(n9) + ")");
                                            }
                                            this.setDouble(n13, this.getDouble(n11) * this.getDouble(n9));
                                            if (!bl) break block15;
                                            System.out.println("f" + n13 + " = " + this.getDouble(n13));
                                            break block15;
                                        }
                                        case 3: {
                                            this.setDouble(n13, this.getDouble(n11) / this.getDouble(n9));
                                            break block15;
                                        }
                                        case 5: {
                                            this.setDouble(n13, Math.abs(this.getDouble(n11)));
                                            break block15;
                                        }
                                        case 6: {
                                            nArray2[n13] = nArray2[n11];
                                            nArray2[n13 + 1] = nArray2[n11 + 1];
                                            break block15;
                                        }
                                        case 7: {
                                            this.setDouble(n13, -this.getDouble(n11));
                                            break block15;
                                        }
                                        case 32: {
                                            this.setFloat(n13, (float)this.getDouble(n11));
                                            break block15;
                                        }
                                        case 36: {
                                            if (bl) {
                                                System.out.println("CVT.W.D rm: " + this.roundingMode() + " f" + n11 + ":" + this.getDouble(n11));
                                            }
                                            switch (this.roundingMode()) {
                                                case 0: {
                                                    nArray2[n13] = (int)Math.floor(this.getDouble(n11) + 0.5);
                                                    break;
                                                }
                                                case 1: {
                                                    nArray2[n13] = (int)this.getDouble(n11);
                                                    break;
                                                }
                                                case 2: {
                                                    nArray2[n13] = (int)Math.ceil(this.getDouble(n11));
                                                    break;
                                                }
                                                case 3: {
                                                    nArray2[n13] = (int)Math.floor(this.getDouble(n11));
                                                }
                                            }
                                            if (!bl) break block15;
                                            System.out.println("CVT.W.D: f" + n13 + ":" + nArray2[n13]);
                                            break block15;
                                        }
                                        case 50: {
                                            this.setFC(this.getDouble(n11) == this.getDouble(n9));
                                            break block15;
                                        }
                                        case 60: {
                                            this.setFC(this.getDouble(n11) < this.getDouble(n9));
                                            break block15;
                                        }
                                        case 62: {
                                            this.setFC(this.getDouble(n11) <= this.getDouble(n9));
                                            break block15;
                                        }
                                        default: {
                                            throw new Runtime.ExecutionException("Invalid Instruction 17/" + n7 + "/" + n14 + " at " + this.sourceLine(n2));
                                        }
                                    }
                                }
                                case 20: {
                                    switch (n14) {
                                        case 32: {
                                            this.setFloat(n13, nArray2[n11]);
                                            break block15;
                                        }
                                        case 33: {
                                            this.setDouble(n13, nArray2[n11]);
                                            break block15;
                                        }
                                    }
                                    throw new Runtime.ExecutionException("Invalid Instruction 17/" + n7 + "/" + n14 + " at " + this.sourceLine(n2));
                                }
                                default: {
                                    throw new Runtime.ExecutionException("Invalid Instruction 17/" + n7);
                                }
                            }
                        }
                        case 18: 
                        case 19: {
                            throw new Runtime.ExecutionException("No coprocessor installed");
                        }
                        case 32: {
                            int n18;
                            int n19 = nArray[n7] + n4;
                            try {
                                n18 = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n18 = this.memRead(n19 & 0xFFFFFFFC);
                            }
                            switch (n19 & 3) {
                                case 0: {
                                    n18 = n18 >>> 24 & 0xFF;
                                    break;
                                }
                                case 1: {
                                    n18 = n18 >>> 16 & 0xFF;
                                    break;
                                }
                                case 2: {
                                    n18 = n18 >>> 8 & 0xFF;
                                    break;
                                }
                                case 3: {
                                    n18 = n18 >>> 0 & 0xFF;
                                }
                            }
                            if ((n18 & 0x80) != 0) {
                                n18 |= 0xFFFFFF00;
                            }
                            nArray[n8] = n18;
                            break;
                        }
                        case 33: {
                            int n18;
                            int n19 = nArray[n7] + n4;
                            try {
                                n18 = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n18 = this.memRead(n19 & 0xFFFFFFFC);
                            }
                            switch (n19 & 3) {
                                case 0: {
                                    n18 = n18 >>> 16 & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    n18 = n18 >>> 0 & 0xFFFF;
                                    break;
                                }
                                default: {
                                    throw new Runtime.ReadFaultException(n19);
                                }
                            }
                            if ((n18 & 0x8000) != 0) {
                                n18 |= 0xFFFF0000;
                            }
                            nArray[n8] = n18;
                            break;
                        }
                        case 34: {
                            int n18;
                            int n19 = nArray[n7] + n4;
                            try {
                                n18 = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n18 = this.memRead(n19 & 0xFFFFFFFC);
                            }
                            switch (n19 & 3) {
                                case 0: {
                                    nArray[n8] = nArray[n8] & 0 | n18 << 0;
                                    break;
                                }
                                case 1: {
                                    nArray[n8] = nArray[n8] & 0xFF | n18 << 8;
                                    break;
                                }
                                case 2: {
                                    nArray[n8] = nArray[n8] & 0xFFFF | n18 << 16;
                                    break;
                                }
                                case 3: {
                                    nArray[n8] = nArray[n8] & 0xFFFFFF | n18 << 24;
                                }
                            }
                            break;
                        }
                        case 35: {
                            int n19 = nArray[n7] + n4;
                            try {
                                nArray[n8] = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                nArray[n8] = this.memRead(n19);
                            }
                            break;
                        }
                        case 36: {
                            int n18;
                            int n19 = nArray[n7] + n4;
                            try {
                                n18 = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n18 = this.memRead(n19);
                            }
                            switch (n19 & 3) {
                                case 0: {
                                    nArray[n8] = n18 >>> 24 & 0xFF;
                                    break;
                                }
                                case 1: {
                                    nArray[n8] = n18 >>> 16 & 0xFF;
                                    break;
                                }
                                case 2: {
                                    nArray[n8] = n18 >>> 8 & 0xFF;
                                    break;
                                }
                                case 3: {
                                    nArray[n8] = n18 >>> 0 & 0xFF;
                                }
                            }
                            break;
                        }
                        case 37: {
                            int n18;
                            int n19 = nArray[n7] + n4;
                            try {
                                n18 = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n18 = this.memRead(n19 & 0xFFFFFFFC);
                            }
                            switch (n19 & 3) {
                                case 0: {
                                    nArray[n8] = n18 >>> 16 & 0xFFFF;
                                    break block15;
                                }
                                case 2: {
                                    nArray[n8] = n18 >>> 0 & 0xFFFF;
                                    break block15;
                                }
                            }
                            throw new Runtime.ReadFaultException(n19);
                        }
                        case 38: {
                            int n18;
                            int n19 = nArray[n7] + n4;
                            try {
                                n18 = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n18 = this.memRead(n19 & 0xFFFFFFFC);
                            }
                            switch (n19 & 3) {
                                case 0: {
                                    nArray[n8] = nArray[n8] & 0xFFFFFF00 | n18 >>> 24;
                                    break;
                                }
                                case 1: {
                                    nArray[n8] = nArray[n8] & 0xFFFF0000 | n18 >>> 16;
                                    break;
                                }
                                case 2: {
                                    nArray[n8] = nArray[n8] & 0xFF000000 | n18 >>> 8;
                                    break;
                                }
                                case 3: {
                                    nArray[n8] = nArray[n8] & 0 | n18 >>> 0;
                                }
                            }
                            break;
                        }
                        case 40: {
                            int n18;
                            int n19 = nArray[n7] + n4;
                            try {
                                n18 = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n18 = this.memRead(n19 & 0xFFFFFFFC);
                            }
                            switch (n19 & 3) {
                                case 0: {
                                    n18 = n18 & 0xFFFFFF | (nArray[n8] & 0xFF) << 24;
                                    break;
                                }
                                case 1: {
                                    n18 = n18 & 0xFF00FFFF | (nArray[n8] & 0xFF) << 16;
                                    break;
                                }
                                case 2: {
                                    n18 = n18 & 0xFFFF00FF | (nArray[n8] & 0xFF) << 8;
                                    break;
                                }
                                case 3: {
                                    n18 = n18 & 0xFFFFFF00 | (nArray[n8] & 0xFF) << 0;
                                }
                            }
                            try {
                                this.writePages[n19 >>> this.pageShift][n19 >>> 2 & n - 1] = n18;
                            }
                            catch (RuntimeException runtimeException) {
                                this.memWrite(n19 & 0xFFFFFFFC, n18);
                            }
                            break;
                        }
                        case 41: {
                            int n18;
                            int n19 = nArray[n7] + n4;
                            try {
                                n18 = this.readPages[n19 >>> this.pageShift][n19 >>> 2 & n - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n18 = this.memRead(n19 & 0xFFFFFFFC);
                            }
                            switch (n19 & 3) {
                                case 0: {
                                    n18 = n18 & 0xFFFF | (nArray[n8] & 0xFFFF) << 16;
                                    break;
                                }
                                case 2: {
                                    n18 = n18 & 0xFFFF0000 | (nArray[n8] & 0xFFFF) << 0;
                                    break;
                                }
                                default: {
                                    throw new Runtime.WriteFaultException(n19);
                                }
                            }
                            try {
                                this.writePages[n19 >>> this.pageShift][n19 >>> 2 & n - 1] = n18;
                            }
                            catch (RuntimeException runtimeException) {
                                this.memWrite(n19 & 0xFFFFFFFC, n18);
                            }
                            break;
                        }
                        case 42: {
                            int n19 = nArray[n7] + n4;
                            int n18 = this.memRead(n19 & 0xFFFFFFFC);
                            switch (n19 & 3) {
                                case 0: {
                                    n18 = n18 & 0 | nArray[n8] >>> 0;
                                    break;
                                }
                                case 1: {
                                    n18 = n18 & 0xFF000000 | nArray[n8] >>> 8;
                                    break;
                                }
                                case 2: {
                                    n18 = n18 & 0xFFFF0000 | nArray[n8] >>> 16;
                                    break;
                                }
                                case 3: {
                                    n18 = n18 & 0xFFFFFF00 | nArray[n8] >>> 24;
                                }
                            }
                            try {
                                this.writePages[n19 >>> this.pageShift][n19 >>> 2 & n - 1] = n18;
                            }
                            catch (RuntimeException runtimeException) {
                                this.memWrite(n19 & 0xFFFFFFFC, n18);
                            }
                            break;
                        }
                        case 43: {
                            int n19 = nArray[n7] + n4;
                            try {
                                this.writePages[n19 >>> this.pageShift][n19 >>> 2 & n - 1] = nArray[n8];
                            }
                            catch (RuntimeException runtimeException) {
                                this.memWrite(n19 & 0xFFFFFFFC, nArray[n8]);
                            }
                            break;
                        }
                        case 46: {
                            int n19 = nArray[n7] + n4;
                            int n18 = this.memRead(n19 & 0xFFFFFFFC);
                            switch (n19 & 3) {
                                case 0: {
                                    n18 = n18 & 0xFFFFFF | nArray[n8] << 24;
                                    break;
                                }
                                case 1: {
                                    n18 = n18 & 0xFFFF | nArray[n8] << 16;
                                    break;
                                }
                                case 2: {
                                    n18 = n18 & 0xFF | nArray[n8] << 8;
                                    break;
                                }
                                case 3: {
                                    n18 = n18 & 0 | nArray[n8] << 0;
                                }
                            }
                            this.memWrite(n19 & 0xFFFFFFFC, n18);
                            break;
                        }
                        case 48: {
                            nArray[n8] = this.memRead(nArray[n7] + n4);
                            break;
                        }
                        case 49: {
                            nArray2[n8] = this.memRead(nArray[n7] + n4);
                            break;
                        }
                        case 56: {
                            this.memWrite(nArray[n7] + n4, nArray[n8]);
                            nArray[n8] = 1;
                            break;
                        }
                        case 57: {
                            this.memWrite(nArray[n7] + n4, nArray2[n8]);
                            break;
                        }
                        default: {
                            throw new Runtime.ExecutionException("Invalid Instruction: " + n6);
                        }
                    }
                    n2 = n3;
                    n3 = n2 + 4;
                }
            }
            catch (Runtime.ExecutionException executionException) {
                this.pc = n2;
                throw executionException;
            }
        }
        return 0;
    }

    public int lookupSymbol(String string) {
        ELF.Symbol symbol = this.symtab.getGlobalSymbol(string);
        return symbol == null ? -1 : symbol.addr;
    }

    protected int gp() {
        return this.gp;
    }

    protected int userInfoBae() {
        return this.userInfo == null ? 0 : this.userInfo.addr;
    }

    protected int userInfoSize() {
        return this.userInfo == null ? 0 : this.userInfo.size;
    }

    protected int entryPoint() {
        return this.entryPoint;
    }

    protected int heapStart() {
        return this.heapStart;
    }

    private void loadImage(Seekable seekable) throws IOException {
        ELF eLF = new ELF(seekable);
        this.symtab = eLF.getSymtab();
        if (eLF.header.type != 2) {
            throw new IOException("Binary is not an executable");
        }
        if (eLF.header.machine != 8) {
            throw new IOException("Binary is not for the MIPS I Architecture");
        }
        if (eLF.ident.data != 2) {
            throw new IOException("Binary is not big endian");
        }
        this.entryPoint = eLF.header.entry;
        ELF.Symtab symtab = eLF.getSymtab();
        if (symtab == null) {
            throw new IOException("No symtab in binary (did you strip it?)");
        }
        this.userInfo = symtab.getGlobalSymbol("user_info");
        ELF.Symbol symbol = symtab.getGlobalSymbol("_gp");
        if (symbol == null) {
            throw new IOException("NO _gp symbol!");
        }
        this.gp = symbol.addr;
        this.entryPoint = eLF.header.entry;
        ELF.PHeader[] pHeaderArray = eLF.pheaders;
        int n = 0;
        int n2 = 1 << this.pageShift;
        int n3 = 1 << this.pageShift >> 2;
        for (int i = 0; i < pHeaderArray.length; ++i) {
            ELF.PHeader pHeader = pHeaderArray[i];
            if (pHeader.type != 1) continue;
            int n4 = pHeader.memsz;
            int n5 = pHeader.filesz;
            if (n4 == 0) continue;
            if (n4 < 0) {
                throw new IOException("pheader size too large");
            }
            int n6 = pHeader.vaddr;
            if (n6 == 0) {
                throw new IOException("pheader vaddr == 0x0");
            }
            n = Interpreter.max(n6 + n4, n);
            for (int j = 0; j < n4 + n2 - 1; j += n2) {
                int n7 = j + n6 >>> this.pageShift;
                if (this.readPages[n7] == null) {
                    this.readPages[n7] = new int[n3];
                }
                if (!pHeader.writable()) continue;
                this.writePages[n7] = this.readPages[n7];
            }
            if (n5 == 0) continue;
            n5 &= 0xFFFFFFFC;
            DataInputStream dataInputStream = new DataInputStream(pHeader.getInputStream());
            do {
                this.readPages[n6 >>> this.pageShift][n6 >>> 2 & n3 - 1] = dataInputStream.readInt();
                n6 += 4;
            } while ((n5 -= 4) > 0);
            dataInputStream.close();
        }
        this.heapStart = n + n2 - 1 & ~(n2 - 1);
    }

    protected void setCPUState(Runtime.CPUState cPUState) {
        int n;
        for (n = 1; n < 32; ++n) {
            this.registers[n] = cPUState.r[n];
        }
        for (n = 0; n < 32; ++n) {
            this.fpregs[n] = cPUState.f[n];
        }
        this.hi = cPUState.hi;
        this.lo = cPUState.lo;
        this.fcsr = cPUState.fcsr;
        this.pc = cPUState.pc;
    }

    protected void getCPUState(Runtime.CPUState cPUState) {
        int n;
        for (n = 1; n < 32; ++n) {
            cPUState.r[n] = this.registers[n];
        }
        for (n = 0; n < 32; ++n) {
            cPUState.f[n] = this.fpregs[n];
        }
        cPUState.hi = this.hi;
        cPUState.lo = this.lo;
        cPUState.fcsr = this.fcsr;
        cPUState.pc = this.pc;
    }

    public Interpreter(Seekable seekable) throws IOException {
        super(4096, 65536);
        this.loadImage(seekable);
    }

    public Interpreter(String string) throws IOException {
        this(new Seekable.File(string, false));
        this.image = string;
    }

    public Interpreter(InputStream inputStream) throws IOException {
        this(new Seekable.InputStream(inputStream));
    }

    public String sourceLine(int n) {
        String string = this.sourceLineCache == null ? null : this.sourceLineCache.get(new Integer(n));
        if (string != null) {
            return string;
        }
        if (this.image == null) {
            return null;
        }
        try {
            Process process = java.lang.Runtime.getRuntime().exec(new String[]{"mips-unknown-elf-addr2line", "-e", this.image, Interpreter.toHex(n)});
            string = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
            if (string == null) {
                return null;
            }
            while (string.startsWith("../")) {
                string = string.substring(3);
            }
            if (this.sourceLineCache == null) {
                this.sourceLineCache = new HashMap();
            }
            this.sourceLineCache.put(new Integer(n), string);
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        Interpreter interpreter = new Interpreter(string);
        java.lang.Runtime.getRuntime().addShutdownHook(new Thread(interpreter.new DebugShutdownHook()));
        int n = interpreter.run(stringArray);
        System.err.println("Exit status: " + n);
        System.exit(n);
    }

    public class DebugShutdownHook
    implements Runnable {
        public void run() {
            int n = Interpreter.this.pc;
            if (Interpreter.this.getState() == 0) {
                System.err.print("\nCPU Executing " + Runtime.toHex(n) + ": " + Interpreter.this.sourceLine(n) + "\n");
            }
        }
    }
}

