/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.textui;

import com.kirkk.analyzer.Analyzer;
import com.kirkk.analyzer.Configuration;
import com.kirkk.analyzer.framework.Jar;
import com.kirkk.analyzer.textui.Summary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;

public class DOTSummary
implements Summary {
    private PrintWriter writer;

    public static void main(String[] stringArray) throws Exception {
        new DOTSummary().instanceMain(stringArray);
    }

    public void instanceMain(String[] stringArray) throws Exception {
        File file;
        File file2 = stringArray.length > 0 ? new File(stringArray[0]) : null;
        File file3 = file = stringArray.length > 1 ? new File(stringArray[1]) : null;
        if (file2 == null) {
            System.out.print("Please enter input directory name: ");
            file2 = this.getFile();
        }
        if (file == null) {
            System.out.print("Please enter output file name: ");
            file = this.getFile();
        }
        this.createSummary(file2, file);
    }

    public void createSummary(File file, File file2) throws Exception {
        Analyzer analyzer = new Analyzer();
        Jar[] jarArray = analyzer.analyze(file);
        this.outputAll(jarArray, file2);
    }

    public void createSummary(File file, File file2, String string, String string2) throws Exception {
        Analyzer analyzer = new Analyzer();
        Configuration.initialize(string, string2);
        Jar[] jarArray = analyzer.analyze(file);
        this.outputAll(jarArray, file2);
    }

    private File getFile() throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        File file = new File(string);
        return file;
    }

    private void outputAll(Jar[] jarArray, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            this.writer = new PrintWriter(fileWriter);
        }
        catch (IOException iOException) {
            System.out.println("IOException - Redirecting to System.out");
            System.out.println(iOException);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            this.writer = new PrintWriter(outputStreamWriter);
        }
        this.printHeader();
        this.output(jarArray);
        this.printFooter();
        this.writer.flush();
        this.writer.close();
    }

    private void printHeader() {
        this.writer.println("digraph G {");
    }

    private void printFooter() {
        this.writer.println("}");
    }

    private void output(Jar[] jarArray) {
        for (int i = 0; i < jarArray.length; ++i) {
            String string = jarArray[i].getJarFileName().substring(jarArray[i].getJarFileName().lastIndexOf("\\") + 1, jarArray[i].getJarFileName().length());
            this.externalJars(jarArray[i]);
        }
    }

    private void externalJars(Jar jar) {
        Iterator iterator = jar.getOutgoingDependencies().iterator();
        while (iterator.hasNext()) {
            String string = jar.getJarFileName().replaceAll("[-.]", "_");
            this.writer.print(this.tab() + string.substring(0, string.length() - 4));
            Jar jar2 = (Jar)iterator.next();
            String string2 = jar2.getJarFileName().replaceAll("[-.]", "_");
            this.writer.println(" -> " + string2.substring(0, string2.length() - 4) + ";");
        }
    }

    private String tab() {
        return "    ";
    }

    private String tab(int n) {
        String string = this.tab();
        for (int i = 0; i < n - 1; ++i) {
            string = string + this.tab();
        }
        return string;
    }
}

