/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.report.html.doc.Attribute;
import com.vladium.emma.report.html.doc.AttributeSet;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.IElement;
import com.vladium.emma.report.html.doc.Tag;

public final class HTMLTable
extends IElement.Factory.ElementImpl {
    private IElement m_caption;

    public HTMLTable(String width, String border, String cellpadding, String cellspacing) {
        super(Tag.TABLE, AttributeSet.create());
        AttributeSet attrs = this.getAttributes();
        if (width != null) {
            attrs.set(Attribute.WIDTH, width);
        }
        if (border != null) {
            attrs.set(Attribute.BORDER, border);
        }
        if (cellpadding != null) {
            attrs.set(Attribute.CELLPADDING, cellpadding);
        }
        if (cellspacing != null) {
            attrs.set(Attribute.CELLSPACING, cellspacing);
        }
    }

    public void setCaption(String align, String text, boolean nbsp) {
        this.m_caption = IElement.Factory.create(Tag.CAPTION);
        this.m_caption.getAttributes().set(Attribute.ALIGN, align);
        this.m_caption.setText(text, nbsp);
    }

    public IRow newTitleRow() {
        Row row = new Row(true);
        this.add(row);
        return row;
    }

    public IRow newRow() {
        Row row = new Row(false);
        this.add(row);
        return row;
    }

    public void emit(HTMLWriter out) {
        if (this.m_caption != null) {
            this.add(0, this.m_caption);
        }
        super.emit(out);
    }

    private static class Row
    extends IElement.Factory.ElementImpl
    implements IRow {
        private final boolean m_th;

        public ICell newCell() {
            Cell cell = new Cell(this.m_th ? Tag.TH : Tag.TD);
            this.add(cell);
            return cell;
        }

        Row(boolean th) {
            super(Tag.TR, AttributeSet.create());
            this.m_th = th;
        }
    }

    private static class Cell
    extends IElement.Factory.ElementImpl
    implements ICell {
        public ICell setColspan(int span) {
            this.getAttributes().set(Attribute.COLSPAN, span);
            return this;
        }

        Cell(Tag tag) {
            super(tag, AttributeSet.create());
        }
    }

    public static interface IRow
    extends IElement {
        public ICell newCell();
    }

    public static interface ICell
    extends IElement {
        public ICell setColspan(int var1);
    }
}

