/*
 * Decompiled with CFR 0.152.
 */
package fmpp.progresslisteners;

import fmpp.Engine;
import fmpp.ProgressListener;
import fmpp.util.FileUtil;
import fmpp.util.MiscUtil;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.Task;

public class AntProgressListener
implements ProgressListener {
    private int maxPathLength = 45;
    private Task antTask;
    private boolean quiet = false;
    private int errorCount;
    private int warningCount;
    private int executedCount;
    private int renderedCount;
    private int copiedCount;
    private int processedCount;
    private long startTime;

    public AntProgressListener(Task antTask) {
        this.antTask = antTask;
    }

    public AntProgressListener(Task antTask, boolean quiet) {
        this.antTask = antTask;
        this.quiet = quiet;
    }

    public void notifyProgressEvent(Engine engine, int event, File src, int pMode, Throwable error, Object param) {
        StringBuffer message = new StringBuffer();
        switch (event) {
            case 1: {
                this.errorCount = 0;
                this.warningCount = 0;
                this.processedCount = 0;
                this.executedCount = 0;
                this.renderedCount = 0;
                this.copiedCount = 0;
                this.startTime = System.currentTimeMillis();
                break;
            }
            case 2: 
            case 7: {
                if (this.quiet) break;
                if (event == 7) {
                    message.append("- Not modified: ");
                } else if (pMode == 1) {
                    message.append("- Executing: ");
                } else if (pMode == 2) {
                    message.append("- Copying: ");
                } else if (pMode == 4) {
                    message.append("- Rendering XML: ");
                } else if (pMode == 3) {
                    message.append("- Ignoring: ");
                } else {
                    message.append("- ???: ");
                }
                try {
                    message.append(FileUtil.compressPath(FileUtil.getRelativePath(engine.getSourceRoot(), src), this.maxPathLength));
                }
                catch (IOException exc) {
                    message.append("???");
                }
                this.antTask.log(message.toString());
                break;
            }
            case 3: {
                if (error != null) {
                    ++this.errorCount;
                    if (this.quiet) {
                        message.append("Error with ");
                        try {
                            message.append(FileUtil.getRelativePath(engine.getSourceRoot(), src));
                        }
                        catch (IOException exc) {
                            message.append("???");
                        }
                    } else {
                        message.append("Error");
                    }
                    if (!engine.getStopOnError()) {
                        message.append(": " + MiscUtil.causeMessages(error));
                    }
                    this.antTask.log(message.toString(), 0);
                    break;
                }
                ++this.processedCount;
                if (pMode == 2) {
                    ++this.copiedCount;
                    break;
                }
                if (pMode == 1) {
                    ++this.executedCount;
                    break;
                }
                if (pMode != 4) break;
                ++this.renderedCount;
                break;
            }
            case 6: {
                ++this.warningCount;
                message.append("Warning");
                try {
                    message.append(" from ");
                    message.append(FileUtil.getRelativePath(engine.getSourceRoot(), src));
                }
                catch (IOException exc) {
                    message.append(" from ???");
                }
                message.append(": ");
                message.append((String)param);
                this.antTask.log(message.toString(), 1);
                break;
            }
            case 5: {
                if (this.quiet) break;
                message.append("- Ignoring directory: ");
                try {
                    message.append(FileUtil.compressPath(FileUtil.getRelativePath(engine.getSourceRoot(), src), this.maxPathLength));
                }
                catch (IOException exc) {
                    message.append("???");
                }
                this.antTask.log(message.toString());
                break;
            }
            case 4: {
                if (error != null) {
                    this.antTask.log("Task aborted: " + MiscUtil.causeMessages(error), 0);
                } else if (this.errorCount != 0) {
                    this.antTask.log("Task finished with " + this.errorCount + " error(s).", 1);
                }
                if (this.quiet) break;
                this.antTask.log("Summary: " + this.executedCount + " exe. + " + this.renderedCount + " xml. + " + this.copiedCount + " cop. = " + this.processedCount + " succ.; " + this.warningCount + " warn.; " + this.errorCount + " failed");
                this.antTask.log("Time elapsed: " + (double)(System.currentTimeMillis() - this.startTime) / 1000.0 + " seconds", 3);
                break;
            }
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }
}

