/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.util;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.provider.synergy.util.SynergyRole;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SynergyCCM {
    private static final String CCM = "ccm";
    private static final String BASELINE = "baseline";
    private static final String CI = "ci";
    private static final String CO = "co";
    private static final String CREATE = "create";
    private static final String DELETE = "delete";
    private static final String DELIMITER = "delimiter";
    private static final String DIR = "dir";
    private static final String QUERY = "query";
    private static final String RECONCILE = "rwa";
    private static final String RECONFIGURE = "reconfigure";
    private static final String RECONFIGURE_PROPERTIES = "reconfigure_properties";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String SYNC = "sync";
    private static final String TASK = "task";
    private static final String WA = "wa";

    public static Commandline showTaskObjects(int taskNumber, String format, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(TASK);
        cl.createArgument().setValue("-show");
        cl.createArgument().setValue("objects");
        if (format != null && !format.equals("")) {
            cl.createArgument().setValue("-f");
            cl.createArgument().setValue(format);
        }
        cl.createArgument().setValue(Integer.toString(taskNumber));
        return cl;
    }

    public static Commandline query(String query, String format, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(QUERY);
        cl.createArgument().setValue("-u");
        if (format != null && !format.equals("")) {
            cl.createArgument().setValue("-f");
            cl.createArgument().setValue(format);
        }
        cl.createArgument().setValue(query);
        return cl;
    }

    public static Commandline createBaseline(String projectSpec, String name, String release, String purpose, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(BASELINE);
        cl.createArgument().setValue("-create");
        cl.createArgument().setValue(name);
        cl.createArgument().setValue("-p");
        cl.createArgument().setValue(projectSpec);
        cl.createArgument().setValue("-release");
        cl.createArgument().setValue(release);
        cl.createArgument().setValue("-purpose");
        cl.createArgument().setValue(purpose);
        return cl;
    }

    public static Commandline create(List files, String message, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(CREATE);
        if (message != null && !message.equals("")) {
            cl.createArgument().setValue("-c");
            cl.createArgument().setValue(message);
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            try {
                cl.createArgument().setValue(f.getCanonicalPath());
            }
            catch (IOException e) {
                throw new ScmException("Invalid file path " + f.toString(), (Throwable)e);
            }
        }
        return cl;
    }

    public static Commandline createTask(String synopsis, String release, boolean defaultTask, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(TASK);
        cl.createArgument().setValue("-create");
        cl.createArgument().setValue("-synopsis");
        cl.createArgument().setValue(synopsis);
        if (release != null && !release.equals("")) {
            cl.createArgument().setValue("-release");
            cl.createArgument().setValue(release);
        }
        if (defaultTask) {
            cl.createArgument().setValue("-default");
        }
        cl.createArgument().setValue("-description");
        cl.createArgument().setValue("This task was created by Maven SCM Synergy provider on " + Calendar.getInstance().getTime());
        return cl;
    }

    public static Commandline checkinTask(String taskSpecs, String comment, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(TASK);
        cl.createArgument().setValue("-checkin");
        cl.createArgument().setValue(taskSpecs);
        cl.createArgument().setValue("-comment");
        cl.createArgument().setValue(comment);
        return cl;
    }

    public static Commandline delete(List files, String ccmAddr, boolean replace) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(DELETE);
        if (replace) {
            cl.createArgument().setValue("-replace");
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            try {
                cl.createArgument().setValue(f.getCanonicalPath());
            }
            catch (IOException e) {
                throw new ScmException("Invalid file path " + f.toString(), (Throwable)e);
            }
        }
        return cl;
    }

    public static Commandline reconfigure(String projectSpec, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(RECONFIGURE);
        cl.createArgument().setValue("-recurse");
        if (projectSpec != null) {
            cl.createArgument().setValue("-p");
            cl.createArgument().setValue(projectSpec);
        }
        return cl;
    }

    public static Commandline reconfigureProperties(String projectSpec, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(RECONFIGURE_PROPERTIES);
        cl.createArgument().setValue("-refresh");
        cl.createArgument().setValue(projectSpec);
        return cl;
    }

    public static Commandline reconcileUwa(String projectSpec, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(RECONCILE);
        cl.createArgument().setValue("-r");
        cl.createArgument().setValue("-uwa");
        if (projectSpec != null) {
            cl.createArgument().setValue("-p");
            cl.createArgument().setValue(projectSpec);
        }
        return cl;
    }

    public static Commandline reconcileUdb(String projectSpec, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(RECONCILE);
        cl.createArgument().setValue("-r");
        cl.createArgument().setValue("-udb");
        if (projectSpec != null) {
            cl.createArgument().setValue("-p");
            cl.createArgument().setValue(projectSpec);
        }
        return cl;
    }

    public static Commandline dir(File directory, String format, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        try {
            cl.setWorkingDirectory(directory.getCanonicalPath());
        }
        catch (IOException e) {
            throw new ScmException("Invalid directory", (Throwable)e);
        }
        cl.setExecutable(CCM);
        cl.createArgument().setValue(DIR);
        cl.createArgument().setValue("-m");
        if (format != null && !format.equals("")) {
            cl.createArgument().setValue("-f");
            cl.createArgument().setValue(format);
        }
        return cl;
    }

    public static Commandline checkoutFiles(List files, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(CO);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            try {
                cl.createArgument().setValue(f.getCanonicalPath());
            }
            catch (IOException e) {
                throw new ScmException("Invalid file path " + f.toString(), (Throwable)e);
            }
        }
        return cl;
    }

    public static Commandline checkoutProject(File directory, String projectSpec, ScmVersion version, String purpose, String release, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(CO);
        cl.createArgument().setValue("-subprojects");
        cl.createArgument().setValue("-rel");
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            cl.createArgument().setValue("-t");
            cl.createArgument().setValue(version.getName());
        }
        if (purpose != null && !purpose.equals("")) {
            cl.createArgument().setValue("-purpose");
            cl.createArgument().setValue(purpose);
        }
        if (release != null && !release.equals("")) {
            cl.createArgument().setValue("-release");
            cl.createArgument().setValue(release);
        }
        if (directory != null) {
            cl.createArgument().setValue("-path");
            try {
                cl.createArgument().setValue(directory.getCanonicalPath());
            }
            catch (IOException e) {
                throw new ScmException("Invalid directory", (Throwable)e);
            }
        }
        cl.createArgument().setValue("-p");
        cl.createArgument().setValue(projectSpec);
        return cl;
    }

    public static Commandline checkinProject(String projectSpec, String comment, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(CI);
        if (comment != null && !comment.equals("")) {
            cl.createArgument().setValue("-c");
            cl.createArgument().setValue(comment);
        }
        cl.createArgument().setValue("-p");
        cl.createArgument().setValue(projectSpec);
        return cl;
    }

    public static Commandline checkinFiles(List files, String comment, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(CI);
        if (comment != null && !comment.equals("")) {
            cl.createArgument().setValue("-c");
            cl.createArgument().setValue(comment);
        }
        if (files.size() > 0) {
            Iterator i = files.iterator();
            while (i.hasNext()) {
                File f = (File)i.next();
                try {
                    cl.createArgument().setValue(f.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new ScmException("Invalid file path " + f.toString(), (Throwable)e);
                }
            }
        }
        return cl;
    }

    public static Commandline synchronize(String projectSpec, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(SYNC);
        cl.createArgument().setValue("-r");
        cl.createArgument().setValue("-p");
        cl.createArgument().setValue(projectSpec);
        return cl;
    }

    public static Commandline showWorkArea(String projectSpec, String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(WA);
        cl.createArgument().setValue("-show");
        cl.createArgument().setValue(projectSpec);
        return cl;
    }

    public static Commandline stop(String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(STOP);
        return cl;
    }

    private static void configureEnvironment(Commandline cl, String ccmAddr) throws ScmException {
        try {
            Properties envVars = CommandLineUtils.getSystemEnvVars();
            Iterator<Object> i = envVars.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (key.equalsIgnoreCase("CCM_ADDR")) continue;
                cl.addEnvironment(key, envVars.getProperty(key));
            }
        }
        catch (Exception e1) {
            throw new ScmException("Fail to add PATH environment variable.", (Throwable)e1);
        }
        cl.addEnvironment("CCM_ADDR", ccmAddr);
    }

    public static Commandline start(String username, String password, SynergyRole role) throws ScmException {
        Commandline cl = new Commandline();
        cl.setExecutable(CCM);
        cl.createArgument().setValue(START);
        cl.createArgument().setValue("-nogui");
        cl.createArgument().setValue("-m");
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("-n");
        cl.createArgument().setValue(username);
        cl.createArgument().setValue("-pw");
        cl.createArgument().setValue(password);
        if (role != null) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(role.toString());
        }
        return cl;
    }

    public static Commandline delimiter(String ccmAddr) throws ScmException {
        Commandline cl = new Commandline();
        SynergyCCM.configureEnvironment(cl, ccmAddr);
        cl.setExecutable(CCM);
        cl.createArgument().setValue(DELIMITER);
        return cl;
    }
}

