/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

abstract class JoinResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public long restrictionTime;
    protected boolean isRightOpen;
    protected ExecRow leftRow;
    protected ExecRow rightRow;
    protected ExecRow mergedRow;
    public NoPutResultSet leftResultSet;
    protected int leftNumCols;
    public NoPutResultSet rightResultSet;
    protected int rightNumCols;
    protected GeneratedMethod restriction;
    public boolean oneRowRightSide;
    public boolean notExistsRightSide;
    String userSuppliedOptimizerOverrides;

    JoinResultSet(NoPutResultSet noPutResultSet, int n, NoPutResultSet noPutResultSet2, int n2, Activation activation, GeneratedMethod generatedMethod, int n3, boolean bl, boolean bl2, double d, double d2, String string) {
        super(activation, n3, d, d2);
        this.leftResultSet = noPutResultSet;
        this.leftNumCols = n;
        this.rightResultSet = noPutResultSet2;
        this.rightNumCols = n2;
        this.restriction = generatedMethod;
        this.oneRowRightSide = bl;
        this.notExistsRightSide = bl2;
        this.userSuppliedOptimizerOverrides = string;
        this.recordConstructorTime();
    }

    void clearScanState() {
        this.leftRow = null;
        this.rightRow = null;
        this.mergedRow = null;
    }

    public void openCore() throws StandardException {
        this.clearScanState();
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        this.leftResultSet.openCore();
        this.leftRow = this.leftResultSet.getNextRowCore();
        if (this.leftRow != null) {
            this.openRight();
            ++this.rowsSeenLeft;
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.clearScanState();
        this.leftResultSet.reopenCore();
        this.leftRow = this.leftResultSet.getNextRowCore();
        if (this.leftRow != null) {
            this.openRight();
            ++this.rowsSeenLeft;
        } else if (this.isRightOpen) {
            this.closeRight();
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void close() throws StandardException {
        if (this.isOpen) {
            this.leftResultSet.close();
            if (this.isRightOpen) {
                this.closeRight();
            }
            super.close();
        }
        this.clearScanState();
    }

    public void finish() throws StandardException {
        this.leftResultSet.finish();
        this.rightResultSet.finish();
        super.finish();
    }

    public RowLocation getRowLocation() {
        return null;
    }

    public ExecRow getCurrentRow() {
        return null;
    }

    protected void openRight() throws StandardException {
        if (this.isRightOpen) {
            this.rightResultSet.reopenCore();
        } else {
            this.rightResultSet.openCore();
            this.isRightOpen = true;
        }
    }

    protected void closeRight() throws StandardException {
        this.rightResultSet.close();
        this.isRightOpen = false;
    }
}

