/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.util;

import info.bliki.wiki.tags.util.Attribute;

public class NodeAttribute
extends Attribute {
    private static final long serialVersionUID = -7794436167788452243L;
    protected char[] mText;
    protected int mNameStart;
    protected int mNameEnd;
    protected int mValueStart;
    protected int mValueEnd;

    public NodeAttribute(char[] text, int name_start, int name_end, int value_start, int value_end, char quote) {
        this.mText = text;
        this.mNameStart = name_start;
        this.mNameEnd = name_end;
        this.mName = name_end > name_start ? new String(this.mText, name_start, name_end - name_start) : null;
        this.mValueStart = value_start;
        this.mValueEnd = value_end;
        if (value_end > value_start) {
            this.mValue = new String(this.mText, value_start, value_end - value_start);
            this.mAssignment = "=";
        } else {
            this.mValue = null;
            this.mAssignment = null;
        }
        this.setQuote(quote);
    }

    private void init() {
        this.mText = null;
        this.mNameStart = -1;
        this.mNameEnd = -1;
        this.mValueStart = -1;
        this.mValueEnd = -1;
    }

    public NodeAttribute(String name, String assignment, String value, char quote) {
        super(name, assignment, value, quote);
        this.init();
    }

    public NodeAttribute(String name, String value, char quote) {
        super(name, value, quote);
        this.init();
    }

    public NodeAttribute(String value) throws IllegalArgumentException {
        super(value);
        this.init();
    }

    public NodeAttribute(String name, String value) {
        super(name, value);
        this.init();
    }

    public NodeAttribute(String name, String assignment, String value) {
        super(name, assignment, value);
        this.init();
    }

    public NodeAttribute() {
        this.init();
    }

    public String getName() {
        String ret = super.getName();
        if (ret == null && this.mText != null && this.mNameStart >= 0) {
            ret = new String(this.mText, this.mNameStart, this.mNameEnd - this.mNameStart);
            this.setName(ret);
        }
        return ret;
    }

    public void getName(StringBuilder buffer, String text) {
        String name = super.getName();
        if (name == null) {
            if (text != null && this.mNameStart >= 0) {
                buffer.append(text.substring(this.mNameStart, this.mNameEnd));
            }
        } else {
            buffer.append(name);
        }
    }

    public String getAssignment(String text) {
        String ret = super.getAssignment();
        if (ret == null && text != null && this.mNameEnd >= 0 && this.mValueStart >= 0) {
            ret = text.substring(this.mNameStart, this.mNameEnd);
            if (ret.endsWith("\"") || ret.endsWith("'")) {
                ret = ret.substring(0, ret.length() - 1);
            }
            this.setAssignment(ret);
        }
        return ret;
    }

    public void getAssignment(StringBuilder buffer, String text) {
        String assignment = super.getAssignment();
        if (assignment == null) {
            if (text != null && this.mNameEnd >= 0 && this.mValueStart >= 0) {
                buffer.append(text.substring(this.mNameStart, this.mNameEnd));
                int length = buffer.length() - 1;
                char ch = buffer.charAt(length);
                if ('\'' == ch || '\"' == ch) {
                    buffer.setLength(length);
                }
            }
        } else {
            buffer.append(assignment);
        }
    }

    public String getValue(String text) {
        String ret = super.getValue();
        if (ret == null && text != null && this.mValueEnd >= 0) {
            ret = text.substring(this.mValueStart, this.mValueEnd);
            this.setValue(ret);
        }
        return ret;
    }

    public void getValue(StringBuilder buffer, String text) {
        String value = super.getValue();
        if (value == null) {
            if (text != null && this.mValueEnd >= 0) {
                buffer.append(text.substring(this.mNameStart, this.mNameEnd));
            }
        } else {
            buffer.append(value);
        }
    }

    public String getRawValue() {
        char quote;
        String ret = this.getValue();
        if (ret != null && (quote = this.getQuote()) != '\u0000') {
            StringBuilder buffer = new StringBuilder(ret.length() + 2);
            buffer.append(quote);
            buffer.append(ret);
            buffer.append(quote);
            ret = buffer.toString();
        }
        return ret;
    }

    public void getRawValue(StringBuilder buffer, String text) {
        if (this.mValue == null) {
            if (this.mValueEnd >= 0) {
                char quote = this.getQuote();
                if (quote != '\u0000') {
                    buffer.append(quote);
                }
                if (this.mValueStart != this.mValueEnd) {
                    buffer.append(text.substring(this.mValueStart, this.mValueEnd));
                }
                if (quote != '\u0000') {
                    buffer.append(quote);
                }
            }
        } else {
            char quote = this.getQuote();
            if (quote != '\u0000') {
                buffer.append(quote);
            }
            buffer.append(this.mValue);
            if (quote != '\u0000') {
                buffer.append(quote);
            }
        }
    }

    public int getNameStartPosition() {
        return this.mNameStart;
    }

    public void setNameStartPosition(int start) {
        this.mNameStart = start;
        this.setName(null);
    }

    public int getNameEndPosition() {
        return this.mNameEnd;
    }

    public void setNameEndPosition(int end) {
        this.mNameEnd = end;
        this.setName(null);
        this.setAssignment(null);
    }

    public int getValueStartPosition() {
        return this.mValueStart;
    }

    public void setValueStartPosition(int start) {
        this.mValueStart = start;
        this.setAssignment(null);
        this.setValue(null);
    }

    public int getValueEndPosition() {
        return this.mValueEnd;
    }

    public void setValueEndPosition(int end) {
        this.mValueEnd = end;
        this.setValue(null);
    }

    public boolean isWhitespace() {
        return super.getName() == null || this.mNameStart < 0;
    }

    public boolean isStandAlone() {
        return !this.isWhitespace() && super.getAssignment() == null && !this.isValued() && (this.mText == null || this.mText != null && this.mNameEnd >= 0 && this.mValueStart < 0);
    }

    public boolean isEmpty() {
        return !this.isWhitespace() && !this.isStandAlone() && super.getValue() == null && (this.mText == null || this.mText != null && this.mValueEnd < 0);
    }

    public boolean isValued() {
        return super.getValue() != null || this.mText != null && this.mValueStart >= 0 && this.mValueEnd >= 0 && this.mValueStart != this.mValueEnd;
    }

    public int getLength() {
        int ret = 0;
        String name = super.getName();
        if (name != null) {
            ret += name.length();
        } else if (this.mNameStart >= 0 && this.mNameEnd >= 0) {
            ret += this.mNameEnd - this.mNameStart;
        }
        String assignment = super.getAssignment();
        if (assignment != null) {
            ret += assignment.length();
        } else if (this.mNameEnd >= 0 && this.mValueStart >= 0) {
            ret += this.mValueStart - this.mNameEnd;
        }
        String value = super.getValue();
        if (value != null) {
            ret += value.length();
        } else if (this.mValueStart >= 0 && this.mValueEnd >= 0) {
            ret += this.mValueEnd - this.mValueStart;
        }
        char quote = this.getQuote();
        if (quote != '\u0000') {
            ret += 2;
        }
        return ret;
    }
}

