/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data.taskdefs;

import com.nokia.helium.ant.data.Database;
import com.nokia.helium.ant.data.types.AntLintCheck;
import com.nokia.helium.ant.data.types.LintIssue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicElement;
import org.apache.tools.ant.Task;

public class AntConfigLintTask
extends Task
implements DynamicElement {
    public static final Map<String, String> CHECKS = new HashMap<String, String>(){
        {
            this.put("wrongtypepropertycheck", "WrongTypePropertyCheck");
        }
    };
    private List<AntLintCheck> checks = new ArrayList<AntLintCheck>();
    private List<LintIssue> issues = new ArrayList<LintIssue>();
    private Database db;
    private int errorsTotal;

    public AntConfigLintTask() throws IOException {
        this.setTaskName("antconfiglint");
    }

    public Object createDynamicElement(String name) {
        AntLintCheck check = null;
        String className = "com.nokia.helium.ant.data.types." + CHECKS.get(name);
        this.log("Creating check: " + className, 4);
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz != null) {
                check = (AntLintCheck)((Object)clazz.newInstance());
                this.checks.add(check);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new BuildException("Error in Antlint configuration: " + th.getMessage());
        }
        return check;
    }

    public void execute() {
        this.errorsTotal = 0;
        try {
            System.out.println(this.getProject());
            this.db = new Database(this.getProject());
            if (this.checks.size() == 0) {
                throw new BuildException("No checks defined.");
            }
            for (AntLintCheck check : this.checks) {
                check.setTask(this);
                this.log("Running check: " + (Object)((Object)check), 4);
                check.run();
            }
            for (LintIssue issue : this.issues) {
                this.log(issue.toString());
            }
            if (this.errorsTotal > 0) {
                throw new BuildException("AntLint errors found: " + this.errorsTotal);
            }
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage());
        }
    }

    public void addLintIssue(LintIssue issue) {
        this.issues.add(issue);
        if (issue.getSeverity() == 0) {
            ++this.errorsTotal;
        }
    }

    public Database getDatabase() {
        return this.db;
    }
}

