/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.AntMessageLogger;
import org.apache.ivy.ant.IvyAntVariableContainer;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerDispatcher;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;

public class IvyAntSettings
extends Task {
    public static final String OVERRIDE_TRUE = "true";
    public static final String OVERRIDE_FALSE = "false";
    public static final String OVERRIDE_NOT_ALLOWED = "notallowed";
    private static final Collection OVERRIDE_VALUES = Arrays.asList("true", "false", "notallowed");
    private Ivy ivyEngine = null;
    private File file = null;
    private URL url = null;
    private String realm = null;
    private String host = null;
    private String userName = null;
    private String passwd = null;
    private String id = "ivy.instance";
    private String override = "notallowed";

    public static IvyAntSettings getDefaultInstance(Project project) {
        Object defaultInstanceObj = project.getReference("ivy.instance");
        if (defaultInstanceObj != null && defaultInstanceObj.getClass().getClassLoader() != IvyAntSettings.class.getClassLoader()) {
            project.log("ivy.instance reference an ivy:settings defined in an other classloader.  An new default one will be used in this project.", 1);
            defaultInstanceObj = null;
        }
        if (defaultInstanceObj != null && !(defaultInstanceObj instanceof IvyAntSettings)) {
            throw new BuildException("ivy.instance reference a " + defaultInstanceObj.getClass().getName() + " an not an IvyAntSettings.  Please don't use this reference id ()");
        }
        if (defaultInstanceObj == null) {
            project.log("No ivy:settings found for the default reference 'ivy.instance'.  A default instance will be used", 2);
            IvyAntSettings defaultInstance = new IvyAntSettings();
            defaultInstance.setProject(project);
            defaultInstance.perform();
            return defaultInstance;
        }
        return (IvyAntSettings)((Object)defaultInstanceObj);
    }

    public File getFile() {
        return this.file;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String aPasswd) {
        this.passwd = aPasswd;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String aRealm) {
        this.realm = IvyAntSettings.format(aRealm);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String aHost) {
        this.host = IvyAntSettings.format(aHost);
    }

    public String getUsername() {
        return this.userName;
    }

    public void setUsername(String aUserName) {
        this.userName = IvyAntSettings.format(aUserName);
    }

    private static String format(String str) {
        return str == null ? str : (str.trim().length() == 0 ? null : str.trim());
    }

    public void addConfiguredCredentials(Credentials c) {
        CredentialsStore.INSTANCE.addCredentials(c.getRealm(), c.getHost(), c.getUsername(), c.getPasswd());
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setUrl(String confUrl) throws MalformedURLException {
        this.url = new URL(confUrl);
    }

    public void setOverride(String override) {
        if (!OVERRIDE_VALUES.contains(override)) {
            throw new IllegalArgumentException("invalid override value '" + override + "'. " + "Valid values are " + OVERRIDE_VALUES);
        }
        this.override = override;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Ivy getConfiguredIvyInstance() {
        if (this.ivyEngine == null) {
            this.perform();
        }
        return this.ivyEngine;
    }

    public void execute() throws BuildException {
        if (!OVERRIDE_TRUE.equals(this.override) && this.getProject().getReference(this.id) != null) {
            if (OVERRIDE_FALSE.equals(this.override)) {
                this.verbose("a settings definition is already available for " + this.id + ": skipping");
                return;
            }
            throw new BuildException("overriding a previous definition of ivy:settings with the id '" + this.id + "'" + " is not allowed when using override='" + OVERRIDE_NOT_ALLOWED + "'.");
        }
        this.getProject().addReference(this.id, (Object)this);
        Property prop = new Property(){

            public void execute() throws BuildException {
                this.addProperties(IvyAntSettings.this.getDefaultProperties());
            }
        };
        prop.setProject(this.getProject());
        prop.execute();
        this.createIvyEngine();
    }

    private void createIvyEngine() {
        IvyAntVariableContainer ivyAntVariableContainer = new IvyAntVariableContainer(this.getProject());
        IvySettings settings = new IvySettings(ivyAntVariableContainer);
        if (this.file == null && this.url == null) {
            this.defineDefaultSettingFile(ivyAntVariableContainer);
        }
        Ivy ivy = Ivy.newInstance(settings);
        ivy.getLoggerEngine().pushLogger(new AntMessageLogger((ProjectComponent)this));
        Message.showInfo();
        try {
            this.configureURLHandler();
            if (this.file != null) {
                if (!this.file.exists()) {
                    throw new BuildException("settings file does not exist: " + this.file);
                }
                ivy.configure(this.file);
            } else {
                if (this.url == null) {
                    throw new AssertionError((Object)"ivy setting should have either a file, either an url, and if not defineDefaultSettingFile must set it.");
                }
                ivy.configure(this.url);
            }
            ivyAntVariableContainer.updateProject(this.id);
            this.ivyEngine = ivy;
        }
        catch (ParseException e) {
            throw new BuildException("impossible to configure ivy:settings with given " + (this.file != null ? "file: " + this.file : "url :" + this.url) + " :" + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("impossible to configure ivy:settings with given " + (this.file != null ? "file: " + this.file : "url :" + this.url) + " :" + e, (Throwable)e);
        }
        finally {
            ivy.getLoggerEngine().popLogger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getDefaultProperties() {
        URL url = IvySettings.getDefaultPropertiesURL();
        Properties props = new Properties();
        this.verbose("Loading " + url);
        try {
            InputStream is = url.openStream();
            try {
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        return props;
    }

    private void defineDefaultSettingFile(IvyVariableContainer variableContainer) {
        String settingsFileName = variableContainer.getVariable("ivy.conf.file");
        if (settingsFileName != null && !settingsFileName.equals(variableContainer.getVariable("ivy.settings.file"))) {
            this.info("DEPRECATED: 'ivy.conf.file' is deprecated, use 'ivy.settings.file' instead");
        } else {
            settingsFileName = variableContainer.getVariable("ivy.settings.file");
        }
        File[] settingsLocations = new File[]{new File(this.getProject().getBaseDir(), settingsFileName), new File(this.getProject().getBaseDir(), "ivyconf.xml"), new File(settingsFileName), new File("ivyconf.xml")};
        for (int i = 0; i < settingsLocations.length; ++i) {
            this.file = settingsLocations[i];
            this.verbose("searching settings file: trying " + this.file);
            if (this.file.exists()) break;
        }
        if (!this.file.exists()) {
            if (Boolean.valueOf(this.getProject().getProperty("ivy.14.compatible")).booleanValue()) {
                this.info("no settings file found, using Ivy 1.4 default...");
                this.file = null;
                this.url = IvySettings.getDefault14SettingsURL();
            } else {
                this.info("no settings file found, using default...");
                this.file = null;
                this.url = IvySettings.getDefaultSettingsURL();
            }
        }
    }

    private void verbose(String msg) {
        this.log(msg, 3);
    }

    private void info(String msg) {
        this.log(msg, 2);
    }

    private void warn(String msg) {
        this.log(msg, 1);
    }

    private void configureURLHandler() {
        CredentialsStore.INSTANCE.addCredentials(this.getRealm(), this.getHost(), this.getUsername(), this.getPasswd());
        URLHandlerDispatcher dispatcher = new URLHandlerDispatcher();
        URLHandler httpHandler = URLHandlerRegistry.getHttp();
        dispatcher.setDownloader("http", httpHandler);
        dispatcher.setDownloader("https", httpHandler);
        URLHandlerRegistry.setDefault(dispatcher);
    }

    public static class Credentials {
        private String realm;
        private String host;
        private String username;
        private String passwd;

        public String getPasswd() {
            return this.passwd;
        }

        public void setPasswd(String passwd) {
            this.passwd = passwd;
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String realm) {
            this.realm = IvyAntSettings.format(realm);
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = IvyAntSettings.format(host);
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String userName) {
            this.username = IvyAntSettings.format(userName);
        }
    }
}

