/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.logger.ant.listener;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.util.StringUtils;

public class AntLogRecorderEntry
implements BuildLogger,
SubBuildListener {
    private String filename;
    private boolean record = true;
    private int loglevel = 2;
    private PrintStream out;
    private long targetStartTime;
    private boolean emacsMode;
    private Project project;
    private Pattern pattern;
    private Vector<String> logRegExps = new Vector();

    public AntLogRecorderEntry(String name) {
        this.targetStartTime = System.currentTimeMillis();
        this.filename = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setRecordState(Boolean state) {
        if (state != null) {
            this.flush();
            this.record = state;
        }
    }

    public void addRegexp(String regexp) {
        this.logRegExps.add(regexp);
    }

    public void resetRegExp() {
        this.logRegExps.clear();
    }

    public void buildStarted(BuildEvent event) {
        this.log("> BUILD STARTED", 4);
    }

    public void buildFinished(BuildEvent event) {
        this.log("< BUILD FINISHED", 4);
        if (this.record && this.out != null) {
            Throwable error = event.getException();
            if (error == null) {
                this.out.println(StringUtils.LINE_SEP + "BUILD SUCCESSFUL");
            } else {
                this.out.println(StringUtils.LINE_SEP + "BUILD FAILED" + StringUtils.LINE_SEP);
                error.printStackTrace(this.out);
            }
        }
        this.cleanup();
    }

    public void subBuildFinished(BuildEvent event) {
        if (event.getProject() == this.project) {
            this.cleanup();
        }
    }

    public void subBuildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
        this.log(">> TARGET STARTED -- " + event.getTarget(), 4);
        this.log(StringUtils.LINE_SEP + event.getTarget().getName() + ":", 2);
        this.targetStartTime = System.currentTimeMillis();
    }

    public void targetFinished(BuildEvent event) {
        this.log("<< TARGET FINISHED -- " + event.getTarget(), 4);
        String time = AntLogRecorderEntry.formatTime(System.currentTimeMillis() - this.targetStartTime);
        this.log(event.getTarget() + ":  duration " + time, 3);
        this.flush();
    }

    public void taskStarted(BuildEvent event) {
        this.log(">>> TASK STARTED -- " + event.getTask(), 4);
    }

    public void taskFinished(BuildEvent event) {
        this.log("<<< TASK FINISHED -- " + event.getTask(), 4);
        this.flush();
    }

    public void messageLogged(BuildEvent event) {
        this.log("--- MESSAGE LOGGED", 4);
        StringBuffer buf = new StringBuffer();
        if (event.getTask() != null) {
            String name = event.getTask().getTaskName();
            if (!this.emacsMode) {
                String label = "[" + name + "] ";
                int size = 12 - label.length();
                for (int i = 0; i < size; ++i) {
                    buf.append(" ");
                }
                buf.append(label);
            }
        }
        String messgeToUpdate = this.filterMessage(event.getMessage());
        buf.append(messgeToUpdate);
        this.log(buf.toString(), event.getPriority());
    }

    private String filterMessage(String message) {
        for (String regExp : this.logRegExps) {
            this.pattern = Pattern.compile(regExp);
            if (this.pattern == null) continue;
            Matcher match = this.pattern.matcher(message);
            message = match.replaceAll("********");
        }
        return message;
    }

    private void log(String mesg, int level) {
        if (this.record && level <= this.loglevel && this.out != null) {
            this.out.println(mesg);
        }
    }

    private void flush() {
        if (this.record && this.out != null) {
            this.out.flush();
        }
    }

    public void setMessageOutputLevel(int level) {
        if (level >= 0 && level <= 4) {
            this.loglevel = level;
        }
    }

    public void setOutputPrintStream(PrintStream output) {
        this.closeFile();
        this.out = output;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void setErrorPrintStream(PrintStream err) {
        this.setOutputPrintStream(err);
    }

    private static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        if (minutes > 0L) {
            return Long.toString(minutes) + " minute" + (minutes == 1L ? " " : "s ") + Long.toString(seconds % 60L) + " second" + (seconds % 60L == 1L ? "" : "s");
        }
        return Long.toString(seconds) + " second" + (seconds % 60L == 1L ? "" : "s");
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            project.addBuildListener((BuildListener)this);
        }
    }

    public void cleanup() {
        this.closeFile();
        if (this.project != null) {
            this.project.removeBuildListener((BuildListener)this);
        }
        this.project = null;
    }

    public void closeFile() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    public void openFile(boolean append) {
        this.openFileImpl(append);
    }

    public void reopenFile() {
        this.openFileImpl(true);
    }

    private void openFileImpl(boolean append) {
        if (this.out == null) {
            try {
                this.out = new PrintStream(new FileOutputStream(this.filename, append));
            }
            catch (IOException ioe) {
                throw new BuildException("Problems opening file using a recorder entry", (Throwable)ioe);
            }
        }
    }

    public void addLogMessage(String message) {
        this.out.println(StringUtils.LINE_SEP + message);
    }
}

